/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.calendar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.IDataProviderEntity;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Entity
@Table(name="appointment")
@NamedQueries(value={@NamedQuery(name="getAppointmentById", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.id = :id"), @NamedQuery(name="getAppointmentByIdAny", query="SELECT a FROM Appointment a WHERE a.id = :id"), @NamedQuery(name="getAppointments", query="SELECT a FROM Appointment a WHERE a.deleted = false ORDER BY a.id"), @NamedQuery(name="appointmentsInRange", query="SELECT a FROM Appointment a WHERE a.deleted = false \tAND ( \t\t(a.start BETWEEN :start AND :end) \t\tOR (a.end BETWEEN :start AND :end) \t\tOR (a.start < :start AND a.end > :end) \t)\tAND a.owner.id = :userId"), @NamedQuery(name="joinedAppointmentsInRange", query="SELECT a FROM MeetingMember mm INNER JOIN mm.appointment a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId \tAND a.id NOT IN (SELECT a.id FROM Appointment a WHERE a.owner.id = :userId)\tAND mm.connectedEvent = false \tAND ( \t\t(a.start BETWEEN :start AND :end) \t\tOR (a.end BETWEEN :start AND :end) \t\tOR (a.start < :start AND a.end > :end) \t)"), @NamedQuery(name="appointmentsInRangeRemind", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.reminderEmailSend = false AND (a.reminder <> :none) \tAND ( \t\t(a.start BETWEEN :start AND :end) \t\tOR (a.end BETWEEN :start AND :end) \t\tOR (a.start < :start AND a.end > :end) \t)"), @NamedQuery(name="getAppointmentByRoomId", query="SELECT a FROM Appointment a WHERE a.room.id = :roomId"), @NamedQuery(name="getAppointmentByOwnerRoomId", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.owner.id = :userId AND a.room.id = :roomId"), @NamedQuery(name="appointmentsInRangeByUser", query="SELECT a FROM MeetingMember mm, IN(mm.appointment) a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId \tAND ( \t\t(a.start BETWEEN :start AND :end) \t\tOR (a.end BETWEEN :start AND :end) \t\tOR (a.start < :start AND a.end > :end) \t)"), @NamedQuery(name="appointedRoomsInRangeByUser", query="SELECT a.room FROM MeetingMember mm, IN(mm.appointment) a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId \tAND ( \t\t(a.start BETWEEN :start AND :end) \t\tOR (a.end BETWEEN :start AND :end) \t\tOR (a.start < :start AND a.end > :end) \t)"), @NamedQuery(name="getNextAppointment", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.start > :start AND a.owner.id = :userId"), @NamedQuery(name="getAppointmentsByTitle", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.title LIKE :title AND a.owner.id = :userId")})
@Root(name="appointment")
public class Appointment
implements IDataProviderEntity,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int REMINDER_NONE_ID = 1;
    public static final int REMINDER_EMAIL_ID = 2;
    public static final int REMINDER_ICAL_ID = 3;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(name="appointmentId", data=true)
    private Long id;
    @Column(name="title")
    @Element(name="appointmentName", data=true, required=false)
    private String title;
    @Column(name="location")
    @Element(name="appointmentLocation", data=true, required=false)
    private String location;
    @Column(name="app_start")
    @Element(name="appointmentStarttime", data=true)
    private Date start;
    @Column(name="app_end")
    @Element(name="appointmentEndtime", data=true)
    private Date end;
    @Lob
    @Column(name="description", length=2048)
    @Element(name="appointmentDescription", data=true, required=false)
    private String description;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="user_id", nullable=true)
    @ForeignKey(enabled=true)
    @Element(name="users_id", data=true, required=false)
    private User owner;
    @Column(name="inserted")
    @Element(name="inserted", data=true, required=false)
    private Date inserted;
    @Column(name="updated")
    @Element(name="updated", data=true, required=false)
    private Date updated;
    @Column(name="deleted", nullable=false)
    @Element(data=true)
    private boolean deleted;
    @Column(name="reminder")
    @Enumerated(value=EnumType.STRING)
    @Element(name="typId", data=true, required=false)
    private Reminder reminder = Reminder.none;
    @Column(name="isdaily")
    @Element(data=true, required=false)
    private Boolean isDaily;
    @Column(name="isweekly")
    @Element(data=true, required=false)
    private Boolean isWeekly;
    @Column(name="ismonthly")
    @Element(data=true, required=false)
    private Boolean isMonthly;
    @Column(name="isyearly")
    @Element(data=true, required=false)
    private Boolean isYearly;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="room_id", nullable=true)
    @ForeignKey(enabled=true)
    @Element(name="room_id", data=true, required=false)
    private Room room;
    @Column(name="icalId")
    @Element(data=true, required=false)
    private String icalId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="appointment_id")
    private List<MeetingMember> meetingMembers;
    @Column(name="language_id")
    @Element(name="language_id", data=true, required=false)
    private Long languageId;
    @Column(name="is_password_protected", nullable=false)
    @Element(name="isPasswordProtected", data=true, required=false)
    private boolean passwordProtected;
    @Column(name="password")
    @Element(data=true, required=false)
    private String password;
    @Column(name="is_connected_event", nullable=false)
    private boolean connectedEvent;
    @Column(name="is_reminder_email_send", nullable=false)
    private boolean reminderEmailSend;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$calendar$Appointment$Reminder;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$room$Room;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$calendar$Appointment;
    private transient Object pcDetachedState;

    @Override
    public Long getId() {
        return Appointment.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Appointment.pcSetid(this, id);
    }

    public User getOwner() {
        return Appointment.pcGetowner(this);
    }

    public void setOwner(User owner) {
        Appointment.pcSetowner(this, owner);
    }

    public String getTitle() {
        return Appointment.pcGettitle(this);
    }

    public void setTitle(String title) {
        Appointment.pcSettitle(this, title);
    }

    public String getLocation() {
        return Appointment.pcGetlocation(this);
    }

    public void setLocation(String location) {
        Appointment.pcSetlocation(this, location);
    }

    public Date getStart() {
        return Appointment.pcGetstart(this);
    }

    public Calendar startCalendar(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(Appointment.pcGetstart(this));
        return cal;
    }

    public void setStart(Date start) {
        Appointment.pcSetstart(this, start);
    }

    public Date getEnd() {
        return Appointment.pcGetend(this);
    }

    public Calendar endCalendar(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(Appointment.pcGetend(this));
        return cal;
    }

    public void setEnd(Date end) {
        Appointment.pcSetend(this, end);
    }

    public String getDescription() {
        return Appointment.pcGetdescription(this);
    }

    public void setDescription(String description) {
        Appointment.pcSetdescription(this, description);
    }

    public Reminder getReminder() {
        return Appointment.pcGetreminder(this);
    }

    public void setReminder(Reminder reminder) {
        Appointment.pcSetreminder(this, reminder);
    }

    public Date getInserted() {
        return Appointment.pcGetinserted(this);
    }

    public void setInserted(Date inserted) {
        Appointment.pcSetinserted(this, inserted);
    }

    public Date getUpdated() {
        return Appointment.pcGetupdated(this);
    }

    public void setUpdated(Date updated) {
        Appointment.pcSetupdated(this, updated);
    }

    public boolean isDeleted() {
        return Appointment.pcGetdeleted(this);
    }

    public void setDeleted(boolean deleted) {
        Appointment.pcSetdeleted(this, deleted);
    }

    public Boolean getIsWeekly() {
        return Appointment.pcGetisWeekly(this);
    }

    public void setIsWeekly(Boolean isWeekly) {
        Appointment.pcSetisWeekly(this, isWeekly);
    }

    public Boolean getIsMonthly() {
        return Appointment.pcGetisMonthly(this);
    }

    public void setIsMonthly(Boolean isMonthly) {
        Appointment.pcSetisMonthly(this, isMonthly);
    }

    public Boolean getIsYearly() {
        return Appointment.pcGetisYearly(this);
    }

    public void setIsYearly(Boolean isYearly) {
        Appointment.pcSetisYearly(this, isYearly);
    }

    public Boolean getIsDaily() {
        return Appointment.pcGetisDaily(this);
    }

    public void setIsDaily(Boolean isDaily) {
        Appointment.pcSetisDaily(this, isDaily);
    }

    public List<MeetingMember> getMeetingMembers() {
        return Appointment.pcGetmeetingMembers(this);
    }

    public void setMeetingMembers(List<MeetingMember> meetingMembers) {
        Appointment.pcSetmeetingMembers(this, meetingMembers);
    }

    public Room getRoom() {
        return Appointment.pcGetroom(this);
    }

    public void setRoom(Room room) {
        Appointment.pcSetroom(this, room);
    }

    public String getIcalId() {
        return Appointment.pcGeticalId(this);
    }

    public void setIcalId(String icalId) {
        Appointment.pcSeticalId(this, icalId);
    }

    public Long getLanguageId() {
        return Appointment.pcGetlanguageId(this);
    }

    public void setLanguageId(Long languageId) {
        Appointment.pcSetlanguageId(this, languageId);
    }

    public boolean isPasswordProtected() {
        return Appointment.pcGetpasswordProtected(this);
    }

    public void setPasswordProtected(boolean isPasswordProtected) {
        Appointment.pcSetpasswordProtected(this, isPasswordProtected);
    }

    public String getPassword() {
        return Appointment.pcGetpassword(this);
    }

    public void setPassword(String password) {
        Appointment.pcSetpassword(this, password);
    }

    public boolean isConnectedEvent() {
        return Appointment.pcGetconnectedEvent(this);
    }

    public void setConnectedEvent(boolean isConnectedEvent) {
        Appointment.pcSetconnectedEvent(this, isConnectedEvent);
    }

    public boolean isReminderEmailSend() {
        return Appointment.pcGetreminderEmailSend(this);
    }

    public void setReminderEmailSend(boolean isReminderEmailSend) {
        Appointment.pcSetreminderEmailSend(this, isReminderEmailSend);
    }

    public String toString() {
        return "Appointment [id=" + Appointment.pcGetid(this) + ", title=" + Appointment.pcGettitle(this) + ", start=" + Appointment.pcGetstart(this) + ", end=" + Appointment.pcGetend(this) + ", owner=" + Appointment.pcGetowner(this) + ", deleted=" + Appointment.pcGetdeleted(this) + ", icalId=" + Appointment.pcGeticalId(this) + "]";
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"connectedEvent", "deleted", "description", "end", "icalId", "id", "inserted", "isDaily", "isMonthly", "isWeekly", "isYearly", "languageId", "location", "meetingMembers", "owner", "password", "passwordProtected", "reminder", "reminderEmailSend", "room", "start", "title", "updated"};
        Class[] classArray = new Class[23];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Boolean.TYPE;
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Appointment.class$("java.lang.String"));
        classArray[2] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Appointment.class$("java.util.Date"));
        classArray[3] = clazz2;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Appointment.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Appointment.class$("java.lang.Long"));
        classArray[5] = clazz3;
        classArray[6] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Appointment.class$("java.util.Date"));
        Class clazz4 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Appointment.class$("java.lang.Boolean"));
        classArray[7] = clazz4;
        classArray[8] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Appointment.class$("java.lang.Boolean"));
        classArray[9] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Appointment.class$("java.lang.Boolean"));
        classArray[10] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Appointment.class$("java.lang.Boolean"));
        classArray[11] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Appointment.class$("java.lang.Long"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Appointment.class$("java.lang.String"));
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Appointment.class$("java.util.List"));
        classArray[13] = clazz5;
        Class clazz6 = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = Appointment.class$("org.apache.openmeetings.db.entity.user.User"));
        classArray[14] = clazz6;
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Appointment.class$("java.lang.String"));
        classArray[16] = Boolean.TYPE;
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$calendar$Appointment$Reminder != null ? class$Lorg$apache$openmeetings$db$entity$calendar$Appointment$Reminder : (class$Lorg$apache$openmeetings$db$entity$calendar$Appointment$Reminder = Appointment.class$("org.apache.openmeetings.db.entity.calendar.Appointment$Reminder"));
        classArray[17] = clazz7;
        classArray[18] = Boolean.TYPE;
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Appointment.class$("org.apache.openmeetings.db.entity.room.Room"));
        classArray[19] = clazz8;
        classArray[20] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Appointment.class$("java.util.Date"));
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Appointment.class$("java.lang.String"));
        classArray[22] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Appointment.class$("java.util.Date"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz9 = class$Lorg$apache$openmeetings$db$entity$calendar$Appointment != null ? class$Lorg$apache$openmeetings$db$entity$calendar$Appointment : (class$Lorg$apache$openmeetings$db$entity$calendar$Appointment = Appointment.class$("org.apache.openmeetings.db.entity.calendar.Appointment"));
        PCRegistry.register((Class)clazz9, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Appointment", (PersistenceCapable)new Appointment());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.connectedEvent = false;
        this.deleted = false;
        this.description = null;
        this.end = null;
        this.icalId = null;
        this.id = null;
        this.inserted = null;
        this.isDaily = null;
        this.isMonthly = null;
        this.isWeekly = null;
        this.isYearly = null;
        this.languageId = null;
        this.location = null;
        this.meetingMembers = null;
        this.owner = null;
        this.password = null;
        this.passwordProtected = false;
        this.reminder = null;
        this.reminderEmailSend = false;
        this.room = null;
        this.start = null;
        this.title = null;
        this.updated = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Appointment appointment = new Appointment();
        if (bl) {
            appointment.pcClearFields();
        }
        appointment.pcStateManager = stateManager;
        appointment.pcCopyKeyFieldsFromObjectId(object);
        return appointment;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Appointment appointment = new Appointment();
        if (bl) {
            appointment.pcClearFields();
        }
        appointment.pcStateManager = stateManager;
        return appointment;
    }

    protected static int pcGetManagedFieldCount() {
        return 23;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.connectedEvent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.deleted = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.end = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.icalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.inserted = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.isDaily = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.isMonthly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.isWeekly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.isYearly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.languageId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.location = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.meetingMembers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.owner = (User)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.passwordProtected = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.reminder = (Reminder)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 18: {
                this.reminderEmailSend = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.room = (Room)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.start = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.title = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.updated = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.connectedEvent);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.deleted);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.end);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.icalId);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inserted);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isDaily);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isMonthly);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isWeekly);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isYearly);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.languageId);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.location);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.meetingMembers);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.owner);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 16: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.passwordProtected);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.reminder);
                return;
            }
            case 18: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.reminderEmailSend);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.room);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.start);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.title);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updated);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Appointment appointment, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.connectedEvent = appointment.connectedEvent;
                return;
            }
            case 1: {
                this.deleted = appointment.deleted;
                return;
            }
            case 2: {
                this.description = appointment.description;
                return;
            }
            case 3: {
                this.end = appointment.end;
                return;
            }
            case 4: {
                this.icalId = appointment.icalId;
                return;
            }
            case 5: {
                this.id = appointment.id;
                return;
            }
            case 6: {
                this.inserted = appointment.inserted;
                return;
            }
            case 7: {
                this.isDaily = appointment.isDaily;
                return;
            }
            case 8: {
                this.isMonthly = appointment.isMonthly;
                return;
            }
            case 9: {
                this.isWeekly = appointment.isWeekly;
                return;
            }
            case 10: {
                this.isYearly = appointment.isYearly;
                return;
            }
            case 11: {
                this.languageId = appointment.languageId;
                return;
            }
            case 12: {
                this.location = appointment.location;
                return;
            }
            case 13: {
                this.meetingMembers = appointment.meetingMembers;
                return;
            }
            case 14: {
                this.owner = appointment.owner;
                return;
            }
            case 15: {
                this.password = appointment.password;
                return;
            }
            case 16: {
                this.passwordProtected = appointment.passwordProtected;
                return;
            }
            case 17: {
                this.reminder = appointment.reminder;
                return;
            }
            case 18: {
                this.reminderEmailSend = appointment.reminderEmailSend;
                return;
            }
            case 19: {
                this.room = appointment.room;
                return;
            }
            case 20: {
                this.start = appointment.start;
                return;
            }
            case 21: {
                this.title = appointment.title;
                return;
            }
            case 22: {
                this.updated = appointment.updated;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Appointment appointment = (Appointment)object;
        if (appointment.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(appointment, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(5 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$calendar$Appointment != null ? class$Lorg$apache$openmeetings$db$entity$calendar$Appointment : (class$Lorg$apache$openmeetings$db$entity$calendar$Appointment = Appointment.class$("org.apache.openmeetings.db.entity.calendar.Appointment"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$calendar$Appointment != null ? class$Lorg$apache$openmeetings$db$entity$calendar$Appointment : (class$Lorg$apache$openmeetings$db$entity$calendar$Appointment = Appointment.class$("org.apache.openmeetings.db.entity.calendar.Appointment"));
        return new LongId(clazz, this.id);
    }

    private static final boolean pcGetconnectedEvent(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.connectedEvent;
        }
        int n = pcInheritedFieldCount + 0;
        appointment.pcStateManager.accessingField(n);
        return appointment.connectedEvent;
    }

    private static final void pcSetconnectedEvent(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.connectedEvent = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 0, appointment.connectedEvent, bl, 0);
    }

    private static final boolean pcGetdeleted(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.deleted;
        }
        int n = pcInheritedFieldCount + 1;
        appointment.pcStateManager.accessingField(n);
        return appointment.deleted;
    }

    private static final void pcSetdeleted(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.deleted = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 1, appointment.deleted, bl, 0);
    }

    private static final String pcGetdescription(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.description;
        }
        int n = pcInheritedFieldCount + 2;
        appointment.pcStateManager.accessingField(n);
        return appointment.description;
    }

    private static final void pcSetdescription(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.description = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 2, appointment.description, string, 0);
    }

    private static final Date pcGetend(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.end;
        }
        int n = pcInheritedFieldCount + 3;
        appointment.pcStateManager.accessingField(n);
        return appointment.end;
    }

    private static final void pcSetend(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.end = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 3, (Object)appointment.end, (Object)date, 0);
    }

    private static final String pcGeticalId(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.icalId;
        }
        int n = pcInheritedFieldCount + 4;
        appointment.pcStateManager.accessingField(n);
        return appointment.icalId;
    }

    private static final void pcSeticalId(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.icalId = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 4, appointment.icalId, string, 0);
    }

    private static final Long pcGetid(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.id;
        }
        int n = pcInheritedFieldCount + 5;
        appointment.pcStateManager.accessingField(n);
        return appointment.id;
    }

    private static final void pcSetid(Appointment appointment, Long l) {
        if (appointment.pcStateManager == null) {
            appointment.id = l;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 5, (Object)appointment.id, (Object)l, 0);
    }

    private static final Date pcGetinserted(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.inserted;
        }
        int n = pcInheritedFieldCount + 6;
        appointment.pcStateManager.accessingField(n);
        return appointment.inserted;
    }

    private static final void pcSetinserted(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.inserted = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 6, (Object)appointment.inserted, (Object)date, 0);
    }

    private static final Boolean pcGetisDaily(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isDaily;
        }
        int n = pcInheritedFieldCount + 7;
        appointment.pcStateManager.accessingField(n);
        return appointment.isDaily;
    }

    private static final void pcSetisDaily(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isDaily = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 7, (Object)appointment.isDaily, (Object)bl, 0);
    }

    private static final Boolean pcGetisMonthly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isMonthly;
        }
        int n = pcInheritedFieldCount + 8;
        appointment.pcStateManager.accessingField(n);
        return appointment.isMonthly;
    }

    private static final void pcSetisMonthly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isMonthly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 8, (Object)appointment.isMonthly, (Object)bl, 0);
    }

    private static final Boolean pcGetisWeekly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isWeekly;
        }
        int n = pcInheritedFieldCount + 9;
        appointment.pcStateManager.accessingField(n);
        return appointment.isWeekly;
    }

    private static final void pcSetisWeekly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isWeekly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 9, (Object)appointment.isWeekly, (Object)bl, 0);
    }

    private static final Boolean pcGetisYearly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isYearly;
        }
        int n = pcInheritedFieldCount + 10;
        appointment.pcStateManager.accessingField(n);
        return appointment.isYearly;
    }

    private static final void pcSetisYearly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isYearly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 10, (Object)appointment.isYearly, (Object)bl, 0);
    }

    private static final Long pcGetlanguageId(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.languageId;
        }
        int n = pcInheritedFieldCount + 11;
        appointment.pcStateManager.accessingField(n);
        return appointment.languageId;
    }

    private static final void pcSetlanguageId(Appointment appointment, Long l) {
        if (appointment.pcStateManager == null) {
            appointment.languageId = l;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 11, (Object)appointment.languageId, (Object)l, 0);
    }

    private static final String pcGetlocation(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.location;
        }
        int n = pcInheritedFieldCount + 12;
        appointment.pcStateManager.accessingField(n);
        return appointment.location;
    }

    private static final void pcSetlocation(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.location = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 12, appointment.location, string, 0);
    }

    private static final List pcGetmeetingMembers(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.meetingMembers;
        }
        int n = pcInheritedFieldCount + 13;
        appointment.pcStateManager.accessingField(n);
        return appointment.meetingMembers;
    }

    private static final void pcSetmeetingMembers(Appointment appointment, List list) {
        if (appointment.pcStateManager == null) {
            appointment.meetingMembers = list;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 13, appointment.meetingMembers, (Object)list, 0);
    }

    private static final User pcGetowner(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.owner;
        }
        int n = pcInheritedFieldCount + 14;
        appointment.pcStateManager.accessingField(n);
        return appointment.owner;
    }

    private static final void pcSetowner(Appointment appointment, User user) {
        if (appointment.pcStateManager == null) {
            appointment.owner = user;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 14, (Object)appointment.owner, (Object)user, 0);
    }

    private static final String pcGetpassword(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.password;
        }
        int n = pcInheritedFieldCount + 15;
        appointment.pcStateManager.accessingField(n);
        return appointment.password;
    }

    private static final void pcSetpassword(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.password = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 15, appointment.password, string, 0);
    }

    private static final boolean pcGetpasswordProtected(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.passwordProtected;
        }
        int n = pcInheritedFieldCount + 16;
        appointment.pcStateManager.accessingField(n);
        return appointment.passwordProtected;
    }

    private static final void pcSetpasswordProtected(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.passwordProtected = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 16, appointment.passwordProtected, bl, 0);
    }

    private static final Reminder pcGetreminder(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.reminder;
        }
        int n = pcInheritedFieldCount + 17;
        appointment.pcStateManager.accessingField(n);
        return appointment.reminder;
    }

    private static final void pcSetreminder(Appointment appointment, Reminder reminder) {
        if (appointment.pcStateManager == null) {
            appointment.reminder = reminder;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 17, (Object)appointment.reminder, (Object)reminder, 0);
    }

    private static final boolean pcGetreminderEmailSend(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.reminderEmailSend;
        }
        int n = pcInheritedFieldCount + 18;
        appointment.pcStateManager.accessingField(n);
        return appointment.reminderEmailSend;
    }

    private static final void pcSetreminderEmailSend(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.reminderEmailSend = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 18, appointment.reminderEmailSend, bl, 0);
    }

    private static final Room pcGetroom(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.room;
        }
        int n = pcInheritedFieldCount + 19;
        appointment.pcStateManager.accessingField(n);
        return appointment.room;
    }

    private static final void pcSetroom(Appointment appointment, Room room) {
        if (appointment.pcStateManager == null) {
            appointment.room = room;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 19, (Object)appointment.room, (Object)room, 0);
    }

    private static final Date pcGetstart(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.start;
        }
        int n = pcInheritedFieldCount + 20;
        appointment.pcStateManager.accessingField(n);
        return appointment.start;
    }

    private static final void pcSetstart(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.start = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 20, (Object)appointment.start, (Object)date, 0);
    }

    private static final String pcGettitle(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.title;
        }
        int n = pcInheritedFieldCount + 21;
        appointment.pcStateManager.accessingField(n);
        return appointment.title;
    }

    private static final void pcSettitle(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.title = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 21, appointment.title, string, 0);
    }

    private static final Date pcGetupdated(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.updated;
        }
        int n = pcInheritedFieldCount + 22;
        appointment.pcStateManager.accessingField(n);
        return appointment.updated;
    }

    private static final void pcSetupdated(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.updated = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 22, (Object)appointment.updated, (Object)date, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static enum Reminder {
        none(1),
        email(2),
        ical(3);

        private int id;

        private Reminder() {
        }

        private Reminder(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Reminder get(Long type) {
            return Reminder.get(type == null ? 1 : type.intValue());
        }

        public static Reminder get(Integer type) {
            return Reminder.get(type == null ? 1 : type);
        }

        public static Reminder get(int type) {
            Reminder r = none;
            switch (type) {
                case 2: {
                    r = email;
                    break;
                }
                case 3: {
                    r = ical;
                    break;
                }
            }
            return r;
        }
    }
}

