/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class OmCalendarDao {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private AppointmentDao appointmentDao;

    public List<OmCalendar> get() {
        return this.em.createNamedQuery("getCalendars", OmCalendar.class).getResultList();
    }

    public OmCalendar get(Long calId) {
        TypedQuery query = this.em.createNamedQuery("getCalendarbyId", OmCalendar.class).setParameter("calId", (Object)calId);
        OmCalendar c = null;
        try {
            c = (OmCalendar)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return c;
    }

    public List<OmCalendar> getByUser(Long userId) {
        return this.em.createNamedQuery("getCalendarbyUser", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public List<OmCalendar> getGoogleCalendars(Long userId) {
        return this.em.createNamedQuery("getGoogleCalendars", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public OmCalendar update(OmCalendar c) {
        if (c.getId() == null) {
            this.em.persist((Object)c);
        } else {
            c = (OmCalendar)this.em.merge((Object)c);
        }
        return c;
    }

    public void delete(OmCalendar c) {
        c.setDeleted(true);
        this.appointmentDao.deletebyCalendar(c.getId());
        this.update(c);
    }
}

