/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.record.RecordingMetaDelta;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RecordingMetaDeltaDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingMetaDeltaDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public List<RecordingMetaDelta> getByMetaId(Long metaDataId) {
        return this.em.createNamedQuery("getRecordingMetaDeltaByMetaDataId", RecordingMetaDelta.class).setParameter("metaDataId", (Object)metaDataId).getResultList();
    }

    public Long add(RecordingMetaDelta metaDelta) {
        try {
            metaDelta = (RecordingMetaDelta)this.em.merge((Object)metaDelta);
            Long metaDeltaId = metaDelta.getId();
            log.debug("metaDeltaId " + metaDeltaId);
            return metaDeltaId;
        }
        catch (Exception ex2) {
            log.error("[add]: ", (Throwable)ex2);
            return null;
        }
    }

    public RecordingMetaDelta update(RecordingMetaDelta metaDelta) {
        log.debug("[update]: ");
        if (metaDelta.getMetaDataId() == null) {
            this.em.persist((Object)metaDelta);
        } else {
            metaDelta = (RecordingMetaDelta)this.em.merge((Object)metaDelta);
        }
        return metaDelta;
    }
}

