/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.util.DaoHelper;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GroupDao
implements IGroupAdminDataProviderDao<Group> {
    public static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;

    @Override
    public Group get(long id) {
        return this.get((Long)id);
    }

    @Override
    public Group get(Long id) {
        TypedQuery query = this.em.createNamedQuery("getGroupById", Group.class);
        query.setParameter("id", (Object)id);
        Group o = null;
        try {
            o = (Group)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return o;
    }

    public Group get(String name) {
        List groups = this.em.createNamedQuery("getGroupByName", Group.class).setParameter("name", (Object)name).getResultList();
        return groups == null || groups.isEmpty() ? null : (Group)groups.get(0);
    }

    @Override
    public List<Group> get(int start, int count) {
        TypedQuery q = this.em.createNamedQuery("getNondeletedGroups", Group.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public List<Group> get(String search, int start, int count, String sort) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Group", (String)"g", (String)search, (boolean)true, (boolean)false, (String)sort, (String[])searchFields), Group.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public List<Group> get(String search, Long adminId, int start, int count, String order) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"GroupUser gu, IN(gu.group)", (String)"g", null, (String)search, (boolean)true, (boolean)true, (boolean)false, (String)"gu.user.id = :adminId AND gu.moderator = true", (String)order, (String[])searchFields), Group.class);
        q.setParameter("adminId", (Object)adminId);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countGroups", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Group", (String)"o", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search, Long adminId) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"GroupUser gu, IN(gu.group)", (String)"g", null, (String)search, (boolean)true, (boolean)true, (boolean)true, (String)"gu.user.id = :adminId AND gu.moderator = true", null, (String[])searchFields), Long.class);
        q.setParameter("adminId", (Object)adminId);
        return (Long)q.getSingleResult();
    }

    public List<Group> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getGroupsByIds", Group.class).setParameter("ids", ids).getResultList();
    }

    public List<Group> getLimited() {
        return this.em.createNamedQuery("getLimitedGroups", Group.class).getResultList();
    }

    @Override
    public Group update(Group entity, Long userId) {
        if (entity.getId() == null) {
            if (userId != null) {
                entity.setInsertedby(userId);
            }
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            if (userId != null) {
                entity.setUpdatedby(userId);
            }
            entity.setUpdated(new Date());
            this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(Group g, Long userId) {
        this.em.createNamedQuery("deleteGroupUsersByGroup").setParameter("id", (Object)g.getId()).executeUpdate();
        g.setDeleted(true);
        if (userId != null) {
            g.setUpdatedby(userId);
        }
        this.em.merge((Object)g);
    }
}

