/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.LoadFetchGroup;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.IDataProviderEntity;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.AsteriskSipUser;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.util.UserHelper;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.crypt.MD5;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Entity
@FetchGroups(value={@FetchGroup(name="backupexport", attributes={@FetchAttribute(name="password")}), @FetchGroup(name="groupUsers", attributes={@FetchAttribute(name="groupUsers")})})
@NamedQueries(value={@NamedQuery(name="getUserById", query="SELECT u FROM User u WHERE u.id = :id"), @NamedQuery(name="getUsersByIds", query="select c from User c where c.id IN :ids"), @NamedQuery(name="getUserByLogin", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.login = :login AND ((:domainId = 0 AND u.domainId IS NULL) OR (:domainId > 0 AND u.domainId = :domainId))"), @NamedQuery(name="getUserByEmail", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.address.email = :email AND ((:domainId = 0 AND u.domainId IS NULL) OR (:domainId > 0 AND u.domainId = :domainId))"), @NamedQuery(name="getUserByHash", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.resethash = :resethash"), @NamedQuery(name="getContactByEmailAndUser", query="SELECT u FROM User u WHERE u.deleted = false AND u.address.email = :email AND u.type = :type AND u.ownerId = :ownerId"), @NamedQuery(name="selectMaxFromUsersWithSearch", query="select count(c.id) from User c where c.deleted = false AND (lower(c.login) LIKE :search OR lower(c.firstname) LIKE :search OR lower(c.lastname) LIKE :search )"), @NamedQuery(name="getAllUsers", query="SELECT u FROM User u ORDER BY u.id"), @NamedQuery(name="getPassword", query="SELECT u.password FROM User u WHERE u.deleted = false AND u.id = :userId "), @NamedQuery(name="updatePassword", query="UPDATE User u SET u.password = :password WHERE u.id = :userId"), @NamedQuery(name="getNondeletedUsers", query="SELECT u FROM User u WHERE u.deleted = false"), @NamedQuery(name="countNondeletedUsers", query="SELECT COUNT(u) FROM User u WHERE u.deleted = false"), @NamedQuery(name="getUsersByGroupId", query="SELECT u FROM User u WHERE u.deleted = false AND u.groupUsers.group.id = :groupId"), @NamedQuery(name="getExternalUser", query="SELECT u FROM User u WHERE u.deleted = false AND u.externalId LIKE :externalId AND u.externalType LIKE :externalType"), @NamedQuery(name="getUserByLoginOrEmail", query="SELECT u from User u WHERE u.deleted = false AND u.type = :type AND (u.login = :userOrEmail OR u.address.email = :userOrEmail)")})
@Table(name="om_user")
@Root(name="user")
public class User
implements IDataProviderEntity,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int SALUTATION_MR_ID = 1;
    public static final int SALUTATION_MS_ID = 2;
    public static final int SALUTATION_MRS_ID = 3;
    public static final int SALUTATION_DR_ID = 4;
    public static final int SALUTATION_PROF_ID = 5;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(data=true, name="user_id")
    private Long id;
    @Column(name="age")
    @Element(data=true, required=false)
    private Date age;
    @Column(name="firstname")
    @Element(data=true, required=false)
    private String firstname;
    @Column(name="lastlogin")
    private Date lastlogin;
    @Column(name="lastname")
    @Element(data=true, required=false)
    private String lastname;
    @Column(name="lasttrans")
    @Element(data=true, required=false)
    private Long lasttrans;
    @Column(name="login")
    @Element(data=true, required=false)
    private String login;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="password", length=1024)
    @LoadFetchGroup(value="backupexport")
    @Element(name="pass", data=true, required=false)
    private String password;
    @Column(name="regdate")
    @Element(data=true, required=false)
    private Date regdate;
    @Column(name="salutation")
    @Enumerated(value=EnumType.STRING)
    @Element(name="title_id", data=true, required=false)
    private Salutation salutation;
    @Column(name="inserted")
    private Date inserted;
    @Column(name="updated")
    private Date updated;
    @Column(name="pictureuri")
    @Element(data=true, required=false)
    private String pictureuri;
    @Column(name="deleted", nullable=false)
    @Element(data=true, required=false)
    private boolean deleted;
    @Column(name="language_id")
    @Element(name="language_id", data=true, required=false)
    private long languageId;
    @Column(name="resethash")
    @Element(data=true, required=false)
    private String resethash;
    @Column(name="activatehash")
    @Element(data=true, required=false)
    private String activatehash;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="address_id", insertable=true, updatable=true)
    @ForeignKey(enabled=true)
    @Element(name="address", required=false)
    private Address address;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_id", insertable=true, updatable=true, nullable=false)
    @ElementList(name="organisations", required=false)
    @ElementDependent
    private List<GroupUser> groupUsers = new ArrayList<GroupUser>();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn(name="sip_user_id", referencedColumnName="id")
    @Element(name="sipUser", required=false)
    private AsteriskSipUser sipUser;
    @Column(name="external_id")
    @Element(name="externalUserId", data=true, required=false)
    private String externalId;
    @Column(name="external_type")
    @Element(name="externalUserType", data=true, required=false)
    private String externalType;
    @Column(name="time_zone_id")
    @Element(data=true, required=false)
    private String timeZoneId;
    @Transient
    private Sessiondata sessionData;
    @Column(name="forceTimeZoneCheck", nullable=false)
    @Element(data=true, required=false)
    private boolean forceTimeZoneCheck;
    @Column(name="sendSMS", nullable=false)
    @Element(data=false, required=false)
    private boolean sendSMS;
    @Column(name="user_offers")
    @Element(data=true, required=false)
    private String userOffers;
    @Column(name="user_searchs")
    @Element(data=true, required=false)
    private String userSearchs;
    @Column(name="show_contact_data", nullable=false)
    @Element(data=true, required=false)
    private boolean showContactData;
    @Column(name="show_contact_data_to_contacts", nullable=false)
    @Element(data=true, required=false)
    private boolean showContactDataToContacts;
    @Column(name="type")
    @Element(data=true, required=false)
    @Enumerated(value=EnumType.STRING)
    private Type type = Type.user;
    @Column(name="owner_id")
    @Element(data=true, required=false)
    private Long ownerId;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="om_right")
    @CollectionTable(name="om_user_right", joinColumns={@JoinColumn(name="user_id")})
    @Enumerated(value=EnumType.STRING)
    @ElementList(name="rights", data=true, required=false)
    private Set<Right> rights = new HashSet<Right>();
    @Column(name="domain_id")
    @Element(data=true, required=false)
    private Long domainId;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$Address;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User$Salutation;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User$Type;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User;
    private transient Object pcDetachedState;

    @Override
    public Long getId() {
        return User.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        User.pcSetid(this, id);
    }

    public Address getAddress() {
        return User.pcGetaddress(this);
    }

    public void setAddress(Address address) {
        User.pcSetaddress(this, address);
    }

    public Date getAge() {
        return User.pcGetage(this);
    }

    public void setAge(Date age) {
        User.pcSetage(this, age == null ? new Date() : age);
    }

    public String getFirstname() {
        return User.pcGetfirstname(this);
    }

    public void setFirstname(String firstname) {
        User.pcSetfirstname(this, firstname);
    }

    public Date getLastlogin() {
        return User.pcGetlastlogin(this);
    }

    public void setLastlogin(Date lastlogin) {
        User.pcSetlastlogin(this, lastlogin);
    }

    public String getLastname() {
        return User.pcGetlastname(this);
    }

    public void setLastname(String lastname) {
        User.pcSetlastname(this, lastname);
    }

    public Long getLasttrans() {
        return User.pcGetlasttrans(this);
    }

    public void setLasttrans(Long lasttrans) {
        User.pcSetlasttrans(this, lasttrans);
    }

    public String getLogin() {
        return User.pcGetlogin(this);
    }

    public void setLogin(String login) {
        User.pcSetlogin(this, login);
    }

    public void updatePassword(ConfigurationDao configDao, String pass) throws NoSuchAlgorithmException {
        this.updatePassword(configDao, pass, false);
    }

    public void updatePassword(ConfigurationDao configDao, String pass, boolean empty) throws NoSuchAlgorithmException {
        if (!empty && UserHelper.invalidPassword(pass, configDao)) {
            throw new RuntimeException("Password of invalid length is provided");
        }
        if (configDao.isSipEnabled()) {
            AsteriskSipUser u = this.getSipUser();
            if (u == null) {
                u = new AsteriskSipUser();
                this.setSipUser(u);
            }
            String defaultRoomContext = configDao.getConfValue("red5sip.exten_context", String.class, "rooms");
            u.setName(User.pcGetlogin(this));
            u.setDefaultuser(User.pcGetlogin(this));
            u.setMd5secret(MD5.checksum((String)(User.pcGetlogin(this) + ":asterisk:" + pass)));
            u.setContext(defaultRoomContext);
            u.setHost("dynamic");
        } else {
            this.setSipUser(null);
        }
        User.pcSetpassword(this, CryptProvider.get().hash(pass));
    }

    public String getPassword() {
        return User.pcGetpassword(this);
    }

    @Deprecated
    public void setPassword(String password) {
        User.pcSetpassword(this, password);
    }

    public Date getRegdate() {
        return User.pcGetregdate(this);
    }

    public void setRegdate(Date regdate) {
        User.pcSetregdate(this, regdate);
    }

    public Salutation getSalutation() {
        return User.pcGetsalutation(this);
    }

    public void setSalutation(Salutation salutation) {
        User.pcSetsalutation(this, salutation);
    }

    public Date getInserted() {
        return User.pcGetinserted(this);
    }

    public void setInserted(Date inserted) {
        User.pcSetinserted(this, inserted);
    }

    public Date getUpdated() {
        return User.pcGetupdated(this);
    }

    public void setUpdated(Date updated) {
        User.pcSetupdated(this, updated);
    }

    public boolean isDeleted() {
        return User.pcGetdeleted(this);
    }

    public void setDeleted(boolean deleted) {
        User.pcSetdeleted(this, deleted);
    }

    public String getPictureuri() {
        return User.pcGetpictureuri(this);
    }

    public void setPictureuri(String pictureuri) {
        User.pcSetpictureuri(this, pictureuri);
    }

    public long getLanguageId() {
        return User.pcGetlanguageId(this);
    }

    public void setLanguageId(long languageId) {
        User.pcSetlanguageId(this, languageId);
    }

    public List<GroupUser> getGroupUsers() {
        return User.pcGetgroupUsers(this);
    }

    public void setGroupUsers(List<GroupUser> groupUsers) {
        if (groupUsers != null) {
            User.pcSetgroupUsers(this, groupUsers);
        }
    }

    public String getResethash() {
        return User.pcGetresethash(this);
    }

    public void setResethash(String resethash) {
        User.pcSetresethash(this, resethash);
    }

    public String getActivatehash() {
        return User.pcGetactivatehash(this);
    }

    public void setActivatehash(String activatehash) {
        User.pcSetactivatehash(this, activatehash);
    }

    public String getExternalId() {
        return User.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        User.pcSetexternalId(this, externalId);
    }

    public String getExternalType() {
        return User.pcGetexternalType(this);
    }

    public void setExternalType(String externalType) {
        User.pcSetexternalType(this, externalType);
    }

    public Sessiondata getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Sessiondata sessionData) {
        this.sessionData = sessionData;
    }

    public AsteriskSipUser getSipUser() {
        return User.pcGetsipUser(this);
    }

    public void setSipUser(AsteriskSipUser sipUser) {
        User.pcSetsipUser(this, sipUser);
    }

    public String getTimeZoneId() {
        return User.pcGettimeZoneId(this);
    }

    public void setTimeZoneId(String timeZoneId) {
        User.pcSettimeZoneId(this, timeZoneId);
    }

    public boolean getForceTimeZoneCheck() {
        return User.pcGetforceTimeZoneCheck(this);
    }

    public void setForceTimeZoneCheck(boolean forceTimeZoneCheck) {
        User.pcSetforceTimeZoneCheck(this, forceTimeZoneCheck);
    }

    public boolean getSendSMS() {
        return User.pcGetsendSMS(this);
    }

    public void setSendSMS(boolean sendSMS) {
        User.pcSetsendSMS(this, sendSMS);
    }

    public String getUserOffers() {
        return User.pcGetuserOffers(this);
    }

    public void setUserOffers(String userOffers) {
        User.pcSetuserOffers(this, userOffers);
    }

    public String getUserSearchs() {
        return User.pcGetuserSearchs(this);
    }

    public void setUserSearchs(String userSearchs) {
        User.pcSetuserSearchs(this, userSearchs);
    }

    public boolean isShowContactData() {
        return User.pcGetshowContactData(this);
    }

    public void setShowContactData(boolean showContactData) {
        User.pcSetshowContactData(this, showContactData);
    }

    public boolean isShowContactDataToContacts() {
        return User.pcGetshowContactDataToContacts(this);
    }

    public void setShowContactDataToContacts(boolean showContactDataToContacts) {
        User.pcSetshowContactDataToContacts(this, showContactDataToContacts);
    }

    public String getPhoneForSMS() {
        return this.getSendSMS() ? this.getAddress().getPhone() : "";
    }

    public Type getType() {
        return User.pcGettype(this);
    }

    public void setType(Type type) {
        User.pcSettype(this, type);
    }

    public Long getOwnerId() {
        return User.pcGetownerId(this);
    }

    public void setOwnerId(Long ownerId) {
        User.pcSetownerId(this, ownerId);
    }

    public Set<Right> getRights() {
        return User.pcGetrights(this);
    }

    public void setRights(Set<Right> rights) {
        User.pcSetrights(this, rights);
    }

    public Long getDomainId() {
        return User.pcGetdomainId(this);
    }

    public void setDomainId(Long domainId) {
        User.pcSetdomainId(this, domainId);
    }

    public String toString() {
        return "User [id=" + User.pcGetid(this) + ", firstname=" + User.pcGetfirstname(this) + ", lastname=" + User.pcGetlastname(this) + ", login=" + User.pcGetlogin(this) + ", pictureuri=" + User.pcGetpictureuri(this) + ", deleted=" + User.pcGetdeleted(this) + ", languageId=" + User.pcGetlanguageId(this) + ", address=" + User.pcGetaddress(this) + ", externalId=" + User.pcGetexternalId(this) + ", externalType=" + User.pcGetexternalType(this) + ", type=" + (Object)((Object)User.pcGettype(this)) + "]";
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"activatehash", "address", "age", "deleted", "domainId", "externalId", "externalType", "firstname", "forceTimeZoneCheck", "groupUsers", "id", "inserted", "languageId", "lastlogin", "lastname", "lasttrans", "login", "ownerId", "password", "pictureuri", "regdate", "resethash", "rights", "salutation", "sendSMS", "showContactData", "showContactDataToContacts", "sipUser", "timeZoneId", "type", "updated", "userOffers", "userSearchs"};
        Class[] classArray = new Class[33];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[0] = clazz;
        Class clazz2 = class$Lorg$apache$openmeetings$db$entity$user$Address != null ? class$Lorg$apache$openmeetings$db$entity$user$Address : (class$Lorg$apache$openmeetings$db$entity$user$Address = User.class$("org.apache.openmeetings.db.entity.user.Address"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[2] = clazz3;
        classArray[3] = Boolean.TYPE;
        Class clazz4 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[4] = clazz4;
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[8] = Boolean.TYPE;
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = User.class$("java.util.List"));
        classArray[9] = clazz5;
        classArray[10] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[11] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[12] = Long.TYPE;
        classArray[13] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[15] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[17] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[18] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[20] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        Class clazz6 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = User.class$("java.util.Set"));
        classArray[22] = clazz6;
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$user$User$Salutation != null ? class$Lorg$apache$openmeetings$db$entity$user$User$Salutation : (class$Lorg$apache$openmeetings$db$entity$user$User$Salutation = User.class$("org.apache.openmeetings.db.entity.user.User$Salutation"));
        classArray[23] = clazz7;
        classArray[24] = Boolean.TYPE;
        classArray[25] = Boolean.TYPE;
        classArray[26] = Boolean.TYPE;
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser != null ? class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser : (class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser = User.class$("org.apache.openmeetings.db.entity.user.AsteriskSipUser"));
        classArray[27] = clazz8;
        classArray[28] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        Class clazz9 = class$Lorg$apache$openmeetings$db$entity$user$User$Type != null ? class$Lorg$apache$openmeetings$db$entity$user$User$Type : (class$Lorg$apache$openmeetings$db$entity$user$User$Type = User.class$("org.apache.openmeetings.db.entity.user.User$Type"));
        classArray[29] = clazz9;
        classArray[30] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[31] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[32] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 26, 26, 21, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz10 = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        PCRegistry.register((Class)clazz10, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"User", (PersistenceCapable)new User());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.activatehash = null;
        this.address = null;
        this.age = null;
        this.deleted = false;
        this.domainId = null;
        this.externalId = null;
        this.externalType = null;
        this.firstname = null;
        this.forceTimeZoneCheck = false;
        this.groupUsers = null;
        this.id = null;
        this.inserted = null;
        this.languageId = 0L;
        this.lastlogin = null;
        this.lastname = null;
        this.lasttrans = null;
        this.login = null;
        this.ownerId = null;
        this.password = null;
        this.pictureuri = null;
        this.regdate = null;
        this.resethash = null;
        this.rights = null;
        this.salutation = null;
        this.sendSMS = false;
        this.showContactData = false;
        this.showContactDataToContacts = false;
        this.sipUser = null;
        this.timeZoneId = null;
        this.type = null;
        this.updated = null;
        this.userOffers = null;
        this.userSearchs = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        user.pcCopyKeyFieldsFromObjectId(object);
        return user;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        return user;
    }

    protected static int pcGetManagedFieldCount() {
        return 33;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activatehash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.address = (Address)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.age = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.deleted = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.domainId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.externalType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.firstname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.forceTimeZoneCheck = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.groupUsers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.inserted = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.languageId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.lastlogin = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.lastname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.lasttrans = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.login = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.ownerId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.pictureuri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.regdate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.resethash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.rights = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.salutation = (Salutation)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 24: {
                this.sendSMS = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.showContactData = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.showContactDataToContacts = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.sipUser = (AsteriskSipUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 28: {
                this.timeZoneId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.type = (Type)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 30: {
                this.updated = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 31: {
                this.userOffers = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 32: {
                this.userSearchs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.activatehash);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.address);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.age);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.deleted);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.domainId);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalType);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.firstname);
                return;
            }
            case 8: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.forceTimeZoneCheck);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.groupUsers);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inserted);
                return;
            }
            case 12: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.languageId);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastlogin);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.lastname);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lasttrans);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.login);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ownerId);
                return;
            }
            case 18: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pictureuri);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.regdate);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.resethash);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.rights);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.salutation);
                return;
            }
            case 24: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.sendSMS);
                return;
            }
            case 25: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.showContactData);
                return;
            }
            case 26: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.showContactDataToContacts);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.sipUser);
                return;
            }
            case 28: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeZoneId);
                return;
            }
            case 29: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 30: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updated);
                return;
            }
            case 31: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userOffers);
                return;
            }
            case 32: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userSearchs);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(User user, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activatehash = user.activatehash;
                return;
            }
            case 1: {
                this.address = user.address;
                return;
            }
            case 2: {
                this.age = user.age;
                return;
            }
            case 3: {
                this.deleted = user.deleted;
                return;
            }
            case 4: {
                this.domainId = user.domainId;
                return;
            }
            case 5: {
                this.externalId = user.externalId;
                return;
            }
            case 6: {
                this.externalType = user.externalType;
                return;
            }
            case 7: {
                this.firstname = user.firstname;
                return;
            }
            case 8: {
                this.forceTimeZoneCheck = user.forceTimeZoneCheck;
                return;
            }
            case 9: {
                this.groupUsers = user.groupUsers;
                return;
            }
            case 10: {
                this.id = user.id;
                return;
            }
            case 11: {
                this.inserted = user.inserted;
                return;
            }
            case 12: {
                this.languageId = user.languageId;
                return;
            }
            case 13: {
                this.lastlogin = user.lastlogin;
                return;
            }
            case 14: {
                this.lastname = user.lastname;
                return;
            }
            case 15: {
                this.lasttrans = user.lasttrans;
                return;
            }
            case 16: {
                this.login = user.login;
                return;
            }
            case 17: {
                this.ownerId = user.ownerId;
                return;
            }
            case 18: {
                this.password = user.password;
                return;
            }
            case 19: {
                this.pictureuri = user.pictureuri;
                return;
            }
            case 20: {
                this.regdate = user.regdate;
                return;
            }
            case 21: {
                this.resethash = user.resethash;
                return;
            }
            case 22: {
                this.rights = user.rights;
                return;
            }
            case 23: {
                this.salutation = user.salutation;
                return;
            }
            case 24: {
                this.sendSMS = user.sendSMS;
                return;
            }
            case 25: {
                this.showContactData = user.showContactData;
                return;
            }
            case 26: {
                this.showContactDataToContacts = user.showContactDataToContacts;
                return;
            }
            case 27: {
                this.sipUser = user.sipUser;
                return;
            }
            case 28: {
                this.timeZoneId = user.timeZoneId;
                return;
            }
            case 29: {
                this.type = user.type;
                return;
            }
            case 30: {
                this.updated = user.updated;
                return;
            }
            case 31: {
                this.userOffers = user.userOffers;
                return;
            }
            case 32: {
                this.userSearchs = user.userSearchs;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        User user = (User)object;
        if (user.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(user, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(10 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        return new LongId(clazz, this.id);
    }

    private static final String pcGetactivatehash(User user) {
        if (user.pcStateManager == null) {
            return user.activatehash;
        }
        int n = pcInheritedFieldCount + 0;
        user.pcStateManager.accessingField(n);
        return user.activatehash;
    }

    private static final void pcSetactivatehash(User user, String string) {
        if (user.pcStateManager == null) {
            user.activatehash = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 0, user.activatehash, string, 0);
    }

    private static final Address pcGetaddress(User user) {
        if (user.pcStateManager == null) {
            return user.address;
        }
        int n = pcInheritedFieldCount + 1;
        user.pcStateManager.accessingField(n);
        return user.address;
    }

    private static final void pcSetaddress(User user, Address address) {
        if (user.pcStateManager == null) {
            user.address = address;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 1, (Object)user.address, (Object)address, 0);
    }

    private static final Date pcGetage(User user) {
        if (user.pcStateManager == null) {
            return user.age;
        }
        int n = pcInheritedFieldCount + 2;
        user.pcStateManager.accessingField(n);
        return user.age;
    }

    private static final void pcSetage(User user, Date date) {
        if (user.pcStateManager == null) {
            user.age = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 2, (Object)user.age, (Object)date, 0);
    }

    private static final boolean pcGetdeleted(User user) {
        if (user.pcStateManager == null) {
            return user.deleted;
        }
        int n = pcInheritedFieldCount + 3;
        user.pcStateManager.accessingField(n);
        return user.deleted;
    }

    private static final void pcSetdeleted(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.deleted = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 3, user.deleted, bl, 0);
    }

    private static final Long pcGetdomainId(User user) {
        if (user.pcStateManager == null) {
            return user.domainId;
        }
        int n = pcInheritedFieldCount + 4;
        user.pcStateManager.accessingField(n);
        return user.domainId;
    }

    private static final void pcSetdomainId(User user, Long l) {
        if (user.pcStateManager == null) {
            user.domainId = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 4, (Object)user.domainId, (Object)l, 0);
    }

    private static final String pcGetexternalId(User user) {
        if (user.pcStateManager == null) {
            return user.externalId;
        }
        int n = pcInheritedFieldCount + 5;
        user.pcStateManager.accessingField(n);
        return user.externalId;
    }

    private static final void pcSetexternalId(User user, String string) {
        if (user.pcStateManager == null) {
            user.externalId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 5, user.externalId, string, 0);
    }

    private static final String pcGetexternalType(User user) {
        if (user.pcStateManager == null) {
            return user.externalType;
        }
        int n = pcInheritedFieldCount + 6;
        user.pcStateManager.accessingField(n);
        return user.externalType;
    }

    private static final void pcSetexternalType(User user, String string) {
        if (user.pcStateManager == null) {
            user.externalType = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 6, user.externalType, string, 0);
    }

    private static final String pcGetfirstname(User user) {
        if (user.pcStateManager == null) {
            return user.firstname;
        }
        int n = pcInheritedFieldCount + 7;
        user.pcStateManager.accessingField(n);
        return user.firstname;
    }

    private static final void pcSetfirstname(User user, String string) {
        if (user.pcStateManager == null) {
            user.firstname = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 7, user.firstname, string, 0);
    }

    private static final boolean pcGetforceTimeZoneCheck(User user) {
        if (user.pcStateManager == null) {
            return user.forceTimeZoneCheck;
        }
        int n = pcInheritedFieldCount + 8;
        user.pcStateManager.accessingField(n);
        return user.forceTimeZoneCheck;
    }

    private static final void pcSetforceTimeZoneCheck(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.forceTimeZoneCheck = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 8, user.forceTimeZoneCheck, bl, 0);
    }

    private static final List pcGetgroupUsers(User user) {
        if (user.pcStateManager == null) {
            return user.groupUsers;
        }
        int n = pcInheritedFieldCount + 9;
        user.pcStateManager.accessingField(n);
        return user.groupUsers;
    }

    private static final void pcSetgroupUsers(User user, List list) {
        if (user.pcStateManager == null) {
            user.groupUsers = list;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 9, user.groupUsers, (Object)list, 0);
    }

    private static final Long pcGetid(User user) {
        if (user.pcStateManager == null) {
            return user.id;
        }
        int n = pcInheritedFieldCount + 10;
        user.pcStateManager.accessingField(n);
        return user.id;
    }

    private static final void pcSetid(User user, Long l) {
        if (user.pcStateManager == null) {
            user.id = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 10, (Object)user.id, (Object)l, 0);
    }

    private static final Date pcGetinserted(User user) {
        if (user.pcStateManager == null) {
            return user.inserted;
        }
        int n = pcInheritedFieldCount + 11;
        user.pcStateManager.accessingField(n);
        return user.inserted;
    }

    private static final void pcSetinserted(User user, Date date) {
        if (user.pcStateManager == null) {
            user.inserted = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 11, (Object)user.inserted, (Object)date, 0);
    }

    private static final long pcGetlanguageId(User user) {
        if (user.pcStateManager == null) {
            return user.languageId;
        }
        int n = pcInheritedFieldCount + 12;
        user.pcStateManager.accessingField(n);
        return user.languageId;
    }

    private static final void pcSetlanguageId(User user, long l) {
        if (user.pcStateManager == null) {
            user.languageId = l;
            return;
        }
        user.pcStateManager.settingLongField((PersistenceCapable)user, pcInheritedFieldCount + 12, user.languageId, l, 0);
    }

    private static final Date pcGetlastlogin(User user) {
        if (user.pcStateManager == null) {
            return user.lastlogin;
        }
        int n = pcInheritedFieldCount + 13;
        user.pcStateManager.accessingField(n);
        return user.lastlogin;
    }

    private static final void pcSetlastlogin(User user, Date date) {
        if (user.pcStateManager == null) {
            user.lastlogin = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 13, (Object)user.lastlogin, (Object)date, 0);
    }

    private static final String pcGetlastname(User user) {
        if (user.pcStateManager == null) {
            return user.lastname;
        }
        int n = pcInheritedFieldCount + 14;
        user.pcStateManager.accessingField(n);
        return user.lastname;
    }

    private static final void pcSetlastname(User user, String string) {
        if (user.pcStateManager == null) {
            user.lastname = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 14, user.lastname, string, 0);
    }

    private static final Long pcGetlasttrans(User user) {
        if (user.pcStateManager == null) {
            return user.lasttrans;
        }
        int n = pcInheritedFieldCount + 15;
        user.pcStateManager.accessingField(n);
        return user.lasttrans;
    }

    private static final void pcSetlasttrans(User user, Long l) {
        if (user.pcStateManager == null) {
            user.lasttrans = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 15, (Object)user.lasttrans, (Object)l, 0);
    }

    private static final String pcGetlogin(User user) {
        if (user.pcStateManager == null) {
            return user.login;
        }
        int n = pcInheritedFieldCount + 16;
        user.pcStateManager.accessingField(n);
        return user.login;
    }

    private static final void pcSetlogin(User user, String string) {
        if (user.pcStateManager == null) {
            user.login = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 16, user.login, string, 0);
    }

    private static final Long pcGetownerId(User user) {
        if (user.pcStateManager == null) {
            return user.ownerId;
        }
        int n = pcInheritedFieldCount + 17;
        user.pcStateManager.accessingField(n);
        return user.ownerId;
    }

    private static final void pcSetownerId(User user, Long l) {
        if (user.pcStateManager == null) {
            user.ownerId = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 17, (Object)user.ownerId, (Object)l, 0);
    }

    private static final String pcGetpassword(User user) {
        if (user.pcStateManager == null) {
            return user.password;
        }
        int n = pcInheritedFieldCount + 18;
        user.pcStateManager.accessingField(n);
        return user.password;
    }

    private static final void pcSetpassword(User user, String string) {
        if (user.pcStateManager == null) {
            user.password = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 18, user.password, string, 0);
    }

    private static final String pcGetpictureuri(User user) {
        if (user.pcStateManager == null) {
            return user.pictureuri;
        }
        int n = pcInheritedFieldCount + 19;
        user.pcStateManager.accessingField(n);
        return user.pictureuri;
    }

    private static final void pcSetpictureuri(User user, String string) {
        if (user.pcStateManager == null) {
            user.pictureuri = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 19, user.pictureuri, string, 0);
    }

    private static final Date pcGetregdate(User user) {
        if (user.pcStateManager == null) {
            return user.regdate;
        }
        int n = pcInheritedFieldCount + 20;
        user.pcStateManager.accessingField(n);
        return user.regdate;
    }

    private static final void pcSetregdate(User user, Date date) {
        if (user.pcStateManager == null) {
            user.regdate = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 20, (Object)user.regdate, (Object)date, 0);
    }

    private static final String pcGetresethash(User user) {
        if (user.pcStateManager == null) {
            return user.resethash;
        }
        int n = pcInheritedFieldCount + 21;
        user.pcStateManager.accessingField(n);
        return user.resethash;
    }

    private static final void pcSetresethash(User user, String string) {
        if (user.pcStateManager == null) {
            user.resethash = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 21, user.resethash, string, 0);
    }

    private static final Set pcGetrights(User user) {
        if (user.pcStateManager == null) {
            return user.rights;
        }
        int n = pcInheritedFieldCount + 22;
        user.pcStateManager.accessingField(n);
        return user.rights;
    }

    private static final void pcSetrights(User user, Set set) {
        if (user.pcStateManager == null) {
            user.rights = set;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 22, user.rights, (Object)set, 0);
    }

    private static final Salutation pcGetsalutation(User user) {
        if (user.pcStateManager == null) {
            return user.salutation;
        }
        int n = pcInheritedFieldCount + 23;
        user.pcStateManager.accessingField(n);
        return user.salutation;
    }

    private static final void pcSetsalutation(User user, Salutation salutation) {
        if (user.pcStateManager == null) {
            user.salutation = salutation;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 23, (Object)user.salutation, (Object)salutation, 0);
    }

    private static final boolean pcGetsendSMS(User user) {
        if (user.pcStateManager == null) {
            return user.sendSMS;
        }
        int n = pcInheritedFieldCount + 24;
        user.pcStateManager.accessingField(n);
        return user.sendSMS;
    }

    private static final void pcSetsendSMS(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.sendSMS = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 24, user.sendSMS, bl, 0);
    }

    private static final boolean pcGetshowContactData(User user) {
        if (user.pcStateManager == null) {
            return user.showContactData;
        }
        int n = pcInheritedFieldCount + 25;
        user.pcStateManager.accessingField(n);
        return user.showContactData;
    }

    private static final void pcSetshowContactData(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.showContactData = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 25, user.showContactData, bl, 0);
    }

    private static final boolean pcGetshowContactDataToContacts(User user) {
        if (user.pcStateManager == null) {
            return user.showContactDataToContacts;
        }
        int n = pcInheritedFieldCount + 26;
        user.pcStateManager.accessingField(n);
        return user.showContactDataToContacts;
    }

    private static final void pcSetshowContactDataToContacts(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.showContactDataToContacts = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 26, user.showContactDataToContacts, bl, 0);
    }

    private static final AsteriskSipUser pcGetsipUser(User user) {
        if (user.pcStateManager == null) {
            return user.sipUser;
        }
        int n = pcInheritedFieldCount + 27;
        user.pcStateManager.accessingField(n);
        return user.sipUser;
    }

    private static final void pcSetsipUser(User user, AsteriskSipUser asteriskSipUser) {
        if (user.pcStateManager == null) {
            user.sipUser = asteriskSipUser;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 27, (Object)user.sipUser, (Object)asteriskSipUser, 0);
    }

    private static final String pcGettimeZoneId(User user) {
        if (user.pcStateManager == null) {
            return user.timeZoneId;
        }
        int n = pcInheritedFieldCount + 28;
        user.pcStateManager.accessingField(n);
        return user.timeZoneId;
    }

    private static final void pcSettimeZoneId(User user, String string) {
        if (user.pcStateManager == null) {
            user.timeZoneId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 28, user.timeZoneId, string, 0);
    }

    private static final Type pcGettype(User user) {
        if (user.pcStateManager == null) {
            return user.type;
        }
        int n = pcInheritedFieldCount + 29;
        user.pcStateManager.accessingField(n);
        return user.type;
    }

    private static final void pcSettype(User user, Type type) {
        if (user.pcStateManager == null) {
            user.type = type;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 29, (Object)user.type, (Object)type, 0);
    }

    private static final Date pcGetupdated(User user) {
        if (user.pcStateManager == null) {
            return user.updated;
        }
        int n = pcInheritedFieldCount + 30;
        user.pcStateManager.accessingField(n);
        return user.updated;
    }

    private static final void pcSetupdated(User user, Date date) {
        if (user.pcStateManager == null) {
            user.updated = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 30, (Object)user.updated, (Object)date, 0);
    }

    private static final String pcGetuserOffers(User user) {
        if (user.pcStateManager == null) {
            return user.userOffers;
        }
        int n = pcInheritedFieldCount + 31;
        user.pcStateManager.accessingField(n);
        return user.userOffers;
    }

    private static final void pcSetuserOffers(User user, String string) {
        if (user.pcStateManager == null) {
            user.userOffers = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 31, user.userOffers, string, 0);
    }

    private static final String pcGetuserSearchs(User user) {
        if (user.pcStateManager == null) {
            return user.userSearchs;
        }
        int n = pcInheritedFieldCount + 32;
        user.pcStateManager.accessingField(n);
        return user.userSearchs;
    }

    private static final void pcSetuserSearchs(User user, String string) {
        if (user.pcStateManager == null) {
            user.userSearchs = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 32, user.userSearchs, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static enum Salutation {
        mr(1),
        ms(2),
        mrs(3),
        dr(4),
        prof(5);

        private int id;

        private Salutation() {
        }

        private Salutation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Salutation get(Long type) {
            return Salutation.get(type == null ? 1 : type.intValue());
        }

        public static Salutation get(Integer type) {
            return Salutation.get(type == null ? 1 : type);
        }

        public static Salutation get(int type) {
            Salutation rt = mr;
            switch (type) {
                case 2: {
                    rt = ms;
                    break;
                }
                case 3: {
                    rt = mrs;
                    break;
                }
                case 4: {
                    rt = dr;
                    break;
                }
                case 5: {
                    rt = prof;
                    break;
                }
            }
            return rt;
        }
    }

    @XmlType(namespace="org.apache.openmeetings.user.user.type")
    public static enum Type {
        user,
        ldap,
        oauth,
        external,
        contact;

    }

    @XmlType(namespace="org.apache.openmeetings.user.user.right")
    public static enum Right {
        Admin,
        GroupAdmin,
        Room,
        Dashboard,
        Login,
        Soap;

    }
}

