/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.calendar;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DtoHelper;
import org.apache.wicket.util.string.Strings;
import org.json.JSONObject;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MeetingMemberDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private UserDTO user;

    public MeetingMemberDTO() {
    }

    public MeetingMemberDTO(MeetingMember mm) {
        this.id = mm.getId();
        this.user = new UserDTO(mm.getUser());
    }

    public MeetingMember get(UserDao userDao, User owner) {
        MeetingMember mm = new MeetingMember();
        mm.setId(this.id);
        if (this.user.getId() != null) {
            mm.setUser(userDao.get(this.user.getId()));
        } else {
            User u = null;
            if (User.Type.external == this.user.getType()) {
                u = userDao.getExternalUser(this.user.getExternalId(), this.user.getExternalType());
            }
            if (u == null && this.user.getAddress() != null) {
                u = userDao.getContact(this.user.getAddress().getEmail(), this.user.getFirstname(), this.user.getLastname(), this.user.getLanguageId(), this.user.getTimeZoneId(), owner);
            }
            if (u == null) {
                u = this.user.get(userDao);
                u.setType(User.Type.contact);
                u.getRights().clear();
                u.setExternalId(null);
                u.setExternalType(null);
            }
            if (Strings.isEmpty((CharSequence)u.getTimeZoneId())) {
                u.setTimeZoneId(owner.getTimeZoneId());
            }
            mm.setUser(u);
        }
        return mm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserDTO getUser() {
        return this.user;
    }

    public void setUser(UserDTO user) {
        this.user = user;
    }

    public static MeetingMemberDTO get(JSONObject o) {
        MeetingMemberDTO m = new MeetingMemberDTO();
        m.id = DtoHelper.optLong(o, "id");
        m.user = UserDTO.get(o.optJSONObject("user"));
        return m;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

