/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.basic.Naviglobal;
import org.apache.openmeetings.db.entity.basic.Navimain;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class NavigationDao {
    private static final Logger log = Red5LoggerFactory.getLogger(NavigationDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public Naviglobal getGlobalMenuEntry(Long globalId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getNavigationById", Naviglobal.class);
            query.setParameter("id", (Object)globalId);
            return (Naviglobal)query.getSingleResult();
        }
        catch (Exception ex2) {
            log.error("getGlobalMenuEntry", (Throwable)ex2);
            return null;
        }
    }

    public List<Naviglobal> getMainMenu(int level) {
        List menu = this.em.createNamedQuery("getNavigation", Naviglobal.class).setParameter("levelId", (Object)level).getResultList();
        if (2 == level) {
            for (Naviglobal ng : menu) {
                this.em.detach((Object)ng);
                ng.setId(null);
                ArrayList<Navimain> sub = new ArrayList<Navimain>();
                for (Navimain nm : ng.getMainnavi()) {
                    if (nm.getLevelId() > level) continue;
                    sub.add(nm);
                }
                ng.setMainnavi(sub);
            }
        }
        return menu;
    }

    public Naviglobal addGlobalStructure(int naviorder, String labelId, int levelId, String name, String tooltipLabelId) {
        Naviglobal ng = new Naviglobal();
        ng.setComment("");
        ng.setIcon("");
        ng.setNaviorder(naviorder);
        ng.setLabelId(labelId);
        ng.setDeleted(false);
        ng.setLevelId(levelId);
        ng.setName(name);
        ng.setInserted(new Date());
        ng.setTooltipLabelId(tooltipLabelId);
        this.em.persist((Object)ng);
        return ng;
    }

    public void addMainStructure(String action, String params, int naviorder, String labelId, int levelId, String name, Long globalId, String tooltipLabelId) {
        Naviglobal ng = this.getGlobalMenuEntry(globalId);
        Navimain nm = new Navimain();
        nm.setAction(action);
        nm.setParams(params);
        nm.setComment("");
        nm.setIcon("");
        nm.setLabelId(labelId);
        nm.setNaviorder(naviorder);
        nm.setLevelId(levelId);
        nm.setName(name);
        nm.setDeleted(false);
        nm.setGlobalId(globalId);
        nm.setInserted(new Date());
        nm.setTooltipLabelId(tooltipLabelId);
        ng.getMainnavi().add(nm);
        this.em.merge((Object)ng);
    }
}

