/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.room.Client;
import org.apache.openmeetings.db.entity.server.Server;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ClientDao {
    @PersistenceContext
    private EntityManager em;
    private static List<Long> EMPTY_LIST = new ArrayList<Long>(0);

    public void cleanAllClients() {
        this.em.createNamedQuery("deleteAll").executeUpdate();
    }

    public void cleanClientsByServer(Server server) {
        this.em.createNamedQuery("deleteClientsByServer").setParameter("server", (Object)server).executeUpdate();
    }

    public Client add(Client entity) {
        this.em.persist((Object)entity);
        return entity;
    }

    public Client update(Client entity) {
        this.em.merge((Object)entity);
        return entity;
    }

    public void delete(Client entity) {
        Query q = this.em.createNamedQuery("deletedById");
        q.setParameter("id", (Object)entity.getId());
        q.executeUpdate();
    }

    public void removeClientByServerAndStreamId(Server server, String streamId) {
        Query q = this.em.createNamedQuery("deletedByServerAndStreamId");
        q.setParameter("server", (Object)server);
        q.setParameter("streamid", (Object)streamId);
        q.executeUpdate();
    }

    public int countClients() {
        return ((Long)this.em.createNamedQuery("countClients", Long.class).getSingleResult()).intValue();
    }

    public int countClientsByServer(Server server) {
        TypedQuery q = this.em.createNamedQuery("countClientsByServer", Long.class);
        q.setParameter("server", (Object)server);
        return ((Long)q.getSingleResult()).intValue();
    }

    public long countClientsByServerAndStreamId(Server server, String streamId) {
        TypedQuery q = this.em.createNamedQuery("countClientsByServerAndStreamId", Long.class);
        q.setParameter("streamid", (Object)streamId);
        q.setParameter("server", (Object)server);
        return (Long)q.getSingleResult();
    }

    public Client getClientByServerAndStreamId(Server server, String streamId) {
        TypedQuery q = this.em.createNamedQuery("getClientByServerAndStreamId", Client.class);
        q.setParameter("streamid", (Object)streamId);
        q.setParameter("server", (Object)server);
        List ll = q.getResultList();
        if (ll.size() == 1) {
            return (Client)ll.get(0);
        }
        if (ll.size() == 0) {
            return null;
        }
        throw new RuntimeException("more then one client was found streamId " + streamId + " server " + server);
    }

    public List<Client> getClientsByPublicSIDAndServer(Server server, String publicSID) {
        TypedQuery q = this.em.createNamedQuery("getClientsByPublicSIDAndServer", Client.class);
        q.setParameter("server", (Object)server);
        q.setParameter("publicSID", (Object)publicSID);
        return q.getResultList();
    }

    public List<Client> getClientsByPublicSID(String publicSID) {
        TypedQuery q = this.em.createNamedQuery("getClientsByPublicSID", Client.class);
        q.setParameter("publicSID", (Object)publicSID);
        return q.getResultList();
    }

    public List<Client> getClientsByServer(Server server) {
        TypedQuery q = this.em.createNamedQuery("getClientsByServer", Client.class);
        q.setParameter("server", (Object)server);
        return q.getResultList();
    }

    public List<Client> getClients() {
        return this.em.createNamedQuery("getClients", Client.class).getResultList();
    }

    public List<Client> getClientsWithServer() {
        return this.em.createNamedQuery("getClientsWithServer", Client.class).getResultList();
    }

    public List<Client> getClientsByUserId(Server server, Long userId) {
        TypedQuery q = this.em.createNamedQuery("getClientsByUserId", Client.class);
        q.setParameter("server", (Object)server);
        q.setParameter("userId", (Object)userId);
        return q.getResultList();
    }

    public List<Client> getClientsByRoomId(Long roomId) {
        TypedQuery q = this.em.createNamedQuery("getClientsByRoomId", Client.class);
        q.setParameter("roomId", (Object)roomId);
        return q.getResultList();
    }

    public List<Long> getRoomsIdsByServer(Server server) {
        Query q = this.em.createNamedQuery("getRoomsIdsByServer");
        q.setParameter("server", (Object)server);
        List resultList = q.getResultList();
        if (resultList.size() == 1 && resultList.get(0) == null) {
            return EMPTY_LIST;
        }
        return resultList;
    }
}

