/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.server.ISessionManager;
import org.apache.openmeetings.db.entity.room.Client;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SessiondataDao {
    private static final Logger log = Red5LoggerFactory.getLogger(SessiondataDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ISessionManager sessionManager;

    private static Sessiondata newInstance() {
        log.debug("startsession :: startsession");
        Sessiondata sd = new Sessiondata();
        sd.setSessionId(UUID.randomUUID().toString());
        sd.setCreated(new Date());
        sd.setUserId(null);
        return sd;
    }

    public Sessiondata create(Long userId, long languageId) {
        return this.create(userId, null, languageId);
    }

    public Sessiondata create(Long userId, Long roomId, long languageId) {
        log.debug("create :: create");
        Sessiondata sd = SessiondataDao.newInstance();
        sd.setUserId(userId);
        sd.setRoomId(roomId);
        sd.setLanguageId(languageId);
        return this.update(sd);
    }

    public Sessiondata find(String SID) {
        List sessions = this.em.createNamedQuery("getSessionById", Sessiondata.class).setParameter("sessionId", (Object)SID).getResultList();
        Sessiondata sd = null;
        if (sessions != null && sessions.size() > 0 && ((sd = (Sessiondata)sessions.get(0)) == null || sd.getUserId() == null || sd.getUserId().equals(new Long(0L)))) {
            return null;
        }
        return sd;
    }

    public Sessiondata check(String SID) {
        Sessiondata sd = this.find(SID);
        if (sd == null) {
            return SessiondataDao.newInstance();
        }
        return this.update(sd);
    }

    public boolean updateUser(String SID, Long userId) {
        try {
            log.debug("updateUser User: " + userId + " || " + SID);
            Sessiondata sd = this.find(SID);
            if (sd == null) {
                log.error("Could not find session to Update");
                return false;
            }
            log.debug("Found session to update: userId: {}", (Object)userId);
            sd.setUserId(userId);
            this.update(sd);
            return true;
        }
        catch (Exception ex2) {
            log.error("[updateUser]: ", (Throwable)ex2);
            return false;
        }
    }

    public boolean updateUserWithoutSession(String SID, Long userId) {
        try {
            log.debug("updateUser User: " + userId + " || " + SID);
            Sessiondata sd = this.find(SID);
            if (sd == null) {
                log.error("Could not find session to Update");
                return false;
            }
            log.debug("Found session to update: userId: {}", (Object)userId);
            sd.setUserId(userId);
            this.update(sd);
            return true;
        }
        catch (Exception ex2) {
            log.error("[updateUser]: ", (Throwable)ex2);
            return false;
        }
    }

    private List<Sessiondata> getSessionToDelete(Date refreshed) {
        try {
            TypedQuery query = this.em.createNamedQuery("getSessionToDelete", Sessiondata.class);
            query.setParameter("refreshed", (Object)refreshed);
            return query.getResultList();
        }
        catch (Exception ex2) {
            log.error("[getSessionToDelete]: ", (Throwable)ex2);
            return null;
        }
    }

    public void clearSessionTable(long timeout) {
        try {
            log.debug("****** clearSessionTable: ");
            List<Sessiondata> l = this.getSessionToDelete(new Date(System.currentTimeMillis() - timeout));
            log.debug("clearSessionTable: " + l.size());
            for (Sessiondata sData : l) {
                sData = (Sessiondata)this.em.find(Sessiondata.class, (Object)sData.getId());
                this.em.remove((Object)sData);
            }
        }
        catch (Exception err) {
            log.error("clearSessionTable", (Throwable)err);
        }
    }

    public void clearSessionByRoomId(Long roomId) {
        try {
            for (Client rcl : this.sessionManager.getClientListByRoom(roomId)) {
                String SID;
                Sessiondata sData;
                String aux = rcl.getSwfurl();
                int init_pos = aux.indexOf("sid=") + 4;
                int end_pos = init_pos + 32;
                if (end_pos > aux.length()) {
                    end_pos = aux.length();
                }
                if ((sData = this.check(SID = aux.substring(init_pos, end_pos))) == null) continue;
                this.em.remove((Object)sData);
            }
        }
        catch (Exception err) {
            log.error("clearSessionByRoomId", (Throwable)err);
        }
    }

    public Sessiondata update(Sessiondata sd) {
        sd.setRefreshed(new Date());
        if (sd.getId() == null) {
            this.em.persist((Object)sd);
        } else {
            sd = (Sessiondata)this.em.merge((Object)sd);
        }
        return sd;
    }
}

