/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.record.RecordingMetaData;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RecordingMetaDataDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingMetaDataDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private RecordingDao recordingDao;

    public RecordingMetaData get(Long id) {
        try {
            TypedQuery query = this.em.createNamedQuery("getMetaById", RecordingMetaData.class);
            query.setParameter("id", (Object)id);
            RecordingMetaData metaData = null;
            try {
                metaData = (RecordingMetaData)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            return metaData;
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<RecordingMetaData> getByRecording(Long recordingId) {
        return this.em.createNamedQuery("getMetaByRecording", RecordingMetaData.class).setParameter("recordingId", (Object)recordingId).getResultList();
    }

    public List<RecordingMetaData> getAudioMetaDataByRecording(Long recordingId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getAudioMetaByRecording", RecordingMetaData.class);
            query.setParameter("recordingId", (Object)recordingId);
            query.setParameter("none", (Object)RecordingMetaData.Status.NONE);
            return query.getResultList();
        }
        catch (Exception ex2) {
            log.error("[getAudioMetaDataByRecording]: ", (Throwable)ex2);
            return null;
        }
    }

    public RecordingMetaData getScreenMetaDataByRecording(Long recordingId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getScreenMetaByRecording", RecordingMetaData.class);
            query.setParameter("recordingId", (Object)recordingId);
            List metaDatas = query.getResultList();
            if (metaDatas.size() > 0) {
                return (RecordingMetaData)metaDatas.get(0);
            }
        }
        catch (Exception ex2) {
            log.error("[getScreenMetaDataByRecording]: ", (Throwable)ex2);
        }
        return null;
    }

    public Long add(Long recordingId, String freeTextUserName, Date recordStart, boolean isAudioOnly, boolean isVideoOnly, boolean isScreenData, String streamName, Integer interiewPodId) {
        try {
            RecordingMetaData metaData = new RecordingMetaData();
            metaData.setDeleted(false);
            metaData.setRecording(this.recordingDao.get(recordingId));
            metaData.setFreeTextUserName(freeTextUserName);
            metaData.setInserted(new Date());
            metaData.setRecordStart(recordStart);
            metaData.setAudioOnly(isAudioOnly);
            metaData.setVideoOnly(isVideoOnly);
            metaData.setScreenData(isScreenData);
            metaData.setStreamName(streamName);
            metaData.setInteriewPodId(interiewPodId);
            metaData = (RecordingMetaData)this.em.merge((Object)metaData);
            Long metaDataId = metaData.getId();
            return metaDataId;
        }
        catch (Exception ex2) {
            log.error("[add]: ", (Throwable)ex2);
            return null;
        }
    }

    public Long updateEndDate(Long metaId, Date recordEnd) {
        try {
            RecordingMetaData meta = this.get(metaId);
            if (meta != null) {
                meta.setRecordEnd(recordEnd);
                log.debug("updateEndDate :: Start Date :" + meta.getRecordStart());
                log.debug("updateEndDate :: End Date :" + meta.getRecordEnd());
                this.update(meta);
            }
            return metaId;
        }
        catch (Exception ex2) {
            log.error("[updateEndDate]: ", (Throwable)ex2);
            return null;
        }
    }

    public RecordingMetaData update(RecordingMetaData metaData) {
        log.debug("[update]: ");
        if (metaData.getId() == null) {
            this.em.persist((Object)metaData);
        } else {
            metaData = (RecordingMetaData)this.em.merge((Object)metaData);
        }
        return metaData;
    }
}

