/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class LocaleHelper {
    private static final Logger log = Red5LoggerFactory.getLogger(LocaleHelper.class, (String)OpenmeetingsVariables.webAppRootKey);

    public static List<String> getCountries() {
        return Arrays.asList(Locale.getISOCountries());
    }

    public static String getCountryName(String code, Locale l) {
        return new Locale.Builder().setRegion(code).build().getDisplayCountry(l);
    }

    public static String getCountryName(String code) {
        return new Locale.Builder().setRegion(code).build().getDisplayCountry();
    }

    public static String validateCountry(String code) {
        List<String> list = LocaleHelper.getCountries();
        HashSet<String> countries = new HashSet<String>(list);
        String string = code = code == null ? "" : code.toUpperCase();
        if (!countries.contains(code)) {
            String newCountry = list.get(0);
            log.warn("Invalid country found: {}, will be replaced with: {}", (Object)code, (Object)newCountry);
            code = newCountry;
        }
        return code;
    }

    public static Locale getLocale(User u) {
        Long langId = u.getLanguageId();
        Locale locale = langId == 3L ? Locale.GERMANY : LabelDao.languages.get(langId);
        try {
            Locale.Builder builder = new Locale.Builder().setLanguage(locale.getLanguage());
            if (u.getAddress() != null && u.getAddress().getCountry() != null) {
                builder.setRegion(u.getAddress().getCountry());
            }
            locale = builder.build();
        }
        catch (Exception e) {
            log.error("Unexpected Error whilw constructing locale for the user", (Object)e.getMessage());
        }
        return locale;
    }
}

