/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.Application;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ConfigurationDao
implements IDataProviderDao<Configuration> {
    private static final Logger log = Red5LoggerFactory.getLogger(ConfigurationDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    public static final String[] searchFields = new String[]{"key", "value"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    public void updateClusterAddresses(String addresses) throws UnknownHostException {
        OpenJPAConfiguration cfg = ((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)this.em)).getConfiguration();
        RemoteCommitProvider prov = cfg.getRemoteCommitEventManager().getRemoteCommitProvider();
        if (prov instanceof TCPRemoteCommitProvider) {
            ((TCPRemoteCommitProvider)prov).setAddresses(addresses);
        }
    }

    public Configuration forceGet(String confKey) {
        try {
            List list = this.em.createNamedQuery("forceGetConfigurationByKey", Configuration.class).setParameter("key", (Object)confKey).getResultList();
            return list.isEmpty() ? null : (Configuration)list.get(0);
        }
        catch (Exception e) {
            log.error("[forceGet]: ", (Throwable)e);
            return null;
        }
    }

    public List<Configuration> get(String ... keys) {
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        for (String key : keys) {
            List r = this.em.createNamedQuery("getConfigurationsByKeys", Configuration.class).setParameter("keys", Arrays.asList(key)).getResultList();
            result.add(r.isEmpty() ? null : (Configuration)r.get(0));
        }
        return result;
    }

    public <T> T getConfValue(String key, Class<T> type, String defaultValue) {
        try {
            List<Configuration> list = this.get(key);
            if (list == null || list.isEmpty() || list.get(0) == null) {
                log.warn("Could not find key in configurations: " + key);
            } else {
                String val = list.get(0).getValue();
                if (val != null) {
                    defaultValue = val;
                }
            }
            if (defaultValue == null) {
                return null;
            }
            if (type.isAssignableFrom(defaultValue.getClass())) {
                return type.cast(defaultValue);
            }
            Constructor<T> c = type.getConstructor(defaultValue.getClass());
            return c.newInstance(defaultValue);
        }
        catch (Exception err) {
            log.error("cannot be cast to return type, you have misconfigured your configurations: " + key, (Throwable)err);
            return null;
        }
    }

    public Configuration add(String key, String value, Long userId, String comment) {
        Configuration c = new Configuration();
        c.setKey(key);
        c.setValue(value);
        c.setComment(comment);
        return this.update(c, userId);
    }

    public String getAppName() {
        if (OpenmeetingsVariables.APPLICATION_NAME == null) {
            OpenmeetingsVariables.APPLICATION_NAME = this.getConfValue("application.name", String.class, "OpenMeetings");
        }
        return OpenmeetingsVariables.APPLICATION_NAME;
    }

    public String getBaseUrl() {
        String val = this.getConfValue("application.base.url", String.class, OpenmeetingsVariables.DEFAULT_BASE_URL);
        if (val != null && !val.endsWith("/")) {
            val = val + "/";
        }
        return val;
    }

    public boolean isSipEnabled() {
        return "yes".equals(this.getConfValue("red5sip.enable", String.class, "no"));
    }

    @Override
    public Configuration get(long id) {
        return this.get((Long)id);
    }

    @Override
    public Configuration get(Long id) {
        if (id == null) {
            return null;
        }
        return (Configuration)this.em.createNamedQuery("getConfigurationById", Configuration.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<Configuration> get(int start, int count) {
        return this.em.createNamedQuery("getNondeletedConfiguration", Configuration.class).setFirstResult(start).setMaxResults(count).getResultList();
    }

    @Override
    public List<Configuration> get(String search, int start, int count, String sort) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Configuration", (String)"c", (String)search, (boolean)true, (boolean)false, (String)sort, (String[])searchFields), Configuration.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countConfigurations", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Configuration", (String)"c", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public Configuration update(Configuration entity, Long userId) {
        return this.update(entity, userId, false);
    }

    public Configuration update(Configuration entity, Long userId, boolean deleted) {
        String key = entity.getKey();
        String value = entity.getValue();
        if (entity.getId() == null || entity.getId() <= 0L) {
            entity.setInserted(new Date());
            entity.setDeleted(deleted);
            this.em.persist((Object)entity);
        } else {
            if (userId != null) {
                entity.setUser(this.userDao.get(userId));
            }
            entity.setDeleted(deleted);
            entity.setUpdated(new Date());
            entity = (Configuration)this.em.merge((Object)entity);
        }
        switch (key) {
            case "crypt_ClassName": {
                OpenmeetingsVariables.configKeyCryptClassName = value;
                CryptProvider.reset();
                break;
            }
            case "show.whiteboard.draw.status": {
                OpenmeetingsVariables.whiteboardDrawStatus = "1".equals(value);
                break;
            }
            case "application.name": {
                OpenmeetingsVariables.APPLICATION_NAME = value;
                break;
            }
            case "header.x.frame.options": {
                IApplication iapp = (IApplication)Application.get((String)OpenmeetingsVariables.wicketApplicationName);
                if (iapp == null) break;
                iapp.setXFrameOptions(value);
                break;
            }
            case "header.content.security.policy": {
                IApplication iapp = (IApplication)Application.get((String)OpenmeetingsVariables.wicketApplicationName);
                if (iapp == null) break;
                iapp.setContentSecurityPolicy(value);
                break;
            }
            case "external.process.ttl": {
                OpenmeetingsVariables.EXT_PROCESS_TTL = Integer.parseInt(value);
            }
        }
        return entity;
    }

    @Override
    public void delete(Configuration entity, Long userId) {
        entity.setUpdated(new Date());
        this.update(entity, userId, true);
    }

    public long getMaxUploadSize() {
        try {
            return this.getConfValue("max_upload_size", Long.class, "104857600");
        }
        catch (Exception e) {
            log.error("Invalid value saved for max_upload_size conf key: ", (Throwable)e);
            return 0x6400000L;
        }
    }

    public String getCryptKey() {
        String cryptClass;
        if (OpenmeetingsVariables.configKeyCryptClassName == null && (cryptClass = this.getConfValue("crypt_ClassName", String.class, null)) != null) {
            OpenmeetingsVariables.configKeyCryptClassName = cryptClass;
        }
        return OpenmeetingsVariables.configKeyCryptClassName;
    }

    public boolean getWhiteboardDrawStatus() {
        if (OpenmeetingsVariables.whiteboardDrawStatus == null) {
            String drawStatus = this.getConfValue("show.whiteboard.draw.status", String.class, "0");
            OpenmeetingsVariables.whiteboardDrawStatus = "1".equals(drawStatus);
        }
        return OpenmeetingsVariables.whiteboardDrawStatus;
    }
}

