/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import org.apache.openmeetings.db.entity.room.Room;
import org.asteriskjava.manager.DefaultManagerConnection;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.ConfbridgeListAction;
import org.asteriskjava.manager.action.DbDelAction;
import org.asteriskjava.manager.action.DbDelTreeAction;
import org.asteriskjava.manager.action.DbGetAction;
import org.asteriskjava.manager.action.DbPutAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class SipDao {
    private static final Logger log = Red5LoggerFactory.getLogger(SipDao.class);
    public static final String ASTERISK_OM_FAMILY = "openmeetings";
    public static final String ASTERISK_OM_KEY = "rooms";
    public static final String SIP_FIRST_NAME = "SIP Transport";
    public static final String SIP_USER_NAME = "--SIP--";
    private String sipHostname;
    private int sipPort;
    private String sipUsername;
    private String sipPassword;
    private String uid;
    private long timeout;
    private ManagerConnectionFactory factory;

    private SipDao() {
    }

    public SipDao(String sipHostname, int sipPort, String sipUsername, String sipPassword, long timeout) {
        this.sipHostname = sipHostname;
        this.sipPort = sipPort;
        this.sipUsername = sipUsername;
        this.sipPassword = sipPassword;
        this.timeout = timeout;
        this.factory = new ManagerConnectionFactory(this.sipHostname, this.sipPort, this.sipUsername, this.sipPassword);
    }

    private ManagerConnection getConnection() {
        DefaultManagerConnection con = (DefaultManagerConnection)this.factory.createManagerConnection();
        con.setDefaultEventTimeout(this.timeout);
        con.setDefaultResponseTimeout(this.timeout);
        con.setSocketReadTimeout((int)this.timeout);
        con.setSocketTimeout((int)this.timeout);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagerResponse exec(ManagerAction action) {
        if (this.factory == null) {
            log.warn("There is no Asterisk configured");
            return null;
        }
        ManagerConnection con = this.getConnection();
        try {
            con.login();
            ManagerResponse r = con.sendAction(action);
            if (r != null) {
                log.debug(r.toString());
            }
            ManagerResponse managerResponse = r instanceof ManagerError ? null : r;
            return managerResponse;
        }
        catch (Exception e) {
            log.error("Error while executing ManagerAction: " + action, (Throwable)e);
        }
        finally {
            try {
                con.logoff();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEvents execEvent(EventGeneratingAction action) {
        if (this.factory == null) {
            log.warn("There is no Asterisk configured");
            return null;
        }
        ManagerConnection con = this.getConnection();
        try {
            con.login("on");
            ResponseEvents r = con.sendEventGeneratingAction(action);
            if (r != null) {
                log.debug(r.getResponse().toString());
            }
            ResponseEvents responseEvents = r == null || r.getResponse() instanceof ManagerError ? null : r;
            return responseEvents;
        }
        catch (Exception e) {
            log.error("Error while executing EventGeneratingAction: " + action, (Throwable)e);
        }
        finally {
            try {
                con.logoff();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static String getKey(String confno) {
        return "rooms/" + confno;
    }

    public String get(String confno) {
        String pin = null;
        DbGetAction da = new DbGetAction(ASTERISK_OM_FAMILY, SipDao.getKey(confno));
        ManagerResponse r = this.exec((ManagerAction)da);
        if (r != null) {
            pin = r.getResponse();
        }
        return pin;
    }

    public void update(String confno, String pin) {
        this.delete(confno);
        DbPutAction da = new DbPutAction(ASTERISK_OM_FAMILY, SipDao.getKey(confno), pin);
        this.exec((ManagerAction)da);
    }

    public void delete() {
        DbDelTreeAction da = new DbDelTreeAction(ASTERISK_OM_FAMILY, ASTERISK_OM_KEY);
        this.exec((ManagerAction)da);
    }

    public void delete(String confno) {
        DbDelAction da = new DbDelAction(ASTERISK_OM_FAMILY, SipDao.getKey(confno));
        this.exec((ManagerAction)da);
    }

    public Integer countUsers(String confno) {
        if (confno == null) {
            return null;
        }
        ConfbridgeListAction da = new ConfbridgeListAction(confno);
        ResponseEvents r = this.execEvent((EventGeneratingAction)da);
        if (r != null) {
            log.debug("SipDao::countUsers size == " + r.getEvents().size());
            return r.getEvents().size() - 1;
        }
        return 0;
    }

    public void joinToConfCall(String number, Room r) {
        String sipNumber;
        String string = sipNumber = r != null && r.getConfno() != null ? r.getConfno() : null;
        if (sipNumber == null) {
            log.warn("Failed to get SIP number for room: {}", (Object)r);
            return;
        }
        OriginateAction oa = new OriginateAction();
        oa.setChannel(String.format("Local/%s@rooms-originate", sipNumber));
        oa.setContext("rooms-out");
        oa.setExten(number);
        oa.setPriority(Integer.valueOf(1));
        oa.setTimeout(Long.valueOf(this.timeout));
        this.exec((ManagerAction)oa);
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }
}

