/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class Whiteboard {
    private static final Logger log = Red5LoggerFactory.getLogger(Whiteboard.class, (String)OpenmeetingsVariables.webAppRootKey);
    private long whiteBoardId;
    private Integer x = 0;
    private Integer y = 0;
    private Integer zoom = 100;
    private Boolean fullFit = true;
    private Map<String, List<Object>> roomItems = Collections.synchronizedMap(new LinkedHashMap());
    private Date created = new Date();
    private int zIndex = 1;
    private String name;

    public Whiteboard() {
    }

    public Whiteboard(String name) {
        this.name = name;
    }

    public long getWhiteBoardId() {
        return this.whiteBoardId;
    }

    public void setWhiteBoardId(long whiteBoardId) {
        this.whiteBoardId = whiteBoardId;
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public Boolean getFullFit() {
        return this.fullFit;
    }

    public void setFullFit(Boolean fullFit) {
        this.fullFit = fullFit;
    }

    public void clear() {
        this.roomItems.clear();
        this.zIndex = 1;
    }

    public Map<String, List<Object>> getRoomItems() {
        return this.roomItems;
    }

    public void add(String oid, List<Object> actionObject) {
        Integer zInd;
        String type;
        String string = type = actionObject.size() > 0 ? actionObject.get(0) : "";
        if (actionObject.size() > 8 && ("swf".equals(type) || "image".equals(type) || "flv".equals(type)) && ((zInd = (Integer)actionObject.get(actionObject.size() - 8)) == null || zInd == 0 || zInd < this.zIndex)) {
            actionObject.set(actionObject.size() - 8, this.zIndex++);
        }
        this.roomItems.put(oid, actionObject);
    }

    public List<Object> get(String oid) {
        return this.roomItems.get(oid);
    }

    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.roomItems.entrySet();
    }

    public void remove(Object oid) {
        this.roomItems.remove(oid);
    }

    public void remove(List<Object> actionObject) {
        String oid = actionObject.get(actionObject.size() - 1).toString();
        String type = actionObject.get(0).toString();
        log.debug("Removal of object: oid = {}, type = {} ", (Object)oid, (Object)type);
        this.roomItems.remove(oid);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

