/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.IClient;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.StreamClient;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.wicket.protocol.ws.api.registry.IKey;

public class Client
implements IClient {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private int pageId;
    private User user;
    private Long roomId;
    private final String uid;
    private final String sid;
    private String remoteAddress;
    private final Set<Room.Right> rights = new HashSet<Room.Right>();
    private final Set<Activity> activities = new HashSet<Activity>();
    private final Date connectedSince;
    private Pod pod;
    private int cam = -1;
    private int mic = -1;
    private int width = 0;
    private int height = 0;
    private String serverId = null;

    public Client(String sessionId, int pageId, Long userId, UserDao dao) {
        this.sessionId = sessionId;
        this.pageId = pageId;
        this.user = dao.get(userId);
        this.connectedSince = new Date();
        this.uid = UUID.randomUUID().toString();
        this.sid = UUID.randomUUID().toString();
    }

    public Client(StreamClient rcl, User user) {
        this.sessionId = UUID.randomUUID().toString();
        this.pageId = 0;
        this.user = user;
        this.connectedSince = new Date();
        this.uid = rcl.getPublicSID();
        this.sid = UUID.randomUUID().toString();
        this.roomId = rcl.getRoomId();
        this.remoteAddress = rcl.getUserip();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getPageId() {
        return this.pageId;
    }

    public Client setPageId(IKey key) {
        this.pageId = key.hashCode();
        return this;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public User getUser() {
        return this.user;
    }

    public Client updateUser(UserDao dao) {
        this.user = dao.get(this.user.getId());
        return this;
    }

    public Long getUserId() {
        return this.user.getId();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    public String getSid() {
        return this.sid;
    }

    public void clearRights() {
        this.rights.clear();
    }

    public boolean hasRight(Room.Right right) {
        if (Room.Right.superModerator == right) {
            return this.rights.contains((Object)right);
        }
        return this.rights.contains((Object)Room.Right.superModerator) || this.rights.contains((Object)Room.Right.moderator) ? true : this.rights.contains((Object)right);
    }

    public Client allow(Room.Right ... _rights) {
        this.allow(Arrays.asList(_rights));
        return this;
    }

    public void allow(Iterable<Room.Right> _rights) {
        for (Room.Right right : _rights) {
            if (this.hasRight(right)) continue;
            this.rights.add(right);
        }
    }

    public void deny(Room.Right ... _rights) {
        for (Room.Right right : _rights) {
            this.rights.remove((Object)right);
        }
    }

    public void clearActivities() {
        this.activities.clear();
    }

    public boolean hasActivity(Activity a) {
        return this.activities.contains((Object)a);
    }

    public void toggle(Activity a) {
        if (this.hasActivity(a)) {
            this.remove(a);
        } else {
            this.set(a);
        }
    }

    public Client set(Activity a) {
        this.activities.add(a);
        switch (a) {
            case broadcastV: 
            case broadcastA: {
                if (!this.hasActivity(Activity.broadcastA) || !this.hasActivity(Activity.broadcastV)) break;
                this.activities.add(Activity.broadcastAV);
                break;
            }
            case broadcastAV: {
                this.activities.add(Activity.broadcastA);
                this.activities.add(Activity.broadcastV);
                break;
            }
        }
        return this;
    }

    public Client remove(Activity a) {
        this.activities.remove((Object)a);
        switch (a) {
            case broadcastV: 
            case broadcastA: {
                this.activities.remove((Object)Activity.broadcastAV);
                break;
            }
            case broadcastAV: {
                this.activities.remove((Object)Activity.broadcastA);
                this.activities.remove((Object)Activity.broadcastV);
                break;
            }
        }
        return this;
    }

    public Date getConnectedSince() {
        return this.connectedSince;
    }

    @Override
    public Long getId() {
        return null;
    }

    @Override
    public void setId(Long id) {
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Client setRoomId(Long roomId) {
        this.roomId = roomId;
        return this;
    }

    public Pod getPod() {
        return this.pod;
    }

    public void setPod(Integer i) {
        this.pod = i != null && i > 0 ? (i == 1 ? Pod.left : Pod.right) : Pod.none;
    }

    public boolean isCamEnabled() {
        return this.cam > -1;
    }

    public int getCam() {
        return this.cam;
    }

    public void setCam(int cam) {
        this.cam = cam;
    }

    public boolean isMicEnabled() {
        return this.mic > -1;
    }

    public int getMic() {
        return this.mic;
    }

    public void setMic(int mic) {
        this.mic = mic;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Client)) {
            return false;
        }
        Client other = (Client)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    public String toString() {
        return "Client [uid=" + this.uid + ", sessionId=" + this.sessionId + ", pageId=" + this.pageId + ", userId=" + this.user.getId() + ", roomId=" + this.roomId + ", rights=" + this.rights + ", activities=" + this.activities + ", connectedSince=" + this.connectedSince + ", pod = " + (Object)((Object)this.pod) + "]";
    }

    public static enum Pod {
        none,
        left,
        right;

    }

    public static enum Activity {
        broadcastA,
        broadcastV,
        broadcastAV,
        share,
        record,
        publish,
        muted,
        exclusive;

    }
}

