/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class AuthLevelUtil {
    private static final Logger log = Red5LoggerFactory.getLogger(AuthLevelUtil.class, (String)OpenmeetingsVariables.webAppRootKey);

    private static boolean check(Set<User.Right> rights, User.Right level) {
        boolean result = rights.contains((Object)level);
        log.debug(String.format("Level %s :: %s", new Object[]{level, result ? "[GRANTED]" : "[DENIED]"}));
        return result;
    }

    public static boolean hasUserLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.Room);
    }

    public static Set<Room.Right> getRoomRight(User u, Room r, Appointment a, int userCount) {
        HashSet<Room.Right> result = new HashSet<Room.Right>();
        if (u == null) {
            return result;
        }
        if (AuthLevelUtil.hasAdminLevel(u.getRights())) {
            result.add(Room.Right.superModerator);
        } else if (r.isAppointment() && a != null && u.getId().equals(a.getOwner().getId())) {
            result.add(Room.Right.superModerator);
        }
        if (result.isEmpty()) {
            if (!r.isModerated() && 1 == userCount) {
                result.add(Room.Right.moderator);
            }
            for (RoomModerator rm : r.getModerators()) {
                if (!u.getId().equals(rm.getUser().getId())) continue;
                result.add(rm.isSuperModerator() ? Room.Right.superModerator : Room.Right.moderator);
                break;
            }
            if (result.isEmpty() && !r.getRoomGroups().isEmpty()) {
                for (RoomGroup rg : r.getRoomGroups()) {
                    for (GroupUser gu : u.getGroupUsers()) {
                        if (!gu.getGroup().getId().equals(rg.getGroup().getId()) || !gu.isModerator()) continue;
                        result.add(Room.Right.moderator);
                        break;
                    }
                    if (result.isEmpty()) continue;
                    break;
                }
            }
        }
        if (Room.Type.conference == r.getType() && !result.contains((Object)Room.Right.video)) {
            result.add(Room.Right.audio);
            result.add(Room.Right.video);
        }
        return result;
    }

    public static boolean hasAdminLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.Admin);
    }

    public static boolean hasGroupAdminLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.GroupAdmin);
    }

    public static boolean hasWebServiceLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.Soap);
    }

    public static boolean hasLoginLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.Login);
    }
}

