/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.openmeetings.db.entity.user.User;

public class FormatHelper {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");

    public static boolean isRtlLanguage(String languageString) {
        return languageString != null && RtlLocalesRe.matcher(languageString).find();
    }

    public static String formatUser(User u) {
        return FormatHelper.formatUser(u, false);
    }

    public static String formatUser(User u, boolean isHTMLEscape) {
        String user = "";
        if (u != null) {
            String email = u.getAddress() == null ? "" : u.getAddress().getEmail();
            user = u.getFirstname() == null && u.getLastname() == null ? email : String.format("\"%s %s\" <%s>", u.getFirstname(), u.getLastname(), email);
            user = isHTMLEscape ? StringEscapeUtils.escapeHtml4((String)user) : user;
        }
        return user;
    }
}

