/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import com.github.openjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.Application;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ConfigurationDao
implements IDataProviderDao<Configuration> {
    private static final Logger log = Red5LoggerFactory.getLogger(ConfigurationDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    private static final String[] searchFields = new String[]{"key", "value"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    public void updateClusterAddresses(String addresses) throws UnknownHostException {
        OpenJPAConfiguration cfg = ((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)this.em)).getConfiguration();
        RemoteCommitProvider prov = cfg.getRemoteCommitEventManager().getRemoteCommitProvider();
        if (prov instanceof TCPRemoteCommitProvider) {
            ((TCPRemoteCommitProvider)prov).setAddresses(addresses);
        }
    }

    public Configuration forceGet(String key) {
        try {
            List list = this.em.createNamedQuery("forceGetConfigurationByKey", Configuration.class).setParameter("key", (Object)key).getResultList();
            if (list.isEmpty()) {
                return null;
            }
            Configuration c = (Configuration)list.get(0);
            return c.getKey().equals(key) ? c : null;
        }
        catch (Exception e) {
            log.error("[forceGet]: ", (Throwable)e);
            return null;
        }
    }

    public List<Configuration> get(String ... keys) {
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        for (String key : keys) {
            List r = this.em.createNamedQuery("getConfigurationsByKeys", Configuration.class).setParameter("keys", Arrays.asList(key)).getResultList();
            result.add(r.isEmpty() ? null : (Configuration)r.get(0));
        }
        return result;
    }

    public Configuration get(String key) {
        List<Configuration> list = this.get(new String[]{key});
        if (list == null || list.isEmpty() || list.get(0) == null) {
            log.warn("Could not find key in configurations: " + key);
            return null;
        }
        return list.get(0);
    }

    public boolean getBool(String key, boolean def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                return c.getValueB();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public Long getLong(String key, Long def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                return c.getValueN();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public int getInt(String key, int def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                Long val = c.getValueN();
                return val == null ? def : val.intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key, String def) {
        Configuration c = this.get(key);
        if (c != null) {
            return c.getValue();
        }
        return def;
    }

    @Override
    public Configuration get(long id) {
        return this.get((Long)id);
    }

    @Override
    public Configuration get(Long id) {
        if (id == null) {
            return null;
        }
        return (Configuration)this.em.createNamedQuery("getConfigurationById", Configuration.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<Configuration> get(int start, int count) {
        return this.em.createNamedQuery("getNondeletedConfiguration", Configuration.class).setFirstResult(start).setMaxResults(count).getResultList();
    }

    @Override
    public List<Configuration> get(String search, int start, int count, String sort) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Configuration", (String)"c", (String)search, (boolean)true, (boolean)false, (String)sort, (String[])searchFields), Configuration.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countConfigurations", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Configuration", (String)"c", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public Configuration update(Configuration entity, Long userId) {
        return this.update(entity, userId, false);
    }

    public Configuration update(Configuration entity, Long userId, boolean deleted) {
        String key = entity.getKey();
        String value = entity.getValue();
        if (entity.getId() == null || entity.getId() <= 0L) {
            entity.setInserted(new Date());
            entity.setDeleted(deleted);
            this.em.persist((Object)entity);
        } else {
            entity.setUser(this.userDao.get(userId));
            entity.setDeleted(deleted);
            entity.setUpdated(new Date());
            entity = (Configuration)this.em.merge((Object)entity);
        }
        switch (key) {
            case "flash.secure": 
            case "flash.secure.proxy": 
            case "flash.video.codec": 
            case "flash.video.fps": 
            case "flash.video.bandwidth": 
            case "flash.cam.quality": 
            case "flash.echoPath": 
            case "flash.mic.rate": {
                this.reloadRoomSettings();
                break;
            }
            case "max.upload.size": {
                this.reloadMaxUpload();
                break;
            }
            case "crypt.class.name": {
                this.reloadCrypt();
                break;
            }
            case "application.name": {
                OpenmeetingsVariables.setApplicationName((String)value);
                break;
            }
            case "application.base.url": {
                this.reloadBaseUrl();
                break;
            }
            case "sip.enable": {
                this.reloadSipEnabled();
                break;
            }
            case "google.analytics.code": {
                this.reloadGaCode();
                break;
            }
            case "header.x.frame.options": {
                IApplication iapp = (IApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
                if (iapp == null) break;
                iapp.setXFrameOptions(value);
                break;
            }
            case "header.content.security.policy": {
                IApplication iapp = (IApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
                if (iapp == null) break;
                iapp.setContentSecurityPolicy(value);
                break;
            }
            case "external.process.ttl": {
                OpenmeetingsVariables.setExtProcessTtl((int)NumberUtils.toInt((String)value));
                break;
            }
            case "default.lang.id": {
                this.reloadDefaultLang();
            }
        }
        return entity;
    }

    @Override
    public void delete(Configuration entity, Long userId) {
        entity.setUpdated(new Date());
        this.update(entity, userId, true);
    }

    private void reloadMaxUpload() {
        try {
            OpenmeetingsVariables.setMaxUploadSize((long)this.getLong("max.upload.size", 0x6400000L));
        }
        catch (Exception e) {
            log.error("Invalid value saved for max_upload_size conf key: ", (Throwable)e);
        }
    }

    private void reloadCrypt() {
        String cryptClass = this.getString("crypt.class.name", null);
        if (cryptClass != null) {
            OpenmeetingsVariables.setCryptClassName((String)cryptClass);
            CryptProvider.reset();
        }
    }

    private void reloadBaseUrl() {
        String val = this.getString("application.base.url", "http://localhost:5080/openmeetings/");
        if (val != null && !val.endsWith("/")) {
            val = val + "/";
        }
        OpenmeetingsVariables.setBaseUrl((String)val);
    }

    private void reloadSipEnabled() {
        OpenmeetingsVariables.setSipEnabled((boolean)this.getBool("sip.enable", false));
    }

    private void reloadGaCode() {
        OpenmeetingsVariables.setGaCode((String)this.getString("google.analytics.code", null));
    }

    private void reloadDefaultLang() {
        OpenmeetingsVariables.setDefaultLang((Long)this.getLong("default.lang.id", 1L));
    }

    public void reinit() {
        this.reloadMaxUpload();
        this.reloadCrypt();
        OpenmeetingsVariables.setApplicationName((String)this.getString("application.name", "OpenMeetings"));
        this.reloadDefaultLang();
        this.reloadBaseUrl();
        this.reloadSipEnabled();
        this.reloadGaCode();
        this.reloadRoomSettings();
    }

    private JSONObject reloadRoomSettings() {
        try {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(new File(new File(OmFileHelper.getRootDir(), "conf"), "red5.properties"));){
                props.load(is);
            }
            OpenmeetingsVariables.setRoomSettings((JSONObject)new JSONObject().put("secure", this.getBool("flash.secure", false)).put("native", "best".equals(this.getString("flash.secure.proxy", "none"))).put("rtmpPort", (Object)props.getProperty("rtmp.port")).put("rtmpsPort", (Object)props.getProperty("rtmps.port")).put("videoCodec", (Object)this.getString("flash.video.codec", "h263")).put("fps", (Object)this.getLong("flash.video.fps", 30L)).put("bandwidth", (Object)this.getLong("flash.video.bandwidth", 0L)).put("quality", (Object)this.getLong("flash.cam.quality", 90L)).put("echoPath", (Object)this.getLong("flash.echoPath", 128L)).put("micRate", (Object)this.getLong("flash.mic.rate", 22L)).put("keycode", (Object)new JSONObject().put("arrange", (Object)this.getLong("video.arrange.keycode", 119L)).put("exclusive", (Object)this.getLong("exclusive.audio.keycode", 123L)).put("mute", (Object)this.getLong("mute.keycode", 118L))));
        }
        catch (Exception e) {
            log.error("Unexpected exception while reloading room settings: ", (Throwable)e);
        }
        return OpenmeetingsVariables.getRoomSettings();
    }
}

