/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.user.PrivateMessageFolder;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class PrivateMessageFolderDao
implements IDataProviderDao<PrivateMessageFolder> {
    private static final Logger log = Red5LoggerFactory.getLogger(PrivateMessageFolderDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;

    public Long addPrivateMessageFolder(String folderName, Long userId) {
        try {
            PrivateMessageFolder privateMessageFolder = new PrivateMessageFolder();
            privateMessageFolder.setFolderName(folderName);
            privateMessageFolder.setUserId(userId);
            privateMessageFolder.setInserted(new Date());
            privateMessageFolder = (PrivateMessageFolder)this.em.merge((Object)privateMessageFolder);
            return privateMessageFolder.getId();
        }
        catch (Exception e) {
            log.error("[addPrivateMessageFolder]", (Throwable)e);
            return null;
        }
    }

    public Long addPrivateMessageFolderObj(PrivateMessageFolder folder) {
        folder.setInserted(new Date());
        folder = (PrivateMessageFolder)this.em.merge((Object)folder);
        return folder.getId();
    }

    @Override
    public PrivateMessageFolder get(long id) {
        return this.get((Long)id);
    }

    @Override
    public PrivateMessageFolder get(Long id) {
        String hql = "select c from PrivateMessageFolder c where c.id = :id ";
        List list = this.em.createQuery("select c from PrivateMessageFolder c where c.id = :id ", PrivateMessageFolder.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (PrivateMessageFolder)list.get(0) : null;
    }

    @Override
    public List<PrivateMessageFolder> get(int start, int count) {
        return this.em.createQuery("SELECT c FROM PrivateMessageFolder c ORDER BY c.id", PrivateMessageFolder.class).setFirstResult(start).setMaxResults(count).getResultList();
    }

    @Override
    public PrivateMessageFolder update(PrivateMessageFolder folder, Long userId) {
        if (folder.getId() == null) {
            this.em.persist((Object)folder);
        } else {
            folder = (PrivateMessageFolder)this.em.merge((Object)folder);
        }
        return folder;
    }

    @Override
    public void delete(PrivateMessageFolder folder, Long userId) {
        folder = (PrivateMessageFolder)this.em.find(PrivateMessageFolder.class, (Object)folder.getId());
        this.em.remove((Object)folder);
    }

    @Override
    public List<PrivateMessageFolder> get(String search, int start, int count, String order) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }
}

