/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.calendar;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.file.BaseFileItemDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.calendar.MeetingMemberDTO;
import org.apache.openmeetings.db.dto.room.RoomDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.user.User;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppointmentDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String title;
    private String location;
    private Calendar start;
    private Calendar end;
    private String description;
    private UserDTO owner;
    private Date inserted;
    private Date updated;
    private boolean deleted;
    private Appointment.Reminder reminder;
    private RoomDTO room;
    private String icalId;
    private List<MeetingMemberDTO> meetingMembers = new ArrayList<MeetingMemberDTO>();
    private Long languageId;
    private String password;
    private boolean passwordProtected;
    private boolean connectedEvent;
    private boolean reminderEmailSend;

    public AppointmentDTO() {
    }

    public AppointmentDTO(Appointment a) {
        this.id = a.getId();
        this.title = a.getTitle();
        this.location = a.getLocation();
        TimeZone tz = TimeZone.getTimeZone(a.getOwner().getTimeZoneId());
        this.start = Calendar.getInstance(tz);
        this.start.setTime(a.getStart());
        this.end = Calendar.getInstance(tz);
        this.end.setTime(a.getEnd());
        this.description = a.getDescription();
        this.owner = new UserDTO(a.getOwner());
        this.inserted = a.getInserted();
        this.updated = a.getUpdated();
        this.deleted = a.isDeleted();
        this.reminder = a.getReminder();
        this.room = new RoomDTO(a.getRoom());
        this.icalId = a.getIcalId();
        if (a.getMeetingMembers() != null) {
            for (MeetingMember mm : a.getMeetingMembers()) {
                this.meetingMembers.add(new MeetingMemberDTO(mm));
            }
        }
        this.languageId = a.getLanguageId();
        this.passwordProtected = a.isPasswordProtected();
        this.connectedEvent = a.isConnectedEvent();
        this.reminderEmailSend = a.isReminderEmailSend();
    }

    public Appointment get(UserDao userDao, BaseFileItemDao fileDao, AppointmentDao appointmentDao, User u) {
        Appointment a = this.id == null ? new Appointment() : appointmentDao.get(this.id);
        a.setId(this.id);
        a.setTitle(this.title);
        a.setLocation(this.location);
        a.setStart(this.start.getTime());
        a.setEnd(this.end.getTime());
        a.setDescription(this.description);
        a.setOwner(this.owner == null ? u : userDao.get(this.owner.getId()));
        a.setInserted(this.inserted);
        a.setUpdated(this.updated);
        a.setDeleted(this.deleted);
        a.setReminder(this.reminder);
        a.setRoom(this.room.get(fileDao));
        a.setIcalId(this.icalId);
        ArrayList<MeetingMember> mml = new ArrayList<MeetingMember>();
        for (MeetingMemberDTO mm : this.meetingMembers) {
            MeetingMember m = null;
            if (mm.getId() != null) {
                for (MeetingMember m1 : a.getMeetingMembers()) {
                    if (!m1.getId().equals(mm.getId())) continue;
                    m = m1;
                    break;
                }
                if (m == null) {
                    throw new RuntimeException("Weird guest from different appointment is passed");
                }
            } else {
                m = mm.get(userDao, u);
                m.setAppointment(a);
            }
            mml.add(m);
        }
        a.setMeetingMembers(mml);
        a.setLanguageId(this.languageId);
        a.setPasswordProtected(this.passwordProtected);
        a.setConnectedEvent(this.connectedEvent);
        a.setReminderEmailSend(this.reminderEmailSend);
        return a;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getStart() {
        return this.start;
    }

    public void setStart(Calendar start) {
        this.start = start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public void setEnd(Calendar end) {
        this.end = end;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserDTO getOwner() {
        return this.owner;
    }

    public void setOwner(UserDTO owner) {
        this.owner = owner;
    }

    public Date getInserted() {
        return this.inserted;
    }

    public void setInserted(Date inserted) {
        this.inserted = inserted;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Appointment.Reminder getReminder() {
        return this.reminder;
    }

    public void setReminder(Appointment.Reminder reminder) {
        this.reminder = reminder;
    }

    public RoomDTO getRoom() {
        return this.room;
    }

    public void setRoom(RoomDTO room) {
        this.room = room;
    }

    public String getIcalId() {
        return this.icalId;
    }

    public void setIcalId(String icalId) {
        this.icalId = icalId;
    }

    public List<MeetingMemberDTO> getMeetingMembers() {
        return this.meetingMembers;
    }

    public void setMeetingMembers(List<MeetingMemberDTO> meetingMembers) {
        this.meetingMembers = meetingMembers;
    }

    public Long getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Long languageId) {
        this.languageId = languageId;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public void setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    public boolean isConnectedEvent() {
        return this.connectedEvent;
    }

    public void setConnectedEvent(boolean connectedEvent) {
        this.connectedEvent = connectedEvent;
    }

    public boolean isReminderEmailSend() {
        return this.reminderEmailSend;
    }

    public void setReminderEmailSend(boolean reminderEmailSend) {
        this.reminderEmailSend = reminderEmailSend;
    }

    public static List<AppointmentDTO> list(List<Appointment> list) {
        ArrayList<AppointmentDTO> result = new ArrayList<AppointmentDTO>(list.size());
        for (Appointment a : list) {
            result.add(new AppointmentDTO(a));
        }
        return result;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

