/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.TimeZone;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimezoneUtil {
    private static final Logger log = Red5LoggerFactory.getLogger(TimezoneUtil.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @Autowired
    private ConfigurationDao cfgDao;

    public TimeZone getTimeZone(String timeZoneId) {
        if (Strings.isEmpty((CharSequence)timeZoneId)) {
            return this.getDefaultTimeZone();
        }
        return TimeZone.getTimeZone(timeZoneId);
    }

    public TimeZone getDefaultTimeZone() {
        String defaultTzName = this.cfgDao.getString("default.timezone", "Europe/Berlin");
        TimeZone timeZoneByOmTimeZone = TimeZone.getTimeZone(defaultTzName);
        if (timeZoneByOmTimeZone != null) {
            return timeZoneByOmTimeZone;
        }
        log.error("There is no correct time zone set in the configuration of OpenMeetings for the key default.timezone or key is missing in table, using default locale!");
        return TimeZone.getDefault();
    }

    public TimeZone getTimeZone(User user) {
        TimeZone timeZone;
        if (user != null && user.getTimeZoneId() != null && (timeZone = TimeZone.getTimeZone(user.getTimeZoneId())) != null) {
            return timeZone;
        }
        return this.getDefaultTimeZone();
    }
}

