/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CheckDto {
    private final long roomId;
    private final Room.Type roomType;
    private final boolean audioOnly;
    private final Set<Client.Activity> activities = new HashSet<Client.Activity>();
    private final Client.Pod pod;

    public CheckDto(Client c) {
        this.roomId = c.getRoom().getId();
        this.roomType = c.getRoom().getType();
        this.audioOnly = c.getRoom().isAudioOnly();
        if (c.hasActivity(Client.Activity.broadcastA)) {
            this.activities.add(Client.Activity.broadcastA);
        }
        if (c.hasActivity(Client.Activity.broadcastV)) {
            this.activities.add(Client.Activity.broadcastV);
        }
        this.pod = c.getPod();
    }

    public long getRoomId() {
        return this.roomId;
    }

    public Room.Type getRoomType() {
        return this.roomType;
    }

    public boolean isAudioOnly() {
        return this.audioOnly;
    }

    public Set<Client.Activity> getActivities() {
        return this.activities;
    }

    public Client.Pod getPod() {
        return this.pod;
    }
}

