/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import org.apache.openmeetings.db.dao.server.ISessionManager;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IClient;
import org.apache.openmeetings.db.entity.room.StreamClient;

public class RoomHelper {
    private RoomHelper() {
    }

    public static JSONObject videoJson(Client c, boolean self, String sid, ISessionManager mgr, String uid) {
        StreamClient sc = mgr.get(uid);
        if (sc == null) {
            return new JSONObject();
        }
        JSONObject o = c.toJson(self).put("sid", (Object)sid).put("uid", (Object)sc.getUid()).put("broadcastId", (Object)sc.getBroadcastId()).put("width", sc.getWidth()).put("height", sc.getHeight()).put("type", (Object)sc.getType());
        return RoomHelper.addScreenActivities(o, sc);
    }

    public static JSONObject addScreenActivities(JSONObject o, StreamClient sc) {
        JSONArray a = new JSONArray();
        if (IClient.Type.sharing == sc.getType()) {
            if (sc.isSharingStarted()) {
                a.put((Object)"sharing");
            }
            if (sc.isRecordingStarted()) {
                a.put((Object)"recording");
            }
            if (sc.isPublishStarted()) {
                a.put((Object)"publish");
            }
        }
        return o.put("screenActivities", (Object)a);
    }
}

