/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.mina.util.ConcurrentHashSet;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.IClient;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.StreamClient;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IStreamClientManager;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.util.string.Strings;

public class Client
implements IClient {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private int pageId;
    private User user;
    private Room room;
    private final String uid;
    private final String sid;
    private String remoteAddress;
    private final Set<Room.Right> rights = new ConcurrentHashSet();
    private final Set<Activity> activities = new ConcurrentHashSet();
    private final Set<String> streams = new ConcurrentHashSet();
    private final Date connectedSince;
    private int cam = -1;
    private int mic = -1;
    private int width = 0;
    private int height = 0;
    private String serverId = null;
    private Long recordingId;

    public Client(String sessionId, int pageId, Long userId, UserDao dao) {
        this.sessionId = sessionId;
        this.pageId = pageId;
        this.user = dao.get(userId);
        this.connectedSince = new Date();
        this.uid = UUID.randomUUID().toString();
        this.sid = UUID.randomUUID().toString();
    }

    public Client(StreamClient rcl, User user) {
        this.sessionId = UUID.randomUUID().toString();
        this.pageId = 0;
        this.user = user;
        this.connectedSince = new Date();
        this.uid = rcl.getUid();
        this.sid = rcl.getSid();
        this.remoteAddress = rcl.getRemoteAddress();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getPageId() {
        return this.pageId;
    }

    public Client setPageId(IKey key) {
        this.pageId = key.hashCode();
        return this;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public User getUser() {
        return this.user;
    }

    public Client updateUser(UserDao dao) {
        this.user = dao.get(this.user.getId());
        return this;
    }

    @Override
    public Long getUserId() {
        return this.user.getId();
    }

    @Override
    public String getLogin() {
        return this.user.getLogin();
    }

    @Override
    public String getFirstname() {
        return this.user.getFirstname();
    }

    @Override
    public String getLastname() {
        return this.user.getLastname();
    }

    @Override
    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getSid() {
        return this.sid;
    }

    public void clear() {
        this.activities.clear();
        this.rights.clear();
        this.streams.clear();
    }

    public boolean hasRight(Room.Right right) {
        if (Room.Right.superModerator == right) {
            return this.rights.contains((Object)right);
        }
        return this.rights.contains((Object)Room.Right.superModerator) || this.rights.contains((Object)Room.Right.moderator) || this.rights.contains((Object)right);
    }

    public Client allow(Room.Right ... _rights) {
        this.allow(Arrays.asList(_rights));
        return this;
    }

    public void allow(Iterable<Room.Right> _rights) {
        for (Room.Right right : _rights) {
            if (this.hasRight(right)) continue;
            this.rights.add(right);
        }
    }

    public void deny(Room.Right ... _rights) {
        for (Room.Right right : _rights) {
            this.rights.remove((Object)right);
        }
    }

    public void clearActivities() {
        this.activities.clear();
    }

    public boolean hasAnyActivity(Activity ... aa) {
        boolean res = false;
        if (aa != null) {
            for (Activity a : aa) {
                res |= this.activities.contains((Object)a);
            }
        }
        return res;
    }

    public boolean hasActivity(Activity a) {
        return this.activities.contains((Object)a);
    }

    public void toggle(Activity a) {
        if (this.hasActivity(a)) {
            this.remove(a);
        } else {
            this.set(a);
        }
    }

    public Client set(Activity a) {
        this.activities.add(a);
        switch (a) {
            case broadcastV: 
            case broadcastA: {
                if (!this.hasActivity(Activity.broadcastA) || !this.hasActivity(Activity.broadcastV)) break;
                this.activities.add(Activity.broadcastAV);
                break;
            }
            case broadcastAV: {
                this.activities.add(Activity.broadcastA);
                this.activities.add(Activity.broadcastV);
                break;
            }
        }
        return this;
    }

    public Client remove(Activity a) {
        this.activities.remove((Object)a);
        switch (a) {
            case broadcastV: 
            case broadcastA: {
                this.activities.remove((Object)Activity.broadcastAV);
                break;
            }
            case broadcastAV: {
                this.activities.remove((Object)Activity.broadcastA);
                this.activities.remove((Object)Activity.broadcastV);
                break;
            }
        }
        return this;
    }

    public Client addStream(String _uid) {
        this.streams.add(_uid);
        return this;
    }

    public Client removeStream(String _uid) {
        this.streams.remove(_uid);
        return this;
    }

    public List<String> getStreams() {
        return new ArrayList<String>(this.streams);
    }

    public Date getConnectedSince() {
        return this.connectedSince;
    }

    @Override
    public Long getId() {
        return null;
    }

    @Override
    public void setId(Long id) {
    }

    public Room getRoom() {
        return this.room;
    }

    public Client setRoom(Room room) {
        this.room = room;
        return this;
    }

    public boolean isCamEnabled() {
        return this.cam > -1;
    }

    public int getCam() {
        return this.cam;
    }

    public Client setCam(int cam) {
        this.cam = cam;
        return this;
    }

    public boolean isMicEnabled() {
        return this.mic > -1;
    }

    public int getMic() {
        return this.mic;
    }

    public Client setMic(int mic) {
        this.mic = mic;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public Client setWidth(int width) {
        this.width = width;
        return this;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public Client setHeight(int height) {
        this.height = height;
        return this;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Client setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public void setRecordingStarted(boolean recordingStarted) {
        if (recordingStarted) {
            this.activities.add(Activity.record);
        } else {
            this.activities.remove((Object)Activity.record);
        }
    }

    @Override
    public Long getRecordingId() {
        return this.recordingId;
    }

    @Override
    public void setRecordingId(Long recordingId) {
        this.recordingId = recordingId;
    }

    @Override
    public Long getRoomId() {
        return this.room == null ? null : this.room.getId();
    }

    @Override
    public Room.Type getRoomType() {
        return this.room == null ? null : this.room.getType();
    }

    public JSONObject toJson(boolean self) {
        JSONObject u = new JSONObject();
        if (this.user != null) {
            JSONObject a = new JSONObject();
            u.put("id", (Object)this.user.getId()).put("firstName", (Object)this.user.getFirstname()).put("lastName", (Object)this.user.getLastname()).put("displayName", (Object)this.user.getDisplayName()).put("address", (Object)a);
            if (this.user.getAddress() != null) {
                if (Strings.isEmpty((CharSequence)this.user.getFirstname()) && Strings.isEmpty((CharSequence)this.user.getLastname())) {
                    a.put("email", (Object)this.user.getAddress().getEmail());
                }
                a.put("country", (Object)this.user.getAddress().getCountry());
            }
        }
        JSONObject json = new JSONObject().put("user", (Object)u).put("cuid", (Object)this.uid).put("uid", (Object)this.uid).put("rights", (Object)new JSONArray(this.rights)).put("activities", (Object)new JSONArray(this.activities)).put("width", this.width).put("height", this.height).put("self", self);
        if (self) {
            json.put("cam", this.cam).put("mic", this.mic);
        }
        return json;
    }

    public JSONObject streamJson(String _sid, boolean self, IStreamClientManager mgr) {
        JSONArray _streams = new JSONArray();
        boolean avFound = false;
        for (String _uid : this.streams) {
            StreamClient rc = mgr.get(_uid);
            if (rc == null) continue;
            IClient.Type t = rc.getType();
            if (IClient.Type.room == t) {
                avFound = true;
            }
            _streams.put((Object)Client.addScreenActivities(new JSONObject().put("type", (Object)t.name()).put("uid", (Object)(self && IClient.Type.room == t ? this.uid : rc.getUid())).put("broadcastId", (Object)rc.getBroadcastId()).put("width", rc.getWidth()).put("height", rc.getHeight()), rc));
        }
        if (self && !avFound && this.hasAnyActivity(Activity.broadcastA, Activity.broadcastV)) {
            _streams.put((Object)new JSONObject().put("type", (Object)IClient.Type.room.name()).put("uid", (Object)this.uid).put("width", this.width).put("height", this.height));
        }
        return this.toJson(self).put("sid", (Object)_sid).put("streams", (Object)_streams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Client c) {
        this.user = c.user;
        this.room = c.room;
        HashSet<Room.Right> rr = new HashSet<Room.Right>(c.rights);
        Set<Room.Right> set = this.rights;
        synchronized (set) {
            this.rights.clear();
            this.rights.addAll(rr);
        }
        HashSet<Activity> aa = new HashSet<Activity>(c.activities);
        Set<Activity> set2 = this.activities;
        synchronized (set2) {
            this.activities.clear();
            this.activities.addAll(aa);
        }
        HashSet<String> ss = new HashSet<String>(c.streams);
        Set<String> set3 = this.streams;
        synchronized (set3) {
            this.streams.clear();
            this.streams.addAll(ss);
        }
        this.cam = c.cam;
        this.mic = c.mic;
        this.width = c.width;
        this.height = c.height;
        this.recordingId = c.recordingId;
    }

    public Client setActivities(String avSettings) {
        if (!Strings.isEmpty((CharSequence)avSettings)) {
            this.clearActivities();
            if (avSettings.indexOf(97) > -1) {
                this.set(Activity.broadcastA);
            }
            if (avSettings.indexOf(118) > -1) {
                this.set(Activity.broadcastV);
            }
        }
        return this;
    }

    public static JSONObject addScreenActivities(JSONObject o, StreamClient sc) {
        JSONArray a = new JSONArray();
        if (IClient.Type.sharing == sc.getType()) {
            if (sc.isSharingStarted()) {
                a.put((Object)"sharing");
            }
            if (sc.isRecordingStarted()) {
                a.put((Object)"recording");
            }
            if (sc.isPublishStarted()) {
                a.put((Object)"publish");
            }
        }
        return o.put("screenActivities", (Object)a);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Client)) {
            return false;
        }
        Client other = (Client)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    public String toString() {
        return "Client [uid=" + this.uid + ", sessionId=" + this.sessionId + ", pageId=" + this.pageId + ", userId=" + this.user.getId() + ", room=" + (this.room == null ? null : this.room.getId()) + ", rights=" + this.rights + ", activities=" + this.activities + ", connectedSince=" + this.connectedSince + "]";
    }

    public static enum Activity {
        broadcastA,
        broadcastV,
        broadcastAV,
        share,
        record,
        publish;

    }
}

