/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.room.RoomPollAnswer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class PollDao {
    private static final Logger log = Red5LoggerFactory.getLogger(PollDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;

    public RoomPoll update(RoomPoll p) {
        if (p.getId() == null) {
            p.setCreated(new Date());
            this.em.persist((Object)p);
        } else {
            p = (RoomPoll)this.em.merge((Object)p);
        }
        return p;
    }

    public boolean close(Long roomId) {
        try {
            log.debug(" :: close :: ");
            Query q = this.em.createNamedQuery("closePoll");
            q.setParameter("roomId", (Object)roomId);
            q.setParameter("archived", (Object)true);
            return q.executeUpdate() > 0;
        }
        catch (Exception err) {
            log.error("[close]", (Throwable)err);
            return false;
        }
    }

    public boolean delete(RoomPoll p) {
        try {
            log.debug(" :: delete :: ");
            Query q = this.em.createNamedQuery("deletePoll");
            q.setParameter("id", (Object)p.getId());
            return q.executeUpdate() > 0;
        }
        catch (Exception err) {
            log.error("[delete]", (Throwable)err);
            return false;
        }
    }

    public RoomPoll get(Long id) {
        List list = this.em.createNamedQuery("getPollById", RoomPoll.class).setParameter("id", (Object)id).getResultList();
        return list.isEmpty() ? null : (RoomPoll)list.get(0);
    }

    public RoomPoll getByRoom(Long roomId) {
        log.debug(" :: getPoll :: {}", (Object)roomId);
        List list = this.em.createNamedQuery("getPoll", RoomPoll.class).setParameter("roomId", (Object)roomId).getResultList();
        return list.size() == 1 ? (RoomPoll)list.get(0) : null;
    }

    public List<RoomPoll> get() {
        return this.em.createNamedQuery("getPollListBackup", RoomPoll.class).getResultList();
    }

    public List<RoomPoll> getArchived(Long roomId) {
        log.debug(" :: getArchived :: {}", (Object)roomId);
        return this.em.createNamedQuery("getArchivedPollList", RoomPoll.class).setParameter("roomId", (Object)roomId).getResultList();
    }

    public boolean hasPoll(Long roomId) {
        log.debug(" :: hasPoll :: " + roomId);
        return (Long)this.em.createNamedQuery("hasPoll", Long.class).setParameter("roomId", (Object)roomId).setParameter("archived", (Object)false).getSingleResult() > 0L;
    }

    public boolean hasVoted(Long roomId, Long userId) {
        return !this.em.createNamedQuery("hasVoted", RoomPollAnswer.class).setParameter("roomId", (Object)roomId).setParameter("userId", (Object)userId).getResultList().isEmpty();
    }
}

