/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.room;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.room.StreamClient;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;

@Entity
@FetchGroups(value={@FetchGroup(name="roomModerators", attributes={@FetchAttribute(name="moderators")}), @FetchGroup(name="roomGroups", attributes={@FetchAttribute(name="groups")}), @FetchGroup(name="roomFiles", attributes={@FetchAttribute(name="files")})})
@NamedQueries(value={@NamedQuery(name="getNondeletedRooms", query="SELECT r FROM Room r WHERE r.deleted = false"), @NamedQuery(name="getPublicRooms", query="SELECT r from Room r WHERE r.ispublic = true and r.deleted = false and r.type = :type"), @NamedQuery(name="getRoomByOwnerAndTypeId", query="SELECT r FROM Room as r WHERE r.ownerId = :ownerId AND r.type = :type AND r.deleted = false"), @NamedQuery(name="selectMaxFromRooms", query="SELECT COUNT(r.id) from Room r WHERE r.deleted = false AND r.name LIKE :search "), @NamedQuery(name="getRoomByExternalId", query="SELECT r FROM Room as r WHERE r.externalId = :externalId AND r.externalType = :externalType AND r.type = :type AND r.deleted = false"), @NamedQuery(name="getPublicRoomsOrdered", query="SELECT r from Room r WHERE r.ispublic= true AND r.deleted= false AND r.appointment = false ORDER BY r.name ASC"), @NamedQuery(name="getRoomById", query="SELECT r FROM Room r WHERE r.deleted = false AND r.id = :id"), @NamedQuery(name="getRoomsByIds", query="SELECT r FROM Room r WHERE r.deleted = false AND r.id IN :ids"), @NamedQuery(name="getSipRoomIdsByIds", query="SELECT r.id FROM Room r WHERE r.deleted = false AND r.sipEnabled = true AND r.id IN :ids"), @NamedQuery(name="countRooms", query="SELECT COUNT(r) FROM Room r WHERE r.deleted = false"), @NamedQuery(name="getBackupRooms", query="SELECT r FROM Room r ORDER BY r.id"), @NamedQuery(name="getRoomsCapacityByIds", query="SELECT SUM(r.capacity) FROM Room r WHERE r.deleted = false AND r.id IN :ids"), @NamedQuery(name="getGroupRooms", query="SELECT DISTINCT rg.room FROM RoomGroup rg LEFT JOIN FETCH rg.room WHERE rg.group.id = :groupId AND rg.room.deleted = false AND rg.room.appointment = false ORDER BY rg.room.name ASC")})
@Table(name="room")
@Root(name="room")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Room
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int CONFERENCE_TYPE_ID = 1;
    public static final int PRESENTATION_TYPE_ID = 3;
    public static final int INTERVIEW_TYPE_ID = 4;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(data=true, required=false, name="rooms_id")
    private Long id;
    @Column(name="name")
    @Element(data=true, required=false)
    private String name;
    @Lob
    @Column(name="comment")
    @Element(data=true, required=false)
    private String comment;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    @Element(name="roomtypeId", data=true, required=false)
    private Type type = Type.conference;
    @Column(name="ispublic", nullable=false)
    @Element(name="ispublic", data=true, required=false)
    private boolean ispublic;
    @Column(name="capacity")
    @Element(name="numberOfPartizipants", data=true, required=false)
    private long capacity = 4L;
    @Column(name="appointment", nullable=false)
    @Element(data=true, required=false)
    private boolean appointment;
    @Column(name="external_id")
    @Element(data=true, required=false)
    private String externalId;
    @Column(name="external_type")
    @Element(data=true, required=false)
    private String externalType;
    @Column(name="demo_room", nullable=false)
    @Element(name="isDemoRoom", data=true, required=false)
    private boolean demoRoom;
    @Column(name="demo_time")
    @Element(data=true, required=false)
    private Integer demoTime;
    @Column(name="ismoderatedroom", nullable=false)
    @Element(name="isModeratedRoom", data=true, required=false)
    private boolean moderated;
    @Column(name="allow_user_questions", nullable=false)
    @Element(data=true, required=false)
    private boolean allowUserQuestions;
    @Column(name="is_audio_only", nullable=false)
    @Element(name="isAudioOnly", data=true, required=false)
    private boolean audioOnly;
    @Column(name="is_closed", nullable=false)
    @Element(data=true, required=false)
    private boolean closed;
    @Column(name="redirect_url")
    @Element(data=true, required=false)
    private String redirectURL;
    @Column(name="owner_id")
    @Element(name="ownerid", data=true, required=false)
    private Long ownerId;
    @Column(name="wait_for_recording", nullable=false)
    @Element(data=true, required=false)
    private boolean waitForRecording;
    @Column(name="allow_recording", nullable=false)
    @Element(name="allowRecording", data=true, required=false)
    private boolean allowRecording = true;
    @Column(name="chat_moderated", nullable=false)
    @Element(data=true, required=false)
    private boolean chatModerated;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="hide_element")
    @CollectionTable(name="room_hide_element", joinColumns={@JoinColumn(name="room_id")})
    @Enumerated(value=EnumType.STRING)
    @ElementList(name="hide_element", data=true, required=false)
    private Set<RoomElement> hiddenElements = new HashSet<RoomElement>();
    @Column(name="chat_opened", nullable=false)
    @Element(data=true, required=false)
    private boolean chatOpened;
    @Column(name="files_opened", nullable=false)
    @Element(data=true, required=false)
    private boolean filesOpened;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="roomId")
    @ForeignKey(enabled=true)
    @ElementList(name="room_moderators", required=false)
    private List<RoomModerator> moderators = new ArrayList<RoomModerator>();
    @Column(name="sip_enabled", nullable=false)
    @Element(data=true, required=false)
    private boolean sipEnabled;
    @Column(name="confno")
    @Element(data=true, required=false)
    private String confno;
    @Column(name="pin")
    @Element(data=true, required=false)
    private String pin;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="room_id", insertable=true, updatable=true)
    @ElementDependent
    @Transient
    private List<RoomGroup> groups = new ArrayList<RoomGroup>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="room_id", insertable=true, updatable=true, nullable=false)
    @ElementDependent
    @Transient
    private List<RoomFile> files = new ArrayList<RoomFile>();
    @javax.persistence.Transient
    private List<StreamClient> currentusers;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$HistoricalEntity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$room$Room$Type;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$room$Room;

    public String getComment() {
        return Room.pcGetcomment(this);
    }

    public void setComment(String comment) {
        Room.pcSetcomment(this, comment);
    }

    public String getName() {
        return Room.pcGetname(this);
    }

    public void setName(String name) {
        Room.pcSetname(this, name);
    }

    @Override
    public Long getId() {
        return Room.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Room.pcSetid(this, id);
    }

    public Type getType() {
        return Room.pcGettype(this);
    }

    public void setType(Type type) {
        Room.pcSettype(this, type);
    }

    public boolean getIspublic() {
        return Room.pcGetispublic(this);
    }

    public void setIspublic(boolean ispublic) {
        Room.pcSetispublic(this, ispublic);
    }

    public List<StreamClient> getCurrentusers() {
        return this.currentusers;
    }

    public void setCurrentusers(List<StreamClient> currentusers) {
        this.currentusers = currentusers;
    }

    public long getCapacity() {
        return Room.pcGetcapacity(this);
    }

    public void setCapacity(long capacity) {
        Room.pcSetcapacity(this, capacity);
    }

    public boolean isAppointment() {
        return Room.pcGetappointment(this);
    }

    public void setAppointment(boolean appointment) {
        Room.pcSetappointment(this, appointment);
    }

    public boolean isDemoRoom() {
        return Room.pcGetdemoRoom(this);
    }

    public void setDemoRoom(boolean demoRoom) {
        Room.pcSetdemoRoom(this, demoRoom);
    }

    public Integer getDemoTime() {
        return Room.pcGetdemoTime(this);
    }

    public void setDemoTime(Integer demoTime) {
        Room.pcSetdemoTime(this, demoTime);
    }

    public boolean isModerated() {
        return Room.pcGetmoderated(this);
    }

    public void setModerated(boolean moderated) {
        Room.pcSetmoderated(this, moderated);
    }

    public String getExternalId() {
        return Room.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        Room.pcSetexternalId(this, externalId);
    }

    public String getExternalType() {
        return Room.pcGetexternalType(this);
    }

    public void setExternalType(String externalType) {
        Room.pcSetexternalType(this, externalType);
    }

    public boolean isAllowUserQuestions() {
        return Room.pcGetallowUserQuestions(this);
    }

    public void setAllowUserQuestions(boolean allowUserQuestions) {
        Room.pcSetallowUserQuestions(this, allowUserQuestions);
    }

    public boolean isAudioOnly() {
        return Room.pcGetaudioOnly(this);
    }

    public void setAudioOnly(boolean audioOnly) {
        Room.pcSetaudioOnly(this, audioOnly);
    }

    public boolean isClosed() {
        return Room.pcGetclosed(this);
    }

    public void setClosed(boolean closed) {
        Room.pcSetclosed(this, closed);
    }

    public String getRedirectURL() {
        return Room.pcGetredirectURL(this);
    }

    public void setRedirectURL(String redirectURL) {
        Room.pcSetredirectURL(this, redirectURL);
    }

    public Long getOwnerId() {
        return Room.pcGetownerId(this);
    }

    public void setOwnerId(Long ownerId) {
        Room.pcSetownerId(this, ownerId);
    }

    public boolean isWaitForRecording() {
        return Room.pcGetwaitForRecording(this);
    }

    public void setWaitForRecording(boolean waitForRecording) {
        Room.pcSetwaitForRecording(this, waitForRecording);
    }

    public boolean isAllowRecording() {
        return Room.pcGetallowRecording(this);
    }

    public void setAllowRecording(boolean allowRecording) {
        Room.pcSetallowRecording(this, allowRecording);
    }

    public List<RoomModerator> getModerators() {
        return Room.pcGetmoderators(this);
    }

    public void setModerators(List<RoomModerator> moderators) {
        if (moderators != null) {
            Room.pcSetmoderators(this, moderators);
        }
    }

    public boolean isChatModerated() {
        return Room.pcGetchatModerated(this);
    }

    public void setChatModerated(boolean chatModerated) {
        Room.pcSetchatModerated(this, chatModerated);
    }

    public Set<RoomElement> getHiddenElements() {
        return Room.pcGethiddenElements(this);
    }

    public void setHiddenElements(Set<RoomElement> hiddenElements) {
        Room.pcSethiddenElements(this, hiddenElements);
    }

    public boolean isHidden(RoomElement e) {
        return Room.pcGethiddenElements(this) != null && Room.pcGethiddenElements(this).contains((Object)e);
    }

    public boolean hide(RoomElement e) {
        if (Room.pcGethiddenElements(this) == null) {
            Room.pcSethiddenElements(this, new HashSet());
        }
        return Room.pcGethiddenElements(this).add(e);
    }

    public List<RoomGroup> getGroups() {
        return Room.pcGetgroups(this);
    }

    public void setGroups(List<RoomGroup> groups) {
        Room.pcSetgroups(this, groups);
    }

    public boolean isChatOpened() {
        return Room.pcGetchatOpened(this);
    }

    public void setChatOpened(boolean chatOpened) {
        Room.pcSetchatOpened(this, chatOpened);
    }

    public boolean isFilesOpened() {
        return Room.pcGetfilesOpened(this);
    }

    public void setFilesOpened(boolean filesOpened) {
        Room.pcSetfilesOpened(this, filesOpened);
    }

    public boolean isSipEnabled() {
        return Room.pcGetsipEnabled(this);
    }

    public void setSipEnabled(boolean sipEnabled) {
        Room.pcSetsipEnabled(this, sipEnabled);
    }

    public String getConfno() {
        return Room.pcGetconfno(this);
    }

    public void setConfno(String confno) {
        Room.pcSetconfno(this, confno);
    }

    public String getPin() {
        return Room.pcGetpin(this);
    }

    public void setPin(String pin) {
        Room.pcSetpin(this, pin);
    }

    public List<RoomFile> getFiles() {
        return Room.pcGetfiles(this);
    }

    public void setFiles(List<RoomFile> files) {
        Room.pcSetfiles(this, files);
    }

    public String toString() {
        return "Room [id=" + Room.pcGetid(this) + ", name=" + Room.pcGetname(this) + ", type=" + (Object)((Object)Room.pcGettype(this)) + "]";
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 121008823;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$HistoricalEntity != null ? class$Lorg$apache$openmeetings$db$entity$HistoricalEntity : (class$Lorg$apache$openmeetings$db$entity$HistoricalEntity = Room.class$("org.apache.openmeetings.db.entity.HistoricalEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"allowRecording", "allowUserQuestions", "appointment", "audioOnly", "capacity", "chatModerated", "chatOpened", "closed", "comment", "confno", "demoRoom", "demoTime", "externalId", "externalType", "files", "filesOpened", "groups", "hiddenElements", "id", "ispublic", "moderated", "moderators", "name", "ownerId", "pin", "redirectURL", "sipEnabled", "type", "waitForRecording"};
        Class[] classArray = new Class[29];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Long.TYPE;
        classArray[5] = Boolean.TYPE;
        classArray[6] = Boolean.TYPE;
        classArray[7] = Boolean.TYPE;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[8] = clazz2;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[10] = Boolean.TYPE;
        Class clazz3 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Room.class$("java.lang.Integer"));
        classArray[11] = clazz3;
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        classArray[14] = clazz4;
        classArray[15] = Boolean.TYPE;
        classArray[16] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        Class clazz5 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = Room.class$("java.util.Set"));
        classArray[17] = clazz5;
        Class clazz6 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Room.class$("java.lang.Long"));
        classArray[18] = clazz6;
        classArray[19] = Boolean.TYPE;
        classArray[20] = Boolean.TYPE;
        classArray[21] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Room.class$("java.util.List"));
        classArray[22] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[23] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Room.class$("java.lang.Long"));
        classArray[24] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[25] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Room.class$("java.lang.String"));
        classArray[26] = Boolean.TYPE;
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$room$Room$Type != null ? class$Lorg$apache$openmeetings$db$entity$room$Room$Type : (class$Lorg$apache$openmeetings$db$entity$room$Room$Type = Room.class$("org.apache.openmeetings.db.entity.room.Room$Type"));
        classArray[27] = clazz7;
        classArray[28] = Boolean.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 5, 10, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Room", (PersistenceCapable)new Room());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.allowRecording = false;
        this.allowUserQuestions = false;
        this.appointment = false;
        this.audioOnly = false;
        this.capacity = 0L;
        this.chatModerated = false;
        this.chatOpened = false;
        this.closed = false;
        this.comment = null;
        this.confno = null;
        this.demoRoom = false;
        this.demoTime = null;
        this.externalId = null;
        this.externalType = null;
        this.files = null;
        this.filesOpened = false;
        this.groups = null;
        this.hiddenElements = null;
        this.id = null;
        this.ispublic = false;
        this.moderated = false;
        this.moderators = null;
        this.name = null;
        this.ownerId = null;
        this.pin = null;
        this.redirectURL = null;
        this.sipEnabled = false;
        this.type = null;
        this.waitForRecording = false;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Room room = new Room();
        if (bl) {
            room.pcClearFields();
        }
        room.pcStateManager = stateManager;
        room.pcCopyKeyFieldsFromObjectId(object);
        return room;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Room room = new Room();
        if (bl) {
            room.pcClearFields();
        }
        room.pcStateManager = stateManager;
        return room;
    }

    protected static int pcGetManagedFieldCount() {
        return 29 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowRecording = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.allowUserQuestions = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.appointment = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.audioOnly = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.capacity = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.chatModerated = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.chatOpened = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.closed = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.comment = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.confno = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.demoRoom = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.demoTime = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.externalType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.files = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.filesOpened = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.groups = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.hiddenElements = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.ispublic = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.moderated = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.moderators = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.ownerId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.pin = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.redirectURL = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.sipEnabled = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.type = (Type)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 28: {
                this.waitForRecording = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowRecording);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowUserQuestions);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.appointment);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.audioOnly);
                return;
            }
            case 4: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.capacity);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.chatModerated);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.chatOpened);
                return;
            }
            case 7: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.closed);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.comment);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.confno);
                return;
            }
            case 10: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.demoRoom);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.demoTime);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalType);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.files);
                return;
            }
            case 15: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.filesOpened);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.groups);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.hiddenElements);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 19: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.ispublic);
                return;
            }
            case 20: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.moderated);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.moderators);
                return;
            }
            case 22: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ownerId);
                return;
            }
            case 24: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pin);
                return;
            }
            case 25: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.redirectURL);
                return;
            }
            case 26: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.sipEnabled);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 28: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.waitForRecording);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Room room, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(room, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowRecording = room.allowRecording;
                return;
            }
            case 1: {
                this.allowUserQuestions = room.allowUserQuestions;
                return;
            }
            case 2: {
                this.appointment = room.appointment;
                return;
            }
            case 3: {
                this.audioOnly = room.audioOnly;
                return;
            }
            case 4: {
                this.capacity = room.capacity;
                return;
            }
            case 5: {
                this.chatModerated = room.chatModerated;
                return;
            }
            case 6: {
                this.chatOpened = room.chatOpened;
                return;
            }
            case 7: {
                this.closed = room.closed;
                return;
            }
            case 8: {
                this.comment = room.comment;
                return;
            }
            case 9: {
                this.confno = room.confno;
                return;
            }
            case 10: {
                this.demoRoom = room.demoRoom;
                return;
            }
            case 11: {
                this.demoTime = room.demoTime;
                return;
            }
            case 12: {
                this.externalId = room.externalId;
                return;
            }
            case 13: {
                this.externalType = room.externalType;
                return;
            }
            case 14: {
                this.files = room.files;
                return;
            }
            case 15: {
                this.filesOpened = room.filesOpened;
                return;
            }
            case 16: {
                this.groups = room.groups;
                return;
            }
            case 17: {
                this.hiddenElements = room.hiddenElements;
                return;
            }
            case 18: {
                this.id = room.id;
                return;
            }
            case 19: {
                this.ispublic = room.ispublic;
                return;
            }
            case 20: {
                this.moderated = room.moderated;
                return;
            }
            case 21: {
                this.moderators = room.moderators;
                return;
            }
            case 22: {
                this.name = room.name;
                return;
            }
            case 23: {
                this.ownerId = room.ownerId;
                return;
            }
            case 24: {
                this.pin = room.pin;
                return;
            }
            case 25: {
                this.redirectURL = room.redirectURL;
                return;
            }
            case 26: {
                this.sipEnabled = room.sipEnabled;
                return;
            }
            case 27: {
                this.type = room.type;
                return;
            }
            case 28: {
                this.waitForRecording = room.waitForRecording;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Room room = (Room)object;
        if (room.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(room, nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(18 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        return new LongId(clazz, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$room$Room != null ? class$Lorg$apache$openmeetings$db$entity$room$Room : (class$Lorg$apache$openmeetings$db$entity$room$Room = Room.class$("org.apache.openmeetings.db.entity.room.Room"));
        return new LongId(clazz, this.id);
    }

    private static final boolean pcGetallowRecording(Room room) {
        if (room.pcStateManager == null) {
            return room.allowRecording;
        }
        int n = pcInheritedFieldCount + 0;
        room.pcStateManager.accessingField(n);
        return room.allowRecording;
    }

    private static final void pcSetallowRecording(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.allowRecording = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 0, room.allowRecording, bl, 0);
    }

    private static final boolean pcGetallowUserQuestions(Room room) {
        if (room.pcStateManager == null) {
            return room.allowUserQuestions;
        }
        int n = pcInheritedFieldCount + 1;
        room.pcStateManager.accessingField(n);
        return room.allowUserQuestions;
    }

    private static final void pcSetallowUserQuestions(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.allowUserQuestions = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 1, room.allowUserQuestions, bl, 0);
    }

    private static final boolean pcGetappointment(Room room) {
        if (room.pcStateManager == null) {
            return room.appointment;
        }
        int n = pcInheritedFieldCount + 2;
        room.pcStateManager.accessingField(n);
        return room.appointment;
    }

    private static final void pcSetappointment(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.appointment = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 2, room.appointment, bl, 0);
    }

    private static final boolean pcGetaudioOnly(Room room) {
        if (room.pcStateManager == null) {
            return room.audioOnly;
        }
        int n = pcInheritedFieldCount + 3;
        room.pcStateManager.accessingField(n);
        return room.audioOnly;
    }

    private static final void pcSetaudioOnly(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.audioOnly = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 3, room.audioOnly, bl, 0);
    }

    private static final long pcGetcapacity(Room room) {
        if (room.pcStateManager == null) {
            return room.capacity;
        }
        int n = pcInheritedFieldCount + 4;
        room.pcStateManager.accessingField(n);
        return room.capacity;
    }

    private static final void pcSetcapacity(Room room, long l) {
        if (room.pcStateManager == null) {
            room.capacity = l;
            return;
        }
        room.pcStateManager.settingLongField((PersistenceCapable)room, pcInheritedFieldCount + 4, room.capacity, l, 0);
    }

    private static final boolean pcGetchatModerated(Room room) {
        if (room.pcStateManager == null) {
            return room.chatModerated;
        }
        int n = pcInheritedFieldCount + 5;
        room.pcStateManager.accessingField(n);
        return room.chatModerated;
    }

    private static final void pcSetchatModerated(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.chatModerated = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 5, room.chatModerated, bl, 0);
    }

    private static final boolean pcGetchatOpened(Room room) {
        if (room.pcStateManager == null) {
            return room.chatOpened;
        }
        int n = pcInheritedFieldCount + 6;
        room.pcStateManager.accessingField(n);
        return room.chatOpened;
    }

    private static final void pcSetchatOpened(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.chatOpened = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 6, room.chatOpened, bl, 0);
    }

    private static final boolean pcGetclosed(Room room) {
        if (room.pcStateManager == null) {
            return room.closed;
        }
        int n = pcInheritedFieldCount + 7;
        room.pcStateManager.accessingField(n);
        return room.closed;
    }

    private static final void pcSetclosed(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.closed = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 7, room.closed, bl, 0);
    }

    private static final String pcGetcomment(Room room) {
        if (room.pcStateManager == null) {
            return room.comment;
        }
        int n = pcInheritedFieldCount + 8;
        room.pcStateManager.accessingField(n);
        return room.comment;
    }

    private static final void pcSetcomment(Room room, String string) {
        if (room.pcStateManager == null) {
            room.comment = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 8, room.comment, string, 0);
    }

    private static final String pcGetconfno(Room room) {
        if (room.pcStateManager == null) {
            return room.confno;
        }
        int n = pcInheritedFieldCount + 9;
        room.pcStateManager.accessingField(n);
        return room.confno;
    }

    private static final void pcSetconfno(Room room, String string) {
        if (room.pcStateManager == null) {
            room.confno = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 9, room.confno, string, 0);
    }

    private static final boolean pcGetdemoRoom(Room room) {
        if (room.pcStateManager == null) {
            return room.demoRoom;
        }
        int n = pcInheritedFieldCount + 10;
        room.pcStateManager.accessingField(n);
        return room.demoRoom;
    }

    private static final void pcSetdemoRoom(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.demoRoom = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 10, room.demoRoom, bl, 0);
    }

    private static final Integer pcGetdemoTime(Room room) {
        if (room.pcStateManager == null) {
            return room.demoTime;
        }
        int n = pcInheritedFieldCount + 11;
        room.pcStateManager.accessingField(n);
        return room.demoTime;
    }

    private static final void pcSetdemoTime(Room room, Integer n) {
        if (room.pcStateManager == null) {
            room.demoTime = n;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 11, (Object)room.demoTime, (Object)n, 0);
    }

    private static final String pcGetexternalId(Room room) {
        if (room.pcStateManager == null) {
            return room.externalId;
        }
        int n = pcInheritedFieldCount + 12;
        room.pcStateManager.accessingField(n);
        return room.externalId;
    }

    private static final void pcSetexternalId(Room room, String string) {
        if (room.pcStateManager == null) {
            room.externalId = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 12, room.externalId, string, 0);
    }

    private static final String pcGetexternalType(Room room) {
        if (room.pcStateManager == null) {
            return room.externalType;
        }
        int n = pcInheritedFieldCount + 13;
        room.pcStateManager.accessingField(n);
        return room.externalType;
    }

    private static final void pcSetexternalType(Room room, String string) {
        if (room.pcStateManager == null) {
            room.externalType = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 13, room.externalType, string, 0);
    }

    private static final List pcGetfiles(Room room) {
        if (room.pcStateManager == null) {
            return room.files;
        }
        int n = pcInheritedFieldCount + 14;
        room.pcStateManager.accessingField(n);
        return room.files;
    }

    private static final void pcSetfiles(Room room, List list) {
        if (room.pcStateManager == null) {
            room.files = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 14, room.files, (Object)list, 0);
    }

    private static final boolean pcGetfilesOpened(Room room) {
        if (room.pcStateManager == null) {
            return room.filesOpened;
        }
        int n = pcInheritedFieldCount + 15;
        room.pcStateManager.accessingField(n);
        return room.filesOpened;
    }

    private static final void pcSetfilesOpened(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.filesOpened = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 15, room.filesOpened, bl, 0);
    }

    private static final List pcGetgroups(Room room) {
        if (room.pcStateManager == null) {
            return room.groups;
        }
        int n = pcInheritedFieldCount + 16;
        room.pcStateManager.accessingField(n);
        return room.groups;
    }

    private static final void pcSetgroups(Room room, List list) {
        if (room.pcStateManager == null) {
            room.groups = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 16, room.groups, (Object)list, 0);
    }

    private static final Set pcGethiddenElements(Room room) {
        if (room.pcStateManager == null) {
            return room.hiddenElements;
        }
        int n = pcInheritedFieldCount + 17;
        room.pcStateManager.accessingField(n);
        return room.hiddenElements;
    }

    private static final void pcSethiddenElements(Room room, Set set) {
        if (room.pcStateManager == null) {
            room.hiddenElements = set;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 17, room.hiddenElements, (Object)set, 0);
    }

    private static final Long pcGetid(Room room) {
        if (room.pcStateManager == null) {
            return room.id;
        }
        int n = pcInheritedFieldCount + 18;
        room.pcStateManager.accessingField(n);
        return room.id;
    }

    private static final void pcSetid(Room room, Long l) {
        if (room.pcStateManager == null) {
            room.id = l;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 18, (Object)room.id, (Object)l, 0);
    }

    private static final boolean pcGetispublic(Room room) {
        if (room.pcStateManager == null) {
            return room.ispublic;
        }
        int n = pcInheritedFieldCount + 19;
        room.pcStateManager.accessingField(n);
        return room.ispublic;
    }

    private static final void pcSetispublic(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.ispublic = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 19, room.ispublic, bl, 0);
    }

    private static final boolean pcGetmoderated(Room room) {
        if (room.pcStateManager == null) {
            return room.moderated;
        }
        int n = pcInheritedFieldCount + 20;
        room.pcStateManager.accessingField(n);
        return room.moderated;
    }

    private static final void pcSetmoderated(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.moderated = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 20, room.moderated, bl, 0);
    }

    private static final List pcGetmoderators(Room room) {
        if (room.pcStateManager == null) {
            return room.moderators;
        }
        int n = pcInheritedFieldCount + 21;
        room.pcStateManager.accessingField(n);
        return room.moderators;
    }

    private static final void pcSetmoderators(Room room, List list) {
        if (room.pcStateManager == null) {
            room.moderators = list;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 21, room.moderators, (Object)list, 0);
    }

    private static final String pcGetname(Room room) {
        if (room.pcStateManager == null) {
            return room.name;
        }
        int n = pcInheritedFieldCount + 22;
        room.pcStateManager.accessingField(n);
        return room.name;
    }

    private static final void pcSetname(Room room, String string) {
        if (room.pcStateManager == null) {
            room.name = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 22, room.name, string, 0);
    }

    private static final Long pcGetownerId(Room room) {
        if (room.pcStateManager == null) {
            return room.ownerId;
        }
        int n = pcInheritedFieldCount + 23;
        room.pcStateManager.accessingField(n);
        return room.ownerId;
    }

    private static final void pcSetownerId(Room room, Long l) {
        if (room.pcStateManager == null) {
            room.ownerId = l;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 23, (Object)room.ownerId, (Object)l, 0);
    }

    private static final String pcGetpin(Room room) {
        if (room.pcStateManager == null) {
            return room.pin;
        }
        int n = pcInheritedFieldCount + 24;
        room.pcStateManager.accessingField(n);
        return room.pin;
    }

    private static final void pcSetpin(Room room, String string) {
        if (room.pcStateManager == null) {
            room.pin = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 24, room.pin, string, 0);
    }

    private static final String pcGetredirectURL(Room room) {
        if (room.pcStateManager == null) {
            return room.redirectURL;
        }
        int n = pcInheritedFieldCount + 25;
        room.pcStateManager.accessingField(n);
        return room.redirectURL;
    }

    private static final void pcSetredirectURL(Room room, String string) {
        if (room.pcStateManager == null) {
            room.redirectURL = string;
            return;
        }
        room.pcStateManager.settingStringField((PersistenceCapable)room, pcInheritedFieldCount + 25, room.redirectURL, string, 0);
    }

    private static final boolean pcGetsipEnabled(Room room) {
        if (room.pcStateManager == null) {
            return room.sipEnabled;
        }
        int n = pcInheritedFieldCount + 26;
        room.pcStateManager.accessingField(n);
        return room.sipEnabled;
    }

    private static final void pcSetsipEnabled(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.sipEnabled = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 26, room.sipEnabled, bl, 0);
    }

    private static final Type pcGettype(Room room) {
        if (room.pcStateManager == null) {
            return room.type;
        }
        int n = pcInheritedFieldCount + 27;
        room.pcStateManager.accessingField(n);
        return room.type;
    }

    private static final void pcSettype(Room room, Type type) {
        if (room.pcStateManager == null) {
            room.type = type;
            return;
        }
        room.pcStateManager.settingObjectField((PersistenceCapable)room, pcInheritedFieldCount + 27, (Object)room.type, (Object)type, 0);
    }

    private static final boolean pcGetwaitForRecording(Room room) {
        if (room.pcStateManager == null) {
            return room.waitForRecording;
        }
        int n = pcInheritedFieldCount + 28;
        room.pcStateManager.accessingField(n);
        return room.waitForRecording;
    }

    private static final void pcSetwaitForRecording(Room room, boolean bl) {
        if (room.pcStateManager == null) {
            room.waitForRecording = bl;
            return;
        }
        room.pcStateManager.settingBooleanField((PersistenceCapable)room, pcInheritedFieldCount + 28, room.waitForRecording, bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.room.type")
    public static enum Type {
        conference(1),
        presentation(3),
        interview(4);

        private int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Type get(Long type) {
            return Type.get(type == null ? 1 : type.intValue());
        }

        public static Type get(Integer type) {
            return Type.get(type == null ? 1 : type);
        }

        public static Type get(int type) {
            Type rt = conference;
            switch (type) {
                case 3: {
                    rt = presentation;
                    break;
                }
                case 4: {
                    rt = interview;
                    break;
                }
            }
            return rt;
        }
    }

    @XmlType(namespace="org.apache.openmeetings.room.element")
    public static enum RoomElement {
        TopBar,
        Chat,
        Activities,
        Files,
        ActionMenu,
        PollMenu,
        ScreenSharing,
        Whiteboard,
        MicrophoneStatus,
        UserCount;

    }

    @XmlType(namespace="org.apache.openmeetings.room.right")
    public static enum Right {
        superModerator,
        moderator,
        presenter,
        whiteBoard,
        share,
        remoteControl,
        audio,
        video,
        muteOthers;

    }
}

