/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.string.Strings;

public class DaoHelper {
    public static final UnsupportedOperationException UNSUPPORTED = new UnsupportedOperationException("Should not be used");

    private DaoHelper() {
    }

    public static String getSearchQuery(String table, String alias, String search, boolean filterDeleted, boolean count, String sort, String ... fields) {
        return DaoHelper.getSearchQuery(table, alias, search, false, filterDeleted, count, sort, fields);
    }

    public static String getSearchQuery(String table, String alias, String search, boolean distinct, boolean filterDeleted, boolean count, String sort, String ... fields) {
        return DaoHelper.getSearchQuery(table, alias, null, search, distinct, filterDeleted, count, null, sort, fields);
    }

    public static String getSearchQuery(String table, String alias, String join, String search, boolean filterDeleted, boolean count, String additionalWhere, String sort, String ... fields) {
        return DaoHelper.getSearchQuery(table, alias, join, search, false, filterDeleted, count, additionalWhere, sort, fields);
    }

    public static String getSearchQuery(String table, String alias, String join, String search, boolean distinct, boolean filterDeleted, boolean count, String additionalWhere, String sort, String ... fields) {
        StringBuilder sb = new StringBuilder("SELECT ");
        if (count) {
            sb.append("COUNT(");
        }
        if (distinct) {
            sb.append("DISTINCT ");
        }
        sb.append(alias);
        if (count) {
            sb.append(")");
        }
        sb.append(" FROM ").append(table).append(" ").append(alias);
        if (!Strings.isEmpty((CharSequence)join)) {
            sb.append(" ").append(join);
        }
        sb.append(" WHERE 1 = 1 ");
        if (filterDeleted) {
            sb.append("AND ").append(alias).append(".deleted = false ");
        }
        DaoHelper.appendWhereClause(sb, search, alias, fields);
        if (!Strings.isEmpty((CharSequence)additionalWhere)) {
            sb.append("AND ").append(additionalWhere);
        }
        return DaoHelper.appendSort(sb, alias, sort).toString();
    }

    public static StringBuilder appendWhereClause(StringBuilder _sb, String search, String alias, String ... fields) {
        if (!Strings.isEmpty((CharSequence)search) && fields != null) {
            boolean notEmpty = false;
            StringBuilder sb = new StringBuilder();
            String[] searchItems = search.replace("'", "").replace("\"", "").split(" ");
            for (int i = 0; i < searchItems.length; ++i) {
                if (searchItems[i].isEmpty()) continue;
                if (i == 0) {
                    notEmpty = true;
                    sb.append(" (");
                } else {
                    sb.append(" OR ");
                }
                StringBuilder placeholder = new StringBuilder();
                placeholder.append("%").append(StringUtils.lowerCase((String)searchItems[i])).append("%");
                sb.append("(");
                for (int j = 0; j < fields.length; ++j) {
                    if (j != 0) {
                        sb.append(" OR ");
                    }
                    sb.append("lower(").append(alias).append(".").append(fields[j]).append(") LIKE '").append((CharSequence)placeholder).append("' ");
                }
                sb.append(")");
            }
            if (notEmpty) {
                sb.append(") ");
                _sb.append(" AND").append((CharSequence)sb);
            }
        }
        return _sb;
    }

    public static StringBuilder appendSort(StringBuilder sb, String alias, String sort) {
        if (!Strings.isEmpty((CharSequence)sort)) {
            sb.append(" ORDER BY ").append(alias).append(".").append(sort);
        }
        return sb;
    }

    public static String getStringParam(String param) {
        return param == null ? "%" : "%" + StringUtils.lowerCase((String)param) + "%";
    }

    public static <T> TypedQuery<T> setLimits(TypedQuery<T> q, Long first, Long max) {
        if (first != null) {
            q.setFirstResult(first.intValue());
        }
        if (max != null) {
            q.setMaxResults(max.intValue());
        }
        return q;
    }
}

