/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.file.BaseFileItemDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.record.RecordingContainerData;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class RecordingDao
extends BaseFileItemDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @Autowired
    private UserDao userDao;

    @Override
    public Recording get(Long id) {
        BaseFileItem bf = super.get(id);
        return bf instanceof Recording ? (Recording)bf : null;
    }

    public Recording getByHash(String hash) {
        BaseFileItem bf = super.get(hash);
        return bf instanceof Recording ? (Recording)bf : null;
    }

    public List<Recording> getByExternalId(String externalId, String externalType) {
        try {
            log.debug("getFByExternalId :externalId: {}; externalType: {}", (Object)externalId, (Object)externalType);
            TypedQuery query = this.em.createNamedQuery("getRecordingsByExternalUser", Recording.class);
            query.setParameter("externalId", (Object)externalId);
            query.setParameter("externalType", (Object)externalType);
            List recordingList = query.getResultList();
            log.debug("getByExternalId :: " + recordingList.size());
            return recordingList;
        }
        catch (Exception ex2) {
            log.error("[getByExternalId]: ", (Throwable)ex2);
            return new ArrayList<Recording>();
        }
    }

    public List<Recording> get() {
        return this.em.createNamedQuery("getRecordingsAll", Recording.class).getResultList();
    }

    public List<Recording> getByExternalType(String externalType) {
        log.debug("getByExternalType :externalType: " + externalType);
        TypedQuery query = this.em.createNamedQuery("getRecordingsByExternalType", Recording.class);
        query.setParameter("externalType", (Object)externalType);
        return query.getResultList();
    }

    public List<Recording> getRootByPublic(Long groupId) {
        TypedQuery q = this.em.createNamedQuery(groupId == null ? "getRecordingsPublic" : "getRecordingsByGroup", Recording.class);
        if (groupId != null) {
            q.setParameter("groupId", (Object)groupId);
        }
        return q.getResultList();
    }

    public List<Recording> getRootByOwner(Long ownerId) {
        return this.em.createNamedQuery("getRecordingsByOwner", Recording.class).setParameter("ownerId", (Object)ownerId).getResultList();
    }

    public List<Recording> getByRoomId(Long roomId) {
        return this.em.createNamedQuery("getRecordingsByRoom", Recording.class).setParameter("roomId", (Object)roomId).getResultList();
    }

    public List<Recording> getExpiring(Long groupId, int reminderDays, boolean notified) {
        Instant date = Instant.now().minus(Duration.ofDays(reminderDays));
        return this.em.createNamedQuery("getExpiringRecordings", Recording.class).setParameter("groupId", (Object)groupId).setParameter("date", (Object)Date.from(date)).setParameter("notified", (Object)notified).getResultList();
    }

    public List<Recording> getByParent(Long parentId) {
        return this.em.createNamedQuery("getRecordingsByParent", Recording.class).setParameter("parentId", (Object)parentId).getResultList();
    }

    public void updateEndTime(Long recordingId, Date recordEnd) {
        try {
            Recording fId = this.get(recordingId);
            fId.setRecordEnd(recordEnd);
            this.update(fId);
        }
        catch (Exception ex2) {
            log.error("[updateEndTime]: ", (Throwable)ex2);
        }
    }

    public Recording update(Recording f) {
        return (Recording)this._update(f);
    }

    public void resetProcessingStatus() {
        this.em.createNamedQuery("resetRecordingProcessingStatus").setParameter("error", (Object)Recording.Status.ERROR).setParameter("recording", (Object)Recording.Status.RECORDING).setParameter("converting", (Object)Recording.Status.CONVERTING).executeUpdate();
    }

    public RecordingContainerData getContainerData(long userId) {
        try {
            RecordingContainerData containerData = new RecordingContainerData();
            List<Recording> homes = this.getRootByOwner(userId);
            long homeFileSize = 0L;
            for (Recording home : homes) {
                homeFileSize += this.getSize(home);
            }
            containerData.setUserHomeSize(homeFileSize);
            long publicFileSize = 0L;
            for (GroupUser ou : this.userDao.get(userId).getGroupUsers()) {
                List<Recording> publicRecordings = this.getRootByPublic(ou.getGroup().getId());
                for (Recording r : publicRecordings) {
                    publicFileSize += this.getSize(r);
                }
            }
            containerData.setPublicFileSize(publicFileSize);
            return containerData;
        }
        catch (Exception ex2) {
            log.error("[getRecordingContainerData]: ", (Throwable)ex2);
            return null;
        }
    }

    private long getSize(Recording r) {
        long size = 0L;
        if (r.exists("png")) {
            size += r.getFile("png").length();
        }
        if (r.exists("mp4")) {
            size += r.getFile("mp4").length();
        }
        for (Recording rec : this.getByParent(r.getId())) {
            size += this.getSize(rec);
        }
        return size;
    }
}

