/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.record.RecordingMetaData;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class RecordingMetaDataDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingMetaDataDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private RecordingDao recordingDao;

    public RecordingMetaData get(Long id) {
        List list = this.em.createNamedQuery("getMetaById", RecordingMetaData.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (RecordingMetaData)list.get(0) : null;
    }

    public List<RecordingMetaData> getByRecording(Long recordingId) {
        return this.em.createNamedQuery("getMetaByRecording", RecordingMetaData.class).setParameter("recordingId", (Object)recordingId).getResultList();
    }

    public List<RecordingMetaData> getAudioMetaDataByRecording(Long recordingId) {
        return this.em.createNamedQuery("getAudioMetaByRecording", RecordingMetaData.class).setParameter("recordingId", (Object)recordingId).setParameter("none", (Object)RecordingMetaData.Status.NONE).getResultList();
    }

    public RecordingMetaData getScreenByRecording(Long recordingId) {
        List list = this.em.createNamedQuery("getScreenMetaByRecording", RecordingMetaData.class).setParameter("recordingId", (Object)recordingId).getResultList();
        return list.isEmpty() ? null : (RecordingMetaData)list.get(0);
    }

    public Long add(Long recordingId, Date recordStart, boolean isAudioOnly, boolean isVideoOnly, boolean isScreenData, String streamName, String sid) {
        try {
            RecordingMetaData metaData = new RecordingMetaData();
            metaData.setRecording(this.recordingDao.get(recordingId));
            metaData.setRecordStart(recordStart);
            metaData.setAudioOnly(isAudioOnly);
            metaData.setVideoOnly(isVideoOnly);
            metaData.setScreenData(isScreenData);
            metaData.setStreamName(streamName);
            metaData.setSid(sid);
            metaData = this.update(metaData);
            return metaData.getId();
        }
        catch (Exception ex2) {
            log.error("[add]: ", (Throwable)ex2);
            return null;
        }
    }

    public Long updateEndDate(Long metaId, Date recordEnd) {
        try {
            RecordingMetaData meta = this.get(metaId);
            if (meta != null) {
                meta.setRecordEnd(recordEnd);
                log.debug("updateEndDate :: Start Date : {}", (Object)meta.getRecordStart());
                log.debug("updateEndDate :: End Date : {}", (Object)meta.getRecordEnd());
                this.update(meta);
            }
            return metaId;
        }
        catch (Exception ex2) {
            log.error("[updateEndDate]: ", (Throwable)ex2);
            return null;
        }
    }

    public RecordingMetaData update(RecordingMetaData metaData) {
        log.debug("[update]: ");
        if (metaData.getId() == null) {
            metaData.setInserted(new Date());
            this.em.persist((Object)metaData);
        } else {
            metaData.setUpdated(new Date());
            metaData = (RecordingMetaData)this.em.merge((Object)metaData);
        }
        return metaData;
    }
}

