/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util.ws;

import java.util.Date;
import java.util.UUID;
import org.apache.openmeetings.db.entity.basic.IClient;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;

public class RoomMessage
implements IWebSocketPushMessage {
    private static final long serialVersionUID = 1L;
    private final Date timestamp = new Date();
    private final String uid;
    private final Long roomId;
    private final Long userId;
    private final String name;
    private final Type type;

    public RoomMessage(Long roomId, IClient c, Type type) {
        this(roomId, c.getUserId(), c.getFirstname(), c.getLastname(), type);
    }

    public RoomMessage(Long roomId, User u, Type type) {
        this(roomId, u.getId(), u.getFirstname(), u.getLastname(), type);
    }

    private RoomMessage(Long roomId, Long userId, String firstName, String lastName, Type type) {
        this.roomId = roomId;
        this.name = OmFileHelper.SIP_USER_ID.equals(userId) ? "SIP Transport" : String.format("%s %s", firstName, lastName);
        this.userId = userId;
        this.type = type;
        this.uid = UUID.randomUUID().toString();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getUid() {
        return this.uid;
    }

    public static enum Type {
        roomEnter,
        roomExit,
        roomClosed,
        pollCreated,
        pollUpdated,
        recordingStarted,
        recordingStoped,
        sharingStarted,
        sharingStoped,
        rightUpdated,
        activityRemove,
        requestRightModerator,
        requestRightPresenter,
        requestRightWb,
        requestRightShare,
        requestRightRemote,
        requestRightA,
        requestRightAv,
        requestRightExclusive,
        haveQuestion,
        kick,
        newStream,
        closeStream,
        mute,
        exclusive,
        quickPollUpdated;

    }
}

