/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.UserContact;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UserContactDao {
    private static final Logger log = Red5LoggerFactory.getLogger(UserContactDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    public UserContact add(Long userId, Long ownerId, boolean pending) {
        try {
            UserContact userContact = new UserContact();
            userContact.setInserted(new Date());
            userContact.setOwner(this.userDao.get(ownerId));
            userContact.setContact(this.userDao.get(userId));
            userContact.setPending(pending);
            userContact = this.update(userContact);
            return userContact;
        }
        catch (Exception e) {
            log.error("[addUserContact]", (Throwable)e);
            return null;
        }
    }

    public void delete(Long id) {
        this.em.createNamedQuery("deleteUserContact").setParameter("id", (Object)id).executeUpdate();
    }

    public Integer deleteAllUserContacts(Long ownerId) {
        return this.em.createNamedQuery("deleteAllUserContacts").setParameter("ownerId", (Object)ownerId).executeUpdate();
    }

    public UserContact get(Long userId, Long ownerId) {
        List ll = this.em.createNamedQuery("getContactByUserOwner", UserContact.class).setParameter("userId", (Object)userId).setParameter("ownerId", (Object)ownerId).getResultList();
        log.info("number of contacts:: " + (ll == null ? null : Integer.valueOf(ll.size())));
        return ll != null && ll.size() == 1 ? (UserContact)ll.get(0) : null;
    }

    public boolean isContact(Long userId, Long ownerId) {
        UserContact c = this.get(userId, ownerId);
        return c == null ? false : !c.isPending();
    }

    public List<UserContact> get(long ownerId, int first, int count) {
        TypedQuery q = this.em.createNamedQuery("getContactsByUser", UserContact.class);
        q.setParameter("userId", (Object)ownerId);
        q.setFirstResult(first);
        q.setMaxResults(count);
        return q.getResultList();
    }

    public long count(long ownerId) {
        TypedQuery q = this.em.createNamedQuery("countContactsByUser", Long.class);
        q.setParameter("userId", (Object)ownerId);
        return (Long)q.getSingleResult();
    }

    public List<UserContact> getContactsByUserAndStatus(Long ownerId, boolean pending) {
        return this.em.createNamedQuery("getContactsByUserAndStatus", UserContact.class).setParameter("ownerId", (Object)ownerId).setParameter("pending", (Object)pending).getResultList();
    }

    public List<UserContact> getContactRequestsByUserAndStatus(Long userId, boolean pending) {
        return this.em.createNamedQuery("getContactRequestsByUserAndStatus", UserContact.class).setParameter("userId", (Object)userId).setParameter("pending", (Object)pending).getResultList();
    }

    public UserContact get(Long id) {
        List list = this.em.createNamedQuery("getUserContactsById", UserContact.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (UserContact)list.get(0) : null;
    }

    public List<UserContact> get() {
        return this.em.createNamedQuery("getUserContacts", UserContact.class).getResultList();
    }

    public Long updateContactStatus(Long id, boolean pending) {
        try {
            UserContact uc = this.get(id);
            uc.setPending(pending);
            this.update(uc);
            return id;
        }
        catch (Exception e) {
            log.error("[updateContactStatus]", (Throwable)e);
            return null;
        }
    }

    public UserContact update(UserContact c) {
        if (c.getId() == null) {
            c.setInserted(new Date());
            this.em.persist((Object)c);
        } else {
            c.setUpdated(new Date());
            c = (UserContact)this.em.merge((Object)c);
        }
        return c;
    }
}

