/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.record;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.RecordingMetaData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Entity
@NamedQueries(value={@NamedQuery(name="getRecordingsByExternalUser", query="SELECT c FROM Recording c, User u WHERE c.insertedBy = u.id AND u.externalId = :externalId  AND u.externalType = :externalType AND c.deleted = false"), @NamedQuery(name="getRecordingsPublic", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId IS NULL AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type ASC, f.inserted"), @NamedQuery(name="getRecordingsByGroup", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId = :groupId AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type ASC, f.inserted"), @NamedQuery(name="getRecordingsByOwner", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId = :ownerId AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type ASC, f.inserted"), @NamedQuery(name="resetRecordingProcessingStatus", query="UPDATE Recording f SET f.status = :error WHERE f.status IN (:recording, :converting)"), @NamedQuery(name="getRecordingsAll", query="SELECT c FROM Recording c LEFT JOIN FETCH c.metaData ORDER BY c.id"), @NamedQuery(name="getRecordingsByRoom", query="SELECT c FROM Recording c WHERE c.deleted = false AND c.roomId = :roomId ORDER BY c.type ASC, c.inserted"), @NamedQuery(name="getRecordingsByParent", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.parentId = :parentId ORDER BY f.type ASC, f.inserted"), @NamedQuery(name="getRecordingsByExternalType", query="SELECT rec FROM Recording rec, Room r, User u WHERE rec.deleted = false AND rec.roomId = r.id AND rec.insertedBy = u.id AND (r.externalType = :externalType OR u.externalType = :externalType)"), @NamedQuery(name="getExpiringRecordings", query="SELECT DISTINCT rec FROM Recording rec WHERE rec.deleted = false AND rec.notified = :notified AND rec.inserted < :date   AND (rec.groupId = :groupId     OR rec.ownerId IN (SELECT gu.user.id FROM GroupUser gu WHERE gu.group.id = :groupId)    OR rec.roomId IN (SELECT rg.room.id FROM RoomGroup rg WHERE rg.group.id = :groupId)  ) order by rec.inserted ASC")})
@Root(name="flvrecording")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Recording
extends BaseFileItem
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(name="comment")
    @Element(data=true, required=false)
    private String comment;
    @Column(name="record_start")
    @Element(data=true, required=false)
    private Date recordStart;
    @Column(name="record_end")
    @Element(data=true, required=false)
    private Date recordEnd;
    @Column(name="duration")
    @Element(data=true, required=false)
    private String duration;
    @Column(name="recorder_stream_id")
    @Element(data=true, required=false)
    private String recorderStreamId;
    @Column(name="is_interview")
    @Element(data=true, required=false)
    private Boolean interview = false;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="recording_id")
    @ElementList(name="flvrecordingmetadatas", required=false)
    private List<RecordingMetaData> metaData;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    @Element(data=true, required=false)
    private Status status = Status.NONE;
    @Column(name="notified")
    @Element(data=true, required=false)
    private Boolean notified = false;
    private static int pcInheritedFieldCount = BaseFileItem.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$file$BaseFileItem;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$record$Recording$Status;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$record$Recording;

    @Override
    @Element(data=true, name="flvRecordingId")
    public Long getId() {
        return super.getId();
    }

    @Override
    @Element(data=true, name="flvRecordingId")
    public void setId(Long id) {
        super.setId(id);
    }

    public String getComment() {
        return Recording.pcGetcomment(this);
    }

    public void setComment(String comment) {
        Recording.pcSetcomment(this, comment);
    }

    public String getDuration() {
        return Recording.pcGetduration(this);
    }

    public void setDuration(String duration) {
        Recording.pcSetduration(this, duration);
    }

    public Date getRecordStart() {
        return Recording.pcGetrecordStart(this);
    }

    public void setRecordStart(Date recordStart) {
        Recording.pcSetrecordStart(this, recordStart);
    }

    public Date getRecordEnd() {
        return Recording.pcGetrecordEnd(this);
    }

    public void setRecordEnd(Date recordEnd) {
        Recording.pcSetrecordEnd(this, recordEnd);
    }

    public String getRecorderStreamId() {
        return Recording.pcGetrecorderStreamId(this);
    }

    public void setRecorderStreamId(String recorderStreamId) {
        Recording.pcSetrecorderStreamId(this, recorderStreamId);
    }

    public List<RecordingMetaData> getMetaData() {
        return Recording.pcGetmetaData(this);
    }

    public void setMetaData(List<RecordingMetaData> metaData) {
        Recording.pcSetmetaData(this, metaData);
    }

    public boolean isInterview() {
        return Boolean.TRUE.equals(Recording.pcGetinterview(this));
    }

    public void setInterview(boolean interview) {
        Recording.pcSetinterview(this, interview);
    }

    public Status getStatus() {
        return Recording.pcGetstatus(this);
    }

    public void setStatus(Status status) {
        Recording.pcSetstatus(this, status);
    }

    public boolean isNotified() {
        return Boolean.TRUE.equals(Recording.pcGetnotified(this));
    }

    public void setNotified(boolean notified) {
        Recording.pcSetnotified(this, notified);
    }

    @Override
    public String getFileName(String ext) {
        return String.format("%s%s.%s", "flvRecording_", this.getId(), ext == null ? "mp4" : ext);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1759663;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$file$BaseFileItem != null ? class$Lorg$apache$openmeetings$db$entity$file$BaseFileItem : (class$Lorg$apache$openmeetings$db$entity$file$BaseFileItem = Recording.class$("org.apache.openmeetings.db.entity.file.BaseFileItem"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"comment", "duration", "interview", "metaData", "notified", "recordEnd", "recordStart", "recorderStreamId", "status"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Recording.class$("java.lang.Boolean"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Recording.class$("java.util.List"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Recording.class$("java.lang.Boolean"));
        Class clazz5 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Recording.class$("java.util.Date"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Recording.class$("java.util.Date"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        Class clazz6 = class$Lorg$apache$openmeetings$db$entity$record$Recording$Status != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording$Status : (class$Lorg$apache$openmeetings$db$entity$record$Recording$Status = Recording.class$("org.apache.openmeetings.db.entity.record.Recording$Status"));
        classArray[8] = clazz6;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 5, 26, 26, 26, 26, 26};
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$record$Recording != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording : (class$Lorg$apache$openmeetings$db$entity$record$Recording = Recording.class$("org.apache.openmeetings.db.entity.record.Recording"));
        PCRegistry.register((Class)clazz7, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Recording", (PersistenceCapable)new Recording());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.comment = null;
        this.duration = null;
        this.interview = null;
        this.metaData = null;
        this.notified = null;
        this.recordEnd = null;
        this.recordStart = null;
        this.recorderStreamId = null;
        this.status = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Recording recording = new Recording();
        if (bl) {
            recording.pcClearFields();
        }
        recording.pcStateManager = stateManager;
        recording.pcCopyKeyFieldsFromObjectId(object);
        return recording;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Recording recording = new Recording();
        if (bl) {
            recording.pcClearFields();
        }
        recording.pcStateManager = stateManager;
        return recording;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + BaseFileItem.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.comment = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.duration = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.interview = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.metaData = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.notified = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.recordEnd = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.recordStart = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.recorderStreamId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.status = (Status)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.comment);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.duration);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.interview);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.metaData);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.notified);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.recordEnd);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.recordStart);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.recorderStreamId);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.status);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Recording recording, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(recording, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.comment = recording.comment;
                return;
            }
            case 1: {
                this.duration = recording.duration;
                return;
            }
            case 2: {
                this.interview = recording.interview;
                return;
            }
            case 3: {
                this.metaData = recording.metaData;
                return;
            }
            case 4: {
                this.notified = recording.notified;
                return;
            }
            case 5: {
                this.recordEnd = recording.recordEnd;
                return;
            }
            case 6: {
                this.recordStart = recording.recordStart;
                return;
            }
            case 7: {
                this.recorderStreamId = recording.recorderStreamId;
                return;
            }
            case 8: {
                this.status = recording.status;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Recording recording = (Recording)object;
        if (recording.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(recording, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetcomment(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.comment;
        }
        int n = pcInheritedFieldCount + 0;
        recording.pcStateManager.accessingField(n);
        return recording.comment;
    }

    private static final void pcSetcomment(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.comment = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 0, recording.comment, string, 0);
    }

    private static final String pcGetduration(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.duration;
        }
        int n = pcInheritedFieldCount + 1;
        recording.pcStateManager.accessingField(n);
        return recording.duration;
    }

    private static final void pcSetduration(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.duration = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 1, recording.duration, string, 0);
    }

    private static final Boolean pcGetinterview(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.interview;
        }
        int n = pcInheritedFieldCount + 2;
        recording.pcStateManager.accessingField(n);
        return recording.interview;
    }

    private static final void pcSetinterview(Recording recording, Boolean bl) {
        if (recording.pcStateManager == null) {
            recording.interview = bl;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 2, (Object)recording.interview, (Object)bl, 0);
    }

    private static final List pcGetmetaData(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.metaData;
        }
        int n = pcInheritedFieldCount + 3;
        recording.pcStateManager.accessingField(n);
        return recording.metaData;
    }

    private static final void pcSetmetaData(Recording recording, List list) {
        if (recording.pcStateManager == null) {
            recording.metaData = list;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 3, recording.metaData, (Object)list, 0);
    }

    private static final Boolean pcGetnotified(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.notified;
        }
        int n = pcInheritedFieldCount + 4;
        recording.pcStateManager.accessingField(n);
        return recording.notified;
    }

    private static final void pcSetnotified(Recording recording, Boolean bl) {
        if (recording.pcStateManager == null) {
            recording.notified = bl;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 4, (Object)recording.notified, (Object)bl, 0);
    }

    private static final Date pcGetrecordEnd(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recordEnd;
        }
        int n = pcInheritedFieldCount + 5;
        recording.pcStateManager.accessingField(n);
        return recording.recordEnd;
    }

    private static final void pcSetrecordEnd(Recording recording, Date date) {
        if (recording.pcStateManager == null) {
            recording.recordEnd = date;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 5, (Object)recording.recordEnd, (Object)date, 0);
    }

    private static final Date pcGetrecordStart(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recordStart;
        }
        int n = pcInheritedFieldCount + 6;
        recording.pcStateManager.accessingField(n);
        return recording.recordStart;
    }

    private static final void pcSetrecordStart(Recording recording, Date date) {
        if (recording.pcStateManager == null) {
            recording.recordStart = date;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 6, (Object)recording.recordStart, (Object)date, 0);
    }

    private static final String pcGetrecorderStreamId(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recorderStreamId;
        }
        int n = pcInheritedFieldCount + 7;
        recording.pcStateManager.accessingField(n);
        return recording.recorderStreamId;
    }

    private static final void pcSetrecorderStreamId(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.recorderStreamId = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 7, recording.recorderStreamId, string, 0);
    }

    private static final Status pcGetstatus(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.status;
        }
        int n = pcInheritedFieldCount + 8;
        recording.pcStateManager.accessingField(n);
        return recording.status;
    }

    private static final void pcSetstatus(Recording recording, Status status) {
        if (recording.pcStateManager == null) {
            recording.status = status;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 8, (Object)recording.status, (Object)status, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.record")
    public static enum Status {
        NONE,
        RECORDING,
        CONVERTING,
        PROCESSED,
        ERROR;

    }
}

