/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.server.SOAPLogin;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SOAPLoginDao {
    private static final Logger log = Red5LoggerFactory.getLogger(SOAPLoginDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;

    public String addSOAPLogin(String sessionHash, Long roomId, boolean becomemoderator, boolean showAudioVideoTest, boolean allowSameURLMultipleTimes, Long recordingId, boolean allowRecording) {
        SOAPLogin soapLogin = new SOAPLogin();
        soapLogin.setCreated(new Date());
        soapLogin.setUsed(false);
        soapLogin.setRoomId(roomId);
        soapLogin.setAllowSameURLMultipleTimes(allowSameURLMultipleTimes);
        soapLogin.setHash(UUID.randomUUID().toString());
        soapLogin.setRecordingId(recordingId);
        soapLogin.setSessionHash(sessionHash);
        soapLogin.setModerator(becomemoderator);
        soapLogin.setShowAudioVideoTest(showAudioVideoTest);
        soapLogin.setAllowRecording(allowRecording);
        this.em.persist((Object)soapLogin);
        this.em.flush();
        Long soapLoginId = soapLogin.getId();
        if (soapLoginId != null) {
            return soapLogin.getHash();
        }
        log.error("[addSOAPLogin]: Could not store SOAPLogin");
        return null;
    }

    public SOAPLogin get(String hash) {
        if (hash == null) {
            return null;
        }
        try {
            List sList = this.em.createNamedQuery("getSoapLoginByHash", SOAPLogin.class).setParameter("hash", (Object)String.format("%%%s%%", hash)).getResultList();
            if (sList.size() == 1) {
                SOAPLogin sl = (SOAPLogin)sList.get(0);
                if (hash.equals(sl.getHash())) {
                    return sl;
                }
                log.error("[get]: Wrong SOAPLogin was found by hash! {}", (Object)hash);
            }
            if (sList.size() > 1) {
                log.error("[get]: there are more then one SOAPLogin with identical hash! {}", (Object)hash);
            }
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
        }
        return null;
    }

    public void update(SOAPLogin soapLogin) {
        try {
            if (soapLogin.getId() == null) {
                this.em.persist((Object)soapLogin);
            } else if (!this.em.contains((Object)soapLogin)) {
                this.em.merge((Object)soapLogin);
            }
        }
        catch (Exception ex2) {
            log.error("[update]: ", (Throwable)ex2);
        }
    }
}

