/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.AsteriskSipUser;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.crypt.ICrypt;
import org.apache.wicket.util.string.Strings;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UserDao
implements IGroupAdminDataProviderDao<User> {
    private static final Logger log = Red5LoggerFactory.getLogger(UserDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    private static final String[] searchFields = new String[]{"lastname", "firstname", "login", "address.email", "address.town"};
    @PersistenceContext
    private EntityManager em;

    public static Set<User.Right> getDefaultRights() {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        rights.add(User.Right.Login);
        rights.add(User.Right.Dashboard);
        rights.add(User.Right.Room);
        return rights;
    }

    public static User getNewUserInstance(User currentUser) {
        User user = new User();
        user.setSalutation(User.Salutation.mr);
        user.setRights(UserDao.getDefaultRights());
        user.setLanguageId(OpenmeetingsVariables.getDefaultLang());
        user.setTimeZoneId(TimezoneUtil.getTimeZone(currentUser).getID());
        user.setForceTimeZoneCheck(false);
        user.setAge(new Date());
        user.setLastlogin(new Date());
        Address address = new Address();
        address.setCountry(Locale.getDefault().getCountry());
        user.setAddress(address);
        user.setShowContactData(false);
        user.setShowContactDataToContacts(false);
        return user;
    }

    @Override
    public List<User> get(long first, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedUsers", User.class), first, count).getResultList();
    }

    private static String getAdditionalJoin(boolean filterContacts) {
        return filterContacts ? "LEFT JOIN u.groupUsers ou" : null;
    }

    private static String getAdditionalWhere(boolean excludeContacts, Map<String, Object> params) {
        if (excludeContacts) {
            params.put("contact", (Object)User.Type.contact);
            return "u.type <> :contact";
        }
        return null;
    }

    private static String getAdditionalWhere(boolean filterContacts, Long ownerId, Map<String, Object> params) {
        if (filterContacts) {
            params.put("ownerId", ownerId);
            params.put("contact", (Object)User.Type.contact);
            return "((u.type <> :contact AND ou.group.id IN (SELECT ou.group.id FROM GroupUser ou WHERE ou.user.id = :ownerId)) OR (u.type = :contact AND u.ownerId = :ownerId))";
        }
        return null;
    }

    private static void setAdditionalParams(TypedQuery<?> q, Map<String, Object> params) {
        for (Map.Entry<String, Object> me : params.entrySet()) {
            q.setParameter(me.getKey(), me.getValue());
        }
    }

    private List<User> get(String search, Long start, Long count, String order, boolean filterContacts, Long currentUserId, boolean filterDeleted) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("User", "u", UserDao.getAdditionalJoin(filterContacts), search, true, filterDeleted, false, UserDao.getAdditionalWhere(filterContacts, currentUserId, params), order, searchFields), User.class);
        UserDao.setAdditionalParams(DaoHelper.setLimits(q, start, count), params);
        return q.getResultList();
    }

    public List<User> get(String search, boolean excludeContacts, long first, long count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("User", "u", null, search, true, true, false, UserDao.getAdditionalWhere(excludeContacts, params), null, searchFields), User.class);
        UserDao.setAdditionalParams(DaoHelper.setLimits(q, first, count), params);
        return q.getResultList();
    }

    public List<User> get(String search, boolean filterContacts, Long currentUserId) {
        return this.get(search, null, null, null, filterContacts, currentUserId, true);
    }

    public List<User> get(String search, long start, long count, String sort, boolean filterContacts, Long currentUserId) {
        return this.get(search, start, count, sort, filterContacts, currentUserId, true);
    }

    @Override
    public List<User> adminGet(String search, long start, long count, String order) {
        return this.get(search, start, count, order, false, null, false);
    }

    @Override
    public List<User> adminGet(String search, Long adminId, long start, long count, String order) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("GroupUser gu, IN(gu.user)", "u", null, search, true, false, false, "gu.group.id IN (SELECT gu1.group.id FROM GroupUser gu1 WHERE gu1.moderator = true AND gu1.user.id = :adminId)", order, searchFields), User.class);
        q.setParameter("adminId", (Object)adminId);
        return DaoHelper.setLimits(q, start, count).getResultList();
    }

    private long count(String search, boolean filterContacts, Long currentUserId, boolean filterDeleted) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("User", "u", UserDao.getAdditionalJoin(filterContacts), search, true, filterDeleted, true, UserDao.getAdditionalWhere(filterContacts, currentUserId, params), null, searchFields), Long.class);
        UserDao.setAdditionalParams(q, params);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countNondeletedUsers", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        return this.count(search, false, -1L);
    }

    public long countUsers(String search, Long currentUserId) {
        return this.count(search, false, currentUserId);
    }

    public long count(String search, boolean filterContacts, Long currentUserId) {
        return this.count(search, filterContacts, currentUserId, true);
    }

    @Override
    public long adminCount(String search) {
        return this.count(search, false, -1L, false);
    }

    @Override
    public long adminCount(String search, Long adminId) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("GroupUser gu, IN(gu.user)", "u", null, search, true, false, true, "gu.group.id IN (SELECT gu1.group.id FROM GroupUser gu1 WHERE gu1.moderator = true AND gu1.user.id = :adminId)", null, searchFields), Long.class);
        q.setParameter("adminId", (Object)adminId);
        return (Long)q.getSingleResult();
    }

    @Override
    public User update(User u, Long userId) {
        if (u.getId() == null) {
            if (u.getRegdate() == null) {
                u.setRegdate(new Date());
            }
            u.setInserted(new Date());
            this.em.persist((Object)u);
        } else {
            u.setUpdated(new Date());
            u = (User)this.em.merge((Object)u);
        }
        return u;
    }

    public User resetPassword(User u, String password) throws NoSuchAlgorithmException {
        if (u != null) {
            u.setResethash(null);
            u = this.update(u, password, u.getId());
        }
        return u;
    }

    private User updatePassword(Long id, String pwd, Long updatedBy) throws NoSuchAlgorithmException {
        User u = this.get(id, true);
        u.updatePassword(pwd);
        return this.update(u, updatedBy);
    }

    public User update(User user, String password, Long updatedBy) throws NoSuchAlgorithmException {
        User u = this.update(user, updatedBy);
        if (u != null && !Strings.isEmpty((CharSequence)password)) {
            u = this.updatePassword(u.getId(), password, updatedBy);
        }
        return u;
    }

    @Override
    public User get(Long id) {
        return this.get(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User get(Long id, boolean force) {
        User u = null;
        if (id != null && id > 0L) {
            OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
            boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
            try {
                List list;
                oem.getFetchPlan().setQueryResultCacheEnabled(false);
                TypedQuery q = oem.createNamedQuery("getUserById", User.class).setParameter("id", (Object)id);
                OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
                kq.getFetchPlan().addFetchGroup("groupUsers");
                if (force) {
                    kq.getFetchPlan().addFetchGroup("backupexport");
                }
                u = (list = kq.getResultList()).size() == 1 ? (User)list.get(0) : null;
            }
            finally {
                oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
            }
        } else {
            log.info("[get]: No user id given");
        }
        return u;
    }

    @Override
    public void delete(User u, Long userId) {
        if (u != null && u.getId() != null) {
            u.setGroupUsers(new ArrayList<GroupUser>());
            u.setDeleted(true);
            u.setUpdated(new Date());
            u.setSipUser(null);
            Address adr = u.getAddress();
            if (adr != null) {
                adr.setDeleted(true);
            }
            this.update(u, userId);
        }
    }

    public void purge(User u, Long userId) {
        if (u != null && u.getId() != null) {
            this.em.createNamedQuery("purgeChatUserName").setParameter("purged", (Object)"Purged User").setParameter("userId", (Object)u.getId()).executeUpdate();
            this.em.createNamedQuery("clearLogUserIpByUser").setParameter("userId", (Object)u.getId()).executeUpdate();
            if (!Strings.isEmpty((CharSequence)u.getAddress().getEmail())) {
                this.em.createNamedQuery("purgeMailMessages").setParameter("email", (Object)String.format("%%%s%%", u.getAddress().getEmail())).executeUpdate();
            }
            u.setActivatehash(null);
            u.setResethash(null);
            u.setDeleted(true);
            u.setSipUser(new AsteriskSipUser());
            u.setAddress(new Address());
            u.setAge(new Date());
            u.setExternalId(null);
            String purged = String.format("Purged %s", UUID.randomUUID());
            u.setFirstname(purged);
            u.setLastname(purged);
            u.setLogin(purged);
            u.setGroupUsers(new ArrayList<GroupUser>());
            u.setRights(new HashSet<User.Right>());
            u.setTimeZoneId(OpenmeetingsVariables.getDefaultTimezone());
            File pic = OmFileHelper.getUserProfilePicture((Long)u.getId(), (String)u.getPictureUri(), null);
            u.setPictureUri(null);
            ICrypt crypt = CryptProvider.get();
            try {
                u.updatePassword(crypt.randomPassword(25));
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unexpected exception while updating password");
            }
            this.update(u, userId);
            if (pic != null) {
                pic.delete();
            }
        }
    }

    public List<User> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getUsersByIds", User.class).setParameter("ids", ids).getResultList();
    }

    public List<User> getAllUsers() {
        TypedQuery q = this.em.createNamedQuery("getNondeletedUsers", User.class);
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getAllBackupUsers() {
        OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
        boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
        try {
            oem.getFetchPlan().setQueryResultCacheEnabled(false);
            TypedQuery q = oem.createNamedQuery("getAllUsers", User.class);
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
            kq.getFetchPlan().addFetchGroups(new String[]{"backupexport", "groupUsers"});
            List list = kq.getResultList();
            return list;
        }
        finally {
            oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
        }
    }

    public boolean checkLogin(String login, User.Type type, Long domainId, Long id) {
        User u = this.getByLogin(login, type, domainId);
        return u == null || u.getId().equals(id);
    }

    public boolean checkEmail(String email, User.Type type, Long domainId, Long id) {
        log.debug("checkEmail: email = {}, id = {}", (Object)email, (Object)id);
        User u = this.getByEmail(email, type, domainId);
        return u == null || u.getId().equals(id);
    }

    public boolean validLogin(String login) {
        return !Strings.isEmpty((CharSequence)login) && login.length() >= OpenmeetingsVariables.getMinLoginLength();
    }

    private static User getSingle(List<User> list) {
        User u = null;
        if (list.size() == 1) {
            u = list.get(0);
            u.getGroupUsers().size();
        }
        return u;
    }

    public User getByLogin(String login, User.Type type, Long domainId) {
        return UserDao.getSingle(this.em.createNamedQuery("getUserByLogin", User.class).setParameter("login", (Object)login).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)).getResultList());
    }

    public User getByEmail(String email) {
        return this.getByEmail(email, User.Type.user, null);
    }

    public User getByEmail(String email, User.Type type, Long domainId) {
        return UserDao.getSingle(this.em.createNamedQuery("getUserByEmail", User.class).setParameter("email", (Object)email).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)).getResultList());
    }

    public User getUserByHash(String hash) {
        if (Strings.isEmpty((CharSequence)hash)) {
            return null;
        }
        return UserDao.getSingle(this.em.createNamedQuery("getUserByHash", User.class).setParameter("resethash", (Object)hash).setParameter("type", (Object)User.Type.user).getResultList());
    }

    public Long selectMaxFromUsersWithSearch(String search) {
        try {
            TypedQuery query = this.em.createNamedQuery("selectMaxFromUsersWithSearch", Long.class);
            query.setParameter("search", (Object)StringUtils.lowerCase((String)search));
            List ll = query.getResultList();
            log.info("selectMaxFromUsers {}", ll.get(0));
            return (Long)ll.get(0);
        }
        catch (Exception ex2) {
            log.error("[selectMaxFromUsers] ", (Throwable)ex2);
            return null;
        }
    }

    public boolean verifyPassword(Long userId, String password) {
        List l = this.em.createNamedQuery("getPassword", String.class).setParameter("userId", (Object)userId).getResultList();
        if (l == null || l.size() != 1) {
            return false;
        }
        String hash = (String)l.get(0);
        ICrypt crypt = CryptProvider.get();
        if (crypt.verify(password, hash)) {
            return true;
        }
        if (crypt.fallback(password, hash)) {
            log.warn("Password for user with ID {} crypted with outdated Crypt, updating ...", (Object)userId);
            try {
                User u = this.updatePassword(userId, password, userId);
                log.warn("Password for user {} updated successfully", (Object)u);
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unexpected exception while updating password");
            }
        }
        return false;
    }

    public User getContact(String email, Long ownerId) {
        return this.getContact(email, "", "", ownerId);
    }

    public User getContact(String email, User owner) {
        return this.getContact(email, "", "", null, null, owner);
    }

    public User getContact(String email, String firstName, String lastName, Long ownerId) {
        return this.getContact(email, firstName, lastName, null, null, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, Long ownerId) {
        return this.getContact(email, firstName, lastName, langId, tzId, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, User owner) {
        List list = this.em.createNamedQuery("getContactByEmailAndUser", User.class).setParameter("email", (Object)email).setParameter("type", (Object)User.Type.contact).setParameter("ownerId", (Object)owner.getId()).getResultList();
        if (list.isEmpty()) {
            User to = new User();
            to.setType(User.Type.contact);
            String login = owner.getId() + "_" + email;
            to.setLogin(login.length() < OpenmeetingsVariables.getMinLoginLength() ? UUID.randomUUID().toString() : login);
            to.setFirstname(firstName);
            to.setLastname(lastName);
            to.setLanguageId(null == langId || null == LabelDao.getLocale(langId) ? owner.getLanguageId() : langId.longValue());
            to.setOwnerId(owner.getId());
            to.setAddress(new Address());
            to.getAddress().setEmail(email);
            to.setTimeZoneId(Strings.isEmpty((CharSequence)tzId) ? owner.getTimeZoneId() : tzId);
            return to;
        }
        return (User)list.get(0);
    }

    public User getByActivationHash(String hash) {
        return UserDao.getSingle(this.em.createQuery("SELECT u FROM User as u WHERE u.activatehash = :activatehash AND u.deleted = false", User.class).setParameter("activatehash", (Object)hash).getResultList());
    }

    private <T> TypedQuery<T> getUserProfileQuery(Class<T> clazz, Long userId, String text, String offers, String search, String orderBy, boolean asc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean filterContacts = true;
        boolean count = clazz.isAssignableFrom(Long.class);
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(count ? "COUNT(" : "").append("u").append(count ? ") " : " ").append("FROM User u ").append(UserDao.getAdditionalJoin(filterContacts)).append(" WHERE u.deleted = false AND ").append(UserDao.getAdditionalWhere(filterContacts, userId, params));
        if (!Strings.isEmpty((CharSequence)offers)) {
            sb.append(" AND (LOWER(u.userOffers) LIKE :userOffers) ");
            params.put("userOffers", DaoHelper.getStringParam(offers));
        }
        if (!Strings.isEmpty((CharSequence)search)) {
            sb.append(" AND (LOWER(u.userSearchs) LIKE :userSearchs) ");
            params.put("userSearchs", DaoHelper.getStringParam(search));
        }
        if (!Strings.isEmpty((CharSequence)text)) {
            sb.append(" AND (LOWER(u.login) LIKE :search ").append("OR LOWER(u.firstname) LIKE :search ").append("OR LOWER(u.lastname) LIKE :search ").append("OR LOWER(u.address.email) LIKE :search ").append("OR LOWER(u.address.town) LIKE :search ) ");
            params.put("search", DaoHelper.getStringParam(text));
        }
        if (!count && !Strings.isEmpty((CharSequence)orderBy)) {
            sb.append(" ORDER BY ").append(orderBy).append(asc ? " ASC" : " DESC");
        }
        TypedQuery query = this.em.createQuery(sb.toString(), clazz);
        UserDao.setAdditionalParams(query, params);
        return query;
    }

    public List<User> searchUserProfile(Long userId, String text, String offers, String search, String orderBy, long start, long max, boolean asc) {
        return DaoHelper.setLimits(this.getUserProfileQuery(User.class, userId, text, offers, search, orderBy, asc), start, max).getResultList();
    }

    public Long searchCountUserProfile(Long userId, String text, String offers, String search) {
        return (Long)this.getUserProfileQuery(Long.class, userId, text, offers, search, null, false).getSingleResult();
    }

    public User getExternalUser(String extId, String extType) {
        return UserDao.getSingle(this.em.createNamedQuery("getExternalUser", User.class).setParameter("externalId", (Object)extId).setParameter("externalType", (Object)extType).getResultList());
    }

    @Override
    public List<User> get(String search, long start, long count, String order) {
        return this.get(search, start, count, order, false, -1L);
    }

    public Set<User.Right> getRights(Long id) {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        if (id == null) {
            return rights;
        }
        if (id < 0L) {
            rights.add(User.Right.Room);
            return rights;
        }
        User u = this.get(id);
        if (u != null) {
            return u.getRights();
        }
        return rights;
    }

    public User login(String userOrEmail, String userpass) throws OmException {
        List users = this.em.createNamedQuery("getUserByLoginOrEmail", User.class).setParameter("userOrEmail", (Object)userOrEmail).setParameter("type", (Object)User.Type.user).getResultList();
        log.debug("login:: {} users were found", (Object)users.size());
        if (users.isEmpty()) {
            log.debug("No users was found: {}", (Object)userOrEmail);
            return null;
        }
        User u = (User)users.get(0);
        if (!this.verifyPassword(u.getId(), userpass)) {
            log.debug("Password does not match: {}", (Object)u);
            return null;
        }
        if (!AuthLevelUtil.hasLoginLevel(u.getRights())) {
            log.debug("Not activated: {}", (Object)u);
            throw new OmException("error.notactivated");
        }
        log.debug("loginUser " + u.getGroupUsers());
        if (u.getGroupUsers().isEmpty()) {
            log.debug("No Group assigned: {}", (Object)u);
            throw new OmException("error.nogroup");
        }
        u.setLastlogin(new Date());
        return this.update(u, u.getId());
    }

    public List<User> getByExpiredHash(long ttl) {
        return this.em.createNamedQuery("getUserByExpiredHash", User.class).setParameter("date", (Object)new Date(System.currentTimeMillis() - ttl)).getResultList();
    }
}

