/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.user;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class OAuthUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Red5LoggerFactory.getLogger(OAuthUser.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    public static final String PARAM_LOGIN = "login";
    public static final String PARAM_EMAIL = "address.email";
    public static final String PARAM_FNAME = "firstname";
    public static final String PARAM_LNAME = "lastname";
    private final Map<String, String> userData;

    public OAuthUser(String jsonStr, OAuthServer server) {
        JSONObject json = OAuthUser.getJSON(jsonStr, server.getMapping().get(PARAM_LOGIN));
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : server.getMapping().entrySet()) {
            data.put(entry.getKey(), json.optString(entry.getValue()));
        }
        String login = (String)data.get(PARAM_LOGIN);
        String email = (String)data.get(PARAM_EMAIL);
        if (Strings.isEmpty((CharSequence)email)) {
            try {
                data.put(PARAM_EMAIL, String.format("%s@%s", login, new URL(server.getIconUrl()).getHost()));
            }
            catch (MalformedURLException e) {
                log.error("Failed to get user email from JSON: {}", (Object)json);
            }
        }
        this.userData = Collections.unmodifiableMap(data);
    }

    public OAuthUser(Map<String, String> umap) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PARAM_LOGIN, umap.get(PARAM_LOGIN));
        data.put(PARAM_EMAIL, umap.get("email"));
        data.put(PARAM_FNAME, umap.get(PARAM_FNAME));
        data.put(PARAM_LNAME, umap.get(PARAM_LNAME));
        this.userData = Collections.unmodifiableMap(data);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public String getLogin() {
        return this.userData.get(PARAM_LOGIN);
    }

    public String getEmail() {
        return this.userData.get(PARAM_EMAIL);
    }

    private static JSONObject getJSON(String str, String prop) {
        JSONObject json = new JSONObject(str);
        if (json.has(prop)) {
            return json;
        }
        for (String key : json.keySet()) {
            JSONObject jo;
            Object o = json.get(key);
            if (o instanceof JSONArray) {
                JSONArray ja = (JSONArray)o;
                for (int i = 0; i < ja.length(); ++i) {
                    JSONObject jao = ja.getJSONObject(i);
                    if (!jao.has(prop)) continue;
                    return jao;
                }
                continue;
            }
            if (!(o instanceof JSONObject) || !(jo = (JSONObject)o).has(prop)) continue;
            return jo;
        }
        return new JSONObject();
    }
}

