/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SessiondataDao {
    private static final Logger log = LoggerFactory.getLogger(SessiondataDao.class);
    @PersistenceContext
    private EntityManager em;

    private static Sessiondata newInstance() {
        log.debug("startsession :: startsession");
        Sessiondata sd = new Sessiondata();
        sd.setSessionId(UUID.randomUUID().toString());
        sd.setCreated(new Date());
        sd.setUserId(null);
        return sd;
    }

    public Sessiondata create(Long userId, long languageId) {
        return this.create(userId, null, languageId);
    }

    public Sessiondata create(Long userId, Long roomId, long languageId) {
        log.debug("create :: create");
        Sessiondata sd = SessiondataDao.newInstance();
        sd.setUserId(userId);
        sd.setRoomId(roomId);
        sd.setLanguageId(languageId);
        return this.update(sd);
    }

    public Sessiondata find(String sid) {
        if (sid == null) {
            return null;
        }
        List sessions = this.em.createNamedQuery("getSessionById", Sessiondata.class).setParameter("sessionId", (Object)String.format("%%%s%%", sid)).getResultList();
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        Sessiondata sd = (Sessiondata)sessions.get(0);
        if (sd == null || sd.getUserId() == null || sd.getUserId().equals(new Long(0L)) || !sid.equals(sd.getSessionId())) {
            return null;
        }
        return sd;
    }

    public Sessiondata check(String sid) {
        Sessiondata sd = this.find(sid);
        if (sd == null) {
            return SessiondataDao.newInstance();
        }
        return this.update(sd);
    }

    private List<Sessiondata> getSessionToDelete(Date refreshed) {
        try {
            TypedQuery query = this.em.createNamedQuery("getSessionToDelete", Sessiondata.class);
            query.setParameter("refreshed", (Object)refreshed);
            return query.getResultList();
        }
        catch (Exception ex2) {
            log.error("[getSessionToDelete]: ", (Throwable)ex2);
            return new ArrayList<Sessiondata>();
        }
    }

    public void clearSessionTable(long timeout) {
        try {
            log.trace("****** clearSessionTable: ");
            List<Sessiondata> l = this.getSessionToDelete(new Date(System.currentTimeMillis() - timeout));
            if (!l.isEmpty()) {
                log.debug("clearSessionTable: {}", (Object)l.size());
                for (Sessiondata sData : l) {
                    sData = (Sessiondata)this.em.find(Sessiondata.class, (Object)sData.getId());
                    this.em.remove((Object)sData);
                }
            }
        }
        catch (Exception err) {
            log.error("clearSessionTable", (Throwable)err);
        }
    }

    public Sessiondata update(Sessiondata sd) {
        sd.setRefreshed(new Date());
        if (sd.getId() == null) {
            this.em.persist((Object)sd);
        } else {
            sd = (Sessiondata)this.em.merge((Object)sd);
        }
        return sd;
    }
}

