/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.IWebSession;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.util.OMContextListener;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.Application;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.mock.MockWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ApplicationHelper {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHelper.class);
    private static final Object SYNC_OBJ = new Object();

    private ApplicationHelper() {
    }

    private static WebApplication createApp(WebApplication _app) {
        WebApplication app = _app;
        if (app == null) {
            try {
                app = (WebApplication)OpenmeetingsVariables.getAppClass().newInstance();
                app.setName(String.format("--%s--", UUID.randomUUID()));
                MockServletContext sc = new MockServletContext((Application)app, null);
                XmlWebApplicationContext xmlContext = new XmlWebApplicationContext();
                xmlContext.setConfigLocation("classpath:applicationContext.xml");
                xmlContext.setServletContext((ServletContext)sc);
                xmlContext.refresh();
                sc.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)xmlContext);
                app = (WebApplication)xmlContext.getBean(WebApplication.class);
                app.setName(OpenmeetingsVariables.getWicketApplicationName());
                app.setServletContext((ServletContext)sc);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Failed to create Application");
            }
        }
        return app;
    }

    private static WebApplication initApp(WebApplication app) {
        if (app != null) {
            try {
                app.getServletContext();
            }
            catch (IllegalStateException e) {
                app.setServletContext((ServletContext)new MockServletContext((Application)app, null));
            }
            try {
                app.setConfigurationType(RuntimeConfigurationType.DEPLOYMENT);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            OMContextListener omcl = new OMContextListener();
            omcl.contextInitialized(new ServletContextEvent(app.getServletContext()));
            ThreadContext.setApplication((Application)app);
            app.initApplication();
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IApplication ensureApplication() {
        if (Application.exists()) {
            return (IApplication)Application.get();
        }
        Object object = SYNC_OBJ;
        synchronized (object) {
            if (Application.exists()) {
                return (IApplication)Application.get();
            }
            WebApplication app = ApplicationHelper.createApp((WebApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName()));
            LabelDao.initLanguageMap();
            if (app != null) {
                if (!OpenmeetingsVariables.isInitComplete()) {
                    ApplicationHelper.initApp(app);
                }
                ThreadContext.setApplication((Application)app);
            }
            return (IApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
        }
    }

    public static IApplication ensureApplication(Long langId) {
        IApplication a = ApplicationHelper.ensureApplication();
        if (ThreadContext.getRequestCycle() == null) {
            ServletWebRequest req = new ServletWebRequest((HttpServletRequest)new MockHttpServletRequest((Application)a, (HttpSession)new MockHttpSession(a.getServletContext()), a.getServletContext()), "");
            RequestCycleContext rctx = new RequestCycleContext((Request)req, (Response)new MockWebResponse(), a.getRootRequestMapper(), a.getExceptionMapperProvider().get());
            ThreadContext.setRequestCycle((RequestCycle)new RequestCycle(rctx));
        }
        if (ThreadContext.getSession() == null) {
            WebSession s = WebSession.get();
            if (langId > 0L) {
                ((IWebSession)s).setLanguage(langId);
            }
        }
        return a;
    }

    public static void destroyApplication() {
        WebApplication app = (WebApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)app.getServletContext());
        app.internalDestroy();
        if (ctx != null) {
            ((XmlWebApplicationContext)ctx).close();
        }
        ThreadContext.setApplication(null);
        ThreadContext.setRequestCycle(null);
        ThreadContext.setSession(null);
    }

    public static WebApplicationContext getApplicationContext(Long langId) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)((WebApplication)ApplicationHelper.ensureApplication(langId)).getServletContext());
    }
}

