/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.file.BaseFileItemDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class FileItemDao
extends BaseFileItemDao {
    private static final Logger log = LoggerFactory.getLogger(FileItemDao.class);

    public List<FileItem> getByRoom(Long roomId) {
        log.debug("getByRoom roomId :: {}", (Object)roomId);
        return this.em.createNamedQuery("getFilesByRoom", FileItem.class).setParameter("roomId", (Object)roomId).getResultList();
    }

    public List<FileItem> getByOwner(Long ownerId) {
        log.debug("getByOwner() started");
        TypedQuery query = this.em.createNamedQuery("getFilesByOwner", FileItem.class);
        query.setParameter("ownerId", (Object)ownerId);
        return query.getResultList();
    }

    public List<FileItem> getByGroup(Long groupId) {
        log.debug("getByGroup() started");
        return this.em.createNamedQuery("getFileByGroup", FileItem.class).setParameter("groupId", (Object)groupId).getResultList();
    }

    public List<FileItem> getByGroup(Long groupId, List<BaseFileItem.Type> filter) {
        if (filter == null) {
            return this.getByGroup(groupId);
        }
        log.debug("getByGroup() started");
        return this.em.createNamedQuery("getFileFilteredByGroup", FileItem.class).setParameter("filter", filter).setParameter("groupId", (Object)groupId).getResultList();
    }

    public List<FileItem> getByParent(Long parentId) {
        log.debug("getByParent() started");
        return this.em.createNamedQuery("getFilesByParent", FileItem.class).setParameter("parentId", (Object)parentId).getResultList();
    }

    public List<FileItem> getByParent(Long parentId, List<BaseFileItem.Type> filter) {
        if (filter == null) {
            return this.getByParent(parentId);
        }
        log.debug("getByParent(filter) started");
        return this.em.createNamedQuery("getFilesFilteredByParent", FileItem.class).setParameter("filter", filter).setParameter("parentId", (Object)parentId).getResultList();
    }

    public FileItem getByHash(String hash) {
        BaseFileItem bf = super.get(hash);
        return bf instanceof FileItem ? (FileItem)bf : null;
    }

    @Override
    public FileItem get(Long id) {
        BaseFileItem bf = super.get(id);
        return bf instanceof FileItem ? (FileItem)bf : null;
    }

    public FileItem get(String externalId, String externalType) {
        log.debug("get started");
        List list = this.em.createNamedQuery("getFileExternal", FileItem.class).setParameter("externalFileId", (Object)externalId).setParameter("externalType", (Object)externalType).getResultList();
        return list.size() == 1 ? (FileItem)list.get(0) : null;
    }

    public List<FileItem> get() {
        log.debug("get started");
        return this.em.createNamedQuery("getAllFiles", FileItem.class).getResultList();
    }

    public List<FileItem> getExternal(String externalType) {
        log.debug("get external started");
        return this.em.createNamedQuery("getFileAllExternal", FileItem.class).setParameter("externalType", (Object)externalType).getResultList();
    }

    public void delete(String externalId, String externalType) {
        log.debug("delete started");
        this.delete(this.get(externalId, externalType));
    }

    public FileItem rename(Long id, String name) {
        log.debug("rename started");
        FileItem f = this.get(id);
        if (f == null) {
            return null;
        }
        f.setName(name);
        return this.update(f);
    }

    public FileItem update(FileItem f) {
        return (FileItem)super._update(f);
    }

    private void updateChilds(FileItem f) {
        for (FileItem child : this.getByParent(f.getId())) {
            child.setOwnerId(f.getOwnerId());
            child.setRoomId(f.getRoomId());
            this.update(child);
            if (BaseFileItem.Type.Folder != f.getType()) continue;
            this.updateChilds(child);
        }
    }

    public FileItem move(long id, long parentId, long ownerId, long roomId) {
        log.debug(".move() started");
        FileItem f = this.get(id);
        if (f == null) {
            return null;
        }
        if (parentId < 0L) {
            if (parentId == -1L) {
                f.setOwnerId(ownerId);
                f.setRoomId(null);
            } else {
                f.setOwnerId(null);
                f.setRoomId(roomId);
            }
            f.setParentId(null);
        } else {
            f.setParentId(parentId);
            f.setOwnerId(null);
        }
        if (BaseFileItem.Type.Folder == f.getType()) {
            this.updateChilds(f);
        }
        return this.update(f);
    }

    public List<BaseFileItem> getAllRoomFiles(String search, long start, long count, Long roomId, List<Group> groups) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getAllFileItemsForRoom", BaseFileItem.class).setParameter("folder", (Object)BaseFileItem.Type.Folder).setParameter("roomId", (Object)roomId).setParameter("groups", groups.parallelStream().map(Group::getId).collect(Collectors.toList())).setParameter("name", (Object)String.format("%%%s%%", search == null ? "" : search)), start, count).getResultList();
    }

    public List<BaseFileItem> get(Collection<String> ids) {
        return this.em.createNamedQuery("getFileItemsByIds", BaseFileItem.class).setParameter("ids", ids.parallelStream().map(Long::valueOf).collect(Collectors.toList())).getResultList();
    }

    public long getOwnSize(Long userId) {
        return this.getSize(this.getByOwner(userId));
    }

    public long getRoomSize(Long roomId) {
        return this.getSize(this.getByRoom(roomId));
    }

    public long getSize(List<FileItem> list) {
        long size = 0L;
        for (FileItem f : list) {
            size += this.getSize(f);
        }
        return size;
    }

    public long getSize(FileItem f) {
        long size = 0L;
        try {
            if (f.exists()) {
                File base = OmFileHelper.getUploadFilesDir();
                switch (f.getType()) {
                    case Image: 
                    case Presentation: 
                    case Video: {
                        File tFolder = new File(base, f.getHash());
                        if (!tFolder.exists()) break;
                        size += OmFileHelper.getSize((File)tFolder);
                        break;
                    }
                }
            }
            if (BaseFileItem.Type.Folder == f.getType()) {
                for (FileItem child : this.getByParent(f.getId())) {
                    size += this.getSize(child);
                }
            }
        }
        catch (Exception err) {
            log.error("[getSize] ", (Throwable)err);
        }
        return size;
    }
}

