/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class InvitationDao
implements IDataProviderDao<Invitation> {
    private static final Logger log = LoggerFactory.getLogger(InvitationDao.class);
    @PersistenceContext
    private EntityManager em;

    @Override
    public Invitation get(Long invId) {
        List list = this.em.createNamedQuery("getInvitationbyId", Invitation.class).setParameter("id", (Object)invId).getResultList();
        return list.size() == 1 ? (Invitation)list.get(0) : null;
    }

    @Override
    public List<Invitation> get(long start, long count) {
        return this.get(null, start, count, null);
    }

    private static String getQuery(String head, String tail, String search) {
        return InvitationDao.getQuery(head, tail, search, null);
    }

    private static String getQuery(String head, String tail, String search, String sort) {
        StringBuilder sb = new StringBuilder(head);
        sb.append(tail);
        DaoHelper.appendWhereClause(sb, search, "i", "invitee.firstname", "invitee.lastname", "invitee.login");
        return DaoHelper.appendSort(sb, "i", sort).toString();
    }

    @Override
    public List<Invitation> get(String search, long start, long count, String order) {
        return DaoHelper.setLimits(this.em.createQuery(InvitationDao.getQuery("SELECT i ", " FROM Invitation i WHERE i.deleted = false", search, order), Invitation.class), start, count).getResultList();
    }

    @Override
    public long count() {
        return this.count(null);
    }

    @Override
    public long count(String search) {
        return (Long)this.em.createQuery(InvitationDao.getQuery("SELECT COUNT(i) ", " FROM Invitation i WHERE i.deleted = false", search), Long.class).getSingleResult();
    }

    public List<Invitation> getGroup(String search, long start, long count, Long userId, String order) {
        return DaoHelper.setLimits(this.em.createQuery(InvitationDao.getQuery("SELECT i ", " FROM Invitation i WHERE i.deleted = false AND i.invitedBy.id IN (SELECT gu1.user.id FROM GroupUser gu1 WHERE gu1.group.id IN \t\t(SELECT gu.group.id FROM GroupUser gu WHERE gu.moderator = true AND gu.user.id = :userId))", search, order), Invitation.class).setParameter("userId", (Object)userId), start, count).getResultList();
    }

    public long countGroup(String search, Long userId) {
        return (Long)this.em.createQuery(InvitationDao.getQuery("SELECT COUNT(i) ", " FROM Invitation i WHERE i.deleted = false AND i.invitedBy.id IN (SELECT gu1.user.id FROM GroupUser gu1 WHERE gu1.group.id IN \t\t(SELECT gu.group.id FROM GroupUser gu WHERE gu.moderator = true AND gu.user.id = :userId))", search), Long.class).setParameter("userId", (Object)userId).getSingleResult();
    }

    public List<Invitation> getUser(String search, long start, long count, Long userId, String order) {
        return DaoHelper.setLimits(this.em.createQuery(InvitationDao.getQuery("SELECT i ", " FROM Invitation i WHERE i.deleted = false AND i.invitedBy.id = :userId", search, order), Invitation.class).setParameter("userId", (Object)userId), start, count).getResultList();
    }

    public long countUser(String search, Long userId) {
        return (Long)this.em.createQuery(InvitationDao.getQuery("SELECT COUNT(i) ", " FROM Invitation i WHERE i.deleted = false AND i.invitedBy.id = :userId", search), Long.class).setParameter("userId", (Object)userId).getSingleResult();
    }

    public Invitation update(Invitation invitation) {
        if (invitation.getId() == null) {
            invitation.setInserted(new Date());
            this.em.persist((Object)invitation);
        } else {
            invitation.setUpdated(new Date());
            invitation = (Invitation)this.em.merge((Object)invitation);
        }
        return invitation;
    }

    @Override
    public Invitation update(Invitation entity, Long userId) {
        return this.update(entity);
    }

    @Override
    public void delete(Invitation entity, Long userId) {
        entity.setDeleted(true);
        this.update(entity, userId);
    }

    public Invitation getByHash(String hash, boolean hidePass, boolean markUsed) {
        Invitation i;
        List list = this.em.createNamedQuery("getInvitationByHashCode", Invitation.class).setParameter("hashCode", (Object)hash).getResultList();
        Invitation invitation = i = list != null && list.size() == 1 ? (Invitation)list.get(0) : null;
        if (i != null) {
            switch (i.getValid()) {
                case OneTime: {
                    i.setAllowEntry(!i.isUsed());
                    if (!markUsed) break;
                    i.setUsed(true);
                    this.update(i);
                    this.em.flush();
                    break;
                }
                case Period: {
                    String tzId = i.getInvitee().getTimeZoneId();
                    if (Strings.isEmpty((CharSequence)tzId) && i.getAppointment() != null) {
                        log.warn("User with NO timezone found: {}", (Object)i.getInvitee().getId());
                        tzId = i.getAppointment().getOwner().getTimeZoneId();
                    }
                    if (Strings.isEmpty((CharSequence)tzId)) {
                        log.warn("Unable to obtain valid timezone, setting SYSTEM TZ");
                        tzId = TimeZone.getDefault().getID();
                    }
                    LocalDateTime now = ZonedDateTime.now(CalendarHelper.getZoneId((String)tzId)).toLocalDateTime();
                    LocalDateTime from = CalendarHelper.getDateTime((Date)i.getValidFrom(), (String)tzId);
                    LocalDateTime to = CalendarHelper.getDateTime((Date)i.getValidTo(), (String)tzId);
                    i.setAllowEntry(now.isAfter(from) && now.isBefore(to));
                    break;
                }
                default: {
                    i.setAllowEntry(true);
                }
            }
            this.em.detach((Object)i);
            if (hidePass) {
                i.setPassword(null);
            }
        }
        return i;
    }
}

