/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.room.SipDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.log.ConferenceLog;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class RoomDao
implements IGroupAdminDataProviderDao<Room> {
    private static final Logger log = LoggerFactory.getLogger(RoomDao.class);
    private static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ConfigurationDao cfgDao;
    @Autowired
    private SipDao sipDao;
    @Autowired
    private UserDao userDao;

    @Override
    public Room get(Long id) {
        Room r = null;
        if (id != null && id > 0L) {
            r = (Room)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getRoomById", Room.class).setParameter("id", (Object)id), "roomModerators", "roomGroups", "roomFiles"));
        } else {
            log.info("[get]: No room id given");
        }
        return r;
    }

    public List<Room> get() {
        return DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getBackupRooms", Room.class), "roomModerators", "roomGroups", "roomFiles");
    }

    public List<Room> get(List<Long> ids) {
        return this.em.createNamedQuery("getRoomsByIds", Room.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public List<Room> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedRooms", Room.class), start, count).getResultList();
    }

    @Override
    public List<Room> get(String search, long start, long count, String sort) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("Room", "r", search, true, false, sort, searchFields), Room.class), start, count).getResultList();
    }

    @Override
    public List<Room> adminGet(String search, Long adminId, long start, long count, String order) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("RoomGroup rg, IN(rg.room)", "r", null, search, true, true, false, "rg.group.id IN (SELECT gu1.group.id FROM GroupUser gu1 WHERE gu1.moderator = true AND gu1.user.id = :adminId)", order, searchFields), Room.class).setParameter("adminId", (Object)adminId), start, count).getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countRooms", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("Room", "r", search, true, true, null, searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long adminCount(String search, Long adminId) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("RoomGroup rg, IN(rg.room)", "r", null, search, true, true, true, "rg.group.id IN (SELECT gu1.group.id FROM GroupUser gu1 WHERE gu1.moderator = true AND gu1.user.id = :adminId)", null, searchFields), Long.class);
        q.setParameter("adminId", (Object)adminId);
        return (Long)q.getSingleResult();
    }

    public List<Room> getPublicRooms() {
        return this.em.createNamedQuery("getPublicRoomsOrdered", Room.class).getResultList();
    }

    public List<Room> getPublicRooms(Room.Type type) {
        return type == null ? this.getPublicRooms() : this.em.createNamedQuery("getPublicRooms", Room.class).setParameter("type", (Object)type).getResultList();
    }

    public List<Long> getSipRooms(List<Long> ids) {
        TypedQuery q = this.em.createNamedQuery("getSipRoomIdsByIds", Long.class);
        q.setParameter("ids", ids);
        return q.getResultList();
    }

    public List<Room> getGroupRooms(long groupId) {
        TypedQuery q = this.em.createNamedQuery("getGroupRooms", Room.class);
        q.setParameter("groupId", (Object)groupId);
        return q.getResultList();
    }

    public List<Room> getAppointedRoomsByUser(long userId) {
        log.debug("getAppointedRoomsByUser : UserID - {}", (Object)userId);
        TimeZone timeZone = TimezoneUtil.getTimeZone((User)this.userDao.get(userId));
        Calendar startCal = Calendar.getInstance(timeZone);
        startCal.set(12, 0);
        startCal.set(10, 0);
        startCal.set(13, 1);
        Calendar endCal = Calendar.getInstance(timeZone);
        endCal.set(12, 23);
        endCal.set(10, 59);
        endCal.set(13, 59);
        return this.em.createNamedQuery("appointedRoomsInRangeByUser", Room.class).setParameter("userId", (Object)userId).setParameter("start", (Object)startCal.getTime()).setParameter("end", (Object)endCal.getTime()).getResultList();
    }

    public long getRoomsCapacityByIds(Collection<Long> ids) {
        return ids == null || ids.isEmpty() ? 0L : (Long)this.em.createNamedQuery("getRoomsCapacityByIds", Long.class).setParameter("ids", ids).getSingleResult();
    }

    private String getSipNumber(long roomId) {
        if (OpenmeetingsVariables.isSipEnabled()) {
            return this.cfgDao.getString("sip.room.prefix", "400") + roomId;
        }
        return null;
    }

    @Override
    public Room update(Room entity, Long userId) {
        if (entity.getId() == null) {
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            entity.setUpdated(new Date());
        }
        if (entity.isSipEnabled() && OpenmeetingsVariables.isSipEnabled()) {
            String sipNumber = this.getSipNumber(entity.getId());
            if (sipNumber != null && !sipNumber.equals(entity.getConfno())) {
                entity.setConfno(sipNumber);
            }
            this.sipDao.update(sipNumber, entity.getPin());
        } else {
            this.sipDao.delete(entity.getConfno());
            entity.setConfno(null);
            entity.setPin(null);
        }
        entity = (Room)this.em.merge((Object)entity);
        return entity;
    }

    @Override
    public void delete(Room entity, Long userId) {
        entity.setDeleted(true);
        entity.setSipEnabled(false);
        this.update(entity, userId);
    }

    public Room getUserRoom(Long ownerId, Room.Type type, String name) {
        log.debug("getUserRoom : {} || {}", (Object)ownerId, (Object)type);
        Room room = null;
        List ll = this.em.createNamedQuery("getRoomByOwnerAndTypeId", Room.class).setParameter("ownerId", (Object)ownerId).setParameter("type", (Object)type).getResultList();
        if (!ll.isEmpty()) {
            room = (Room)ll.get(0);
        }
        if (room == null) {
            log.debug("Could not find room {} || {}", (Object)ownerId, (Object)type);
            room = new Room();
            room.setName(name);
            room.setType(type);
            room.setComment("My Rooms of ownerId " + ownerId);
            room.setCapacity(Room.Type.conference == type ? 25L : 120L);
            room.setAllowUserQuestions(true);
            room.setOwnerId(ownerId);
            room.setAllowRecording(true);
            room.hide(Room.RoomElement.MicrophoneStatus);
            room = this.update(room, ownerId);
            if (room.getId() != null) {
                return room;
            }
            return null;
        }
        return room;
    }

    public Room getExternal(Room.Type type, String externalType, String externalId) {
        log.debug("getExternal : {} - {}  - {}", new Object[]{type, externalType, externalId});
        return (Room)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getExternalRoom", Room.class).setParameter("externalId", (Object)externalId).setParameter("externalType", (Object)externalType).setParameter("type", (Object)type), "roomGroups"));
    }

    public List<Room> getRecent(Long userId) {
        ArrayList<Room> result = new ArrayList<Room>();
        HashSet<Long> ids = new HashSet<Long>();
        for (ConferenceLog l : this.em.createNamedQuery("getLogRecentRooms", ConferenceLog.class).setParameter("roomEnter", (Object)ConferenceLog.Type.roomEnter).setParameter("userId", (Object)userId).getResultList()) {
            Room r;
            if (!ids.contains(l.getRoomId()) && (r = this.get(l.getRoomId())) != null && !r.isDeleted()) {
                result.add(r);
                ids.add(r.getId());
            }
            if (ids.size() != 5) continue;
            break;
        }
        return result;
    }

    public List<RoomFile> getFiles() {
        return this.em.createQuery("SELECT rf FROM RoomFile rf", RoomFile.class).getResultList();
    }

    public List<RoomGroup> getGroups() {
        return this.em.createNamedQuery("getAllRoomGroups", RoomGroup.class).getResultList();
    }

    public List<Room> getMyRooms(Long userId, String confLbl, String restrLbl) {
        ArrayList<Room> result = new ArrayList<Room>();
        result.add(this.getUserRoom(userId, Room.Type.conference, confLbl));
        result.add(this.getUserRoom(userId, Room.Type.presentation, restrLbl));
        result.addAll(this.getAppointedRoomsByUser(userId));
        return result;
    }
}

