/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InvitationDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InvitationDTO.class);
    private static final FastDateFormat SDF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private String email;
    private String firstname;
    private String lastname;
    private String message;
    private String subject;
    private Long roomId;
    private boolean passwordProtected;
    private String password;
    private Invitation.Valid valid;
    private String validFrom;
    private String validTo;
    private long languageId;

    public String getEmail() {
        return this.email;
    }

    public InvitationDTO setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public InvitationDTO setFirstname(String firstname) {
        this.firstname = firstname;
        return this;
    }

    public String getLastname() {
        return this.lastname;
    }

    public InvitationDTO setLastname(String lastname) {
        this.lastname = lastname;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public InvitationDTO setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public InvitationDTO setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public InvitationDTO setRoomId(Long roomId) {
        this.roomId = roomId;
        return this;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public InvitationDTO setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public InvitationDTO setPassword(String password) {
        this.password = password;
        return this;
    }

    public Invitation.Valid getValid() {
        return this.valid;
    }

    public InvitationDTO setValid(Invitation.Valid valid) {
        this.valid = valid;
        return this;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public InvitationDTO setValidFrom(String validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public InvitationDTO setValidTo(String validTo) {
        this.validTo = validTo;
        return this;
    }

    public long getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(long languageId) {
        this.languageId = languageId;
    }

    public Invitation get(Long userId, UserDao userDao, RoomDao roomDao) {
        Invitation i = new Invitation();
        i.setHash(UUID.randomUUID().toString());
        i.setPasswordProtected(this.passwordProtected);
        if (this.passwordProtected) {
            i.setPassword(CryptProvider.get().hash(this.password));
        }
        i.setUsed(false);
        i.setValid(this.valid);
        try {
            switch (this.valid) {
                case PERIOD: {
                    i.setValidFrom(new Date(SDF.parse(this.validFrom).getTime() - 300000L));
                    i.setValidTo(SDF.parse(this.validTo));
                    break;
                }
            }
        }
        catch (ParseException e) {
            log.error("Unexpected error while creating invitation", (Throwable)e);
            throw new RuntimeException(e);
        }
        i.setDeleted(false);
        i.setInvitedBy(userDao.get(userId));
        i.setInvitee(userDao.getContact(this.email, this.firstname, this.lastname, userId));
        if (User.Type.CONTACT == i.getInvitee().getType()) {
            i.getInvitee().setLanguageId(this.languageId);
        }
        i.setRoom(roomDao.get(this.roomId));
        i.setInserted(new Date());
        i.setAppointment(null);
        return i;
    }

    public static InvitationDTO fromString(String s) {
        return InvitationDTO.get(new JSONObject(s));
    }

    public static InvitationDTO get(JSONObject o) {
        if (o == null) {
            return null;
        }
        InvitationDTO i = new InvitationDTO();
        i.firstname = o.optString("firstname");
        i.lastname = o.optString("lastname");
        i.email = o.optString("email");
        i.password = o.optString("password");
        i.passwordProtected = o.optBoolean("passwordProtected", false);
        i.subject = o.optString("subject");
        i.roomId = o.getLong("roomId");
        i.message = o.optString("message");
        i.valid = Invitation.Valid.valueOf(o.optString("valid", Invitation.Valid.PERIOD.name()));
        i.validFrom = o.optString("validFrom");
        i.validTo = o.optString("validTo");
        return i;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

