/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthLevelUtil {
    private static final Logger log = LoggerFactory.getLogger(AuthLevelUtil.class);

    private AuthLevelUtil() {
    }

    public static boolean check(Set<User.Right> rights, User.Right level) {
        boolean result = rights.contains((Object)level);
        log.debug(String.format("Level %s :: %s", new Object[]{level, result ? "[GRANTED]" : "[DENIED]"}));
        return result;
    }

    public static boolean hasUserLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.ROOM);
    }

    public static Set<Room.Right> getRoomRight(User u, Room r, Appointment a, int userCount) {
        HashSet<Room.Right> result = new HashSet<Room.Right>();
        if (u == null) {
            return result;
        }
        if (AuthLevelUtil.hasAdminLevel(u.getRights())) {
            result.add(Room.Right.SUPER_MODERATOR);
        } else if (r.isAppointment() && a != null && u.getId().equals(a.getOwner().getId())) {
            result.add(Room.Right.SUPER_MODERATOR);
        }
        if (result.isEmpty()) {
            if (!r.isModerated() && 1 == userCount) {
                result.add(Room.Right.MODERATOR);
            }
            for (RoomModerator rm : r.getModerators()) {
                if (!u.getId().equals(rm.getUser().getId())) continue;
                result.add(rm.isSuperModerator() ? Room.Right.SUPER_MODERATOR : Room.Right.MODERATOR);
                break;
            }
            if (result.isEmpty() && r.getGroups() != null && !r.getGroups().isEmpty()) {
                for (RoomGroup rg : r.getGroups()) {
                    for (GroupUser gu : u.getGroupUsers()) {
                        if (!gu.getGroup().getId().equals(rg.getGroup().getId()) || !gu.isModerator()) continue;
                        result.add(Room.Right.MODERATOR);
                        break;
                    }
                    if (result.isEmpty()) continue;
                    break;
                }
            }
        }
        if (!(Room.Type.CONFERENCE != r.getType() || result.contains((Object)Room.Right.SUPER_MODERATOR) || result.contains((Object)Room.Right.MODERATOR) || result.contains((Object)Room.Right.VIDEO))) {
            result.add(Room.Right.AUDIO);
            result.add(Room.Right.VIDEO);
        }
        return result;
    }

    public static boolean hasAdminLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.ADMIN);
    }

    public static boolean hasGroupAdminLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.GROUP_ADMIN);
    }

    public static boolean hasWebServiceLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.SOAP);
    }

    public static boolean hasLoginLevel(Set<User.Right> rights) {
        return AuthLevelUtil.check(rights, User.Right.LOGIN);
    }
}

