/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.util.DaoHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class OmCalendarDao
implements IDataProviderDao<OmCalendar> {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private AppointmentDao appointmentDao;

    public List<OmCalendar> get() {
        return this.em.createNamedQuery("getCalendars", OmCalendar.class).getResultList();
    }

    @Override
    public OmCalendar get(Long calId) {
        List list = this.em.createNamedQuery("getCalendarbyId", OmCalendar.class).setParameter("calId", (Object)calId).getResultList();
        return list.size() == 1 ? (OmCalendar)list.get(0) : null;
    }

    public List<OmCalendar> getByUser(Long userId) {
        return this.em.createNamedQuery("getCalendarbyUser", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public List<OmCalendar> getGoogleCalendars(Long userId) {
        return this.em.createNamedQuery("getGoogleCalendars", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public OmCalendar update(OmCalendar c) {
        if (c.getId() == null) {
            this.em.persist((Object)c);
        } else {
            c = (OmCalendar)this.em.merge((Object)c);
        }
        return c;
    }

    public void delete(OmCalendar c) {
        c.setDeleted(true);
        this.appointmentDao.deletebyCalendar(c.getId());
        this.update(c);
    }

    @Override
    public List<OmCalendar> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<OmCalendar> get(String search, long start, long count, String order) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public OmCalendar update(OmCalendar entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public void delete(OmCalendar entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }
}

