/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.ExtraMenu;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.util.DaoHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ExtraMenuDao
implements IGroupAdminDataProviderDao<ExtraMenu> {
    public static final String[] searchFields = new String[]{"name", "link", "description"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    @Override
    public ExtraMenu get(Long id) {
        return (ExtraMenu)DaoHelper.single(this.em.createNamedQuery("getExtraMenuById", ExtraMenu.class).getResultList());
    }

    @Override
    public ExtraMenu get(long id) {
        return this.get((Long)id);
    }

    @Override
    public List<ExtraMenu> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getExtraMenus", ExtraMenu.class), start, count).getResultList();
    }

    @Override
    public List<ExtraMenu> get(String search, long start, long count, String order) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("ExtraMenu", "m", search, false, false, order, searchFields), ExtraMenu.class), start, count).getResultList();
    }

    public List<ExtraMenu> getByGroups(List<Long> groups) {
        return this.em.createNamedQuery("getExtraMenuByGroups", ExtraMenu.class).setParameter("ids", groups).getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countExtraMenus", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return (Long)this.em.createQuery(DaoHelper.getSearchQuery("ExtraMenu", "m", search, false, true, null, searchFields), Long.class).getSingleResult();
    }

    @Override
    public ExtraMenu update(ExtraMenu entity, Long userId) {
        if (entity.getId() == null) {
            this.em.persist((Object)entity);
        } else {
            entity = (ExtraMenu)this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(ExtraMenu entity, Long userId) {
        this.em.remove((Object)entity);
    }

    @Override
    public List<ExtraMenu> adminGet(String search, Long adminId, long start, long count, String order) {
        String additionalWhere = this.getGroupFilter(adminId);
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("ExtraMenu", "m", null, search, false, false, additionalWhere, order, searchFields), ExtraMenu.class), start, count).getResultList();
    }

    @Override
    public long adminCount(String search, Long adminId) {
        String additionalWhere = this.getGroupFilter(adminId);
        return (Long)this.em.createQuery(DaoHelper.getSearchQuery("ExtraMenu", "m", null, search, false, true, additionalWhere, null, searchFields), Long.class).getSingleResult();
    }

    private String getGroupFilter(Long adminId) {
        return this.userDao.get(adminId).getGroupUsers().stream().filter(GroupUser::isModerator).map(GroupUser::getGroup).map(Group::getId).map(String::valueOf).collect(Collectors.joining(", ", "m.groups IN (", ")"));
    }
}

