/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.label;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.label.OmLanguage;
import org.apache.openmeetings.db.entity.label.StringLabel;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.db.util.XmlHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.XmlExport;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelDao
implements IDataProviderDao<StringLabel> {
    private static final Logger log = LoggerFactory.getLogger(LabelDao.class);
    private static final String RANGE_START = "rangeStart";
    private static final String RANGE_END = "rangeEnd";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ATTR = "key";
    public static final String APP_RESOURCES_PREFIX = "Application";
    public static final String APP_RESOURCES_SUFFIX = ".properties.xml";
    private static final OmLanguage LNG_ENGLISH = new OmLanguage(1L, Locale.ENGLISH);
    private static final LinkedHashMap<Long, OmLanguage> languages = new LinkedHashMap();
    private static final ConcurrentHashMap<Locale, List<StringLabel>> labelCache = new ConcurrentHashMap();
    private static final Set<String> keys = new HashSet<String>();
    private static Class<?> appClass = null;

    private static void storeLanguages() throws Exception {
        Document d = XmlExport.createDocument();
        Element r = XmlExport.createRoot((Document)d, (String)"language");
        for (Map.Entry<Long, OmLanguage> e : languages.entrySet()) {
            r.addElement("lang").addAttribute("id", "" + e.getKey()).addAttribute("code", e.getValue().getLocale().toLanguageTag()).addAttribute("tip", e.getValue().getTip()).addAttribute(RANGE_START, "" + e.getValue().getRangeStart()).addAttribute(RANGE_END, "" + e.getValue().getRangeEnd());
        }
        XmlExport.toXml((File)LabelDao.getLangFile(), (Document)d);
    }

    public static void add(Locale l) throws Exception {
        long id = 0L;
        for (Map.Entry<Long, OmLanguage> e : languages.entrySet()) {
            id = e.getKey();
        }
        languages.put(id + 1L, new OmLanguage(id + 1L, l));
        LabelDao.storeLanguages();
        labelCache.put(l, new ArrayList());
    }

    public static String getString(String key, long langId) {
        return ApplicationHelper.ensureApplication().getOmString(key, langId);
    }

    private static File getLangFile() {
        return new File(OmFileHelper.getLanguagesDir(), "languages.xml");
    }

    public static void initLanguageMap() {
        try {
            SAXReader reader = XmlHelper.createSaxReader();
            appClass = OpenmeetingsVariables.getAppClass();
            Document document = reader.read(LabelDao.getLangFile());
            Element root = document.getRootElement();
            languages.clear();
            Iterator it = root.elementIterator("lang");
            while (it.hasNext()) {
                Element item = (Element)it.next();
                Long id = Long.valueOf(item.attributeValue("id"));
                String code = item.attributeValue("code");
                if (id == 3L) continue;
                languages.put(id, new OmLanguage(id, Locale.forLanguageTag(code)).setTip(item.attributeValue("tip")).setRangeStart(Optional.ofNullable(item.attributeValue(RANGE_START)).map(s -> Character.valueOf(s.charAt(0))).orElse(Character.valueOf('A')).charValue()).setRangeEnd(Optional.ofNullable(item.attributeValue(RANGE_END)).map(s -> Character.valueOf(s.charAt(0))).orElse(Character.valueOf('Z')).charValue()));
            }
        }
        catch (Exception e) {
            log.error("Error while building language map");
        }
    }

    public static String getLabelFileName(Locale l) {
        String name = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES).toBundleName(APP_RESOURCES_PREFIX, Locale.ENGLISH.equals(l) ? Locale.ROOT : l);
        return String.format("%s%s", name, APP_RESOURCES_SUFFIX);
    }

    private static void storeLabels(Locale l) throws Exception {
        Document d = XmlExport.createDocument();
        Element r = XmlExport.createRoot((Document)d);
        ArrayList labels = new ArrayList(labelCache.get(l));
        Collections.sort(labels, new LabelComparator());
        for (StringLabel sl : labels) {
            r.addElement(ENTRY_ELEMENT).addAttribute(KEY_ATTR, (String)sl.getKey()).addCDATA((String)sl.getValue());
        }
        URL u = appClass.getResource(LabelDao.getLabelFileName(l));
        XmlExport.toXml((File)new File(u.toURI()), (Document)d);
    }

    public static void upload(Locale l, InputStream is) throws Exception {
        List<StringLabel> labels = LabelDao.getLabels(is);
        URL u = appClass.getResource(LabelDao.getLabelFileName(Locale.ENGLISH));
        File el = new File(u.toURI());
        File f = new File(el.getParentFile(), LabelDao.getLabelFileName(l));
        if (!f.exists()) {
            f.createNewFile();
        }
        labelCache.put(l, labels);
        LabelDao.storeLabels(l);
    }

    private static List<StringLabel> getLabels(Locale l) {
        List<StringLabel> labels = new ArrayList<StringLabel>();
        try (InputStream is = appClass.getResourceAsStream(LabelDao.getLabelFileName(l));){
            labels = LabelDao.getLabels(is);
        }
        catch (Exception e) {
            log.error("Error reading resources document", (Throwable)e);
        }
        return labels;
    }

    private static List<StringLabel> getLabels(InputStream is) throws IOException {
        ArrayList<StringLabel> labels = new ArrayList<StringLabel>();
        Properties props = new Properties();
        props.loadFromXML(is);
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> labels.add(new StringLabel((String)k, (String)v))));
        return labels;
    }

    private static List<StringLabel> getLabels(Locale l, String search) {
        if (!labelCache.containsKey(l)) {
            List<StringLabel> ll = LabelDao.getLabels(l);
            labelCache.putIfAbsent(l, ll);
        }
        ArrayList<StringLabel> result = new ArrayList<StringLabel>(labelCache.containsKey(l) ? (Collection)labelCache.get(l) : new ArrayList());
        if (!Strings.isEmpty((String)search)) {
            CollectionUtils.filter(result, o -> o != null && (((String)o.getKey()).contains(search) || ((String)o.getValue()).contains(search)));
        }
        return result;
    }

    @Override
    public StringLabel get(long id) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public StringLabel get(Long id) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<StringLabel> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<StringLabel> get(String search, long start, long count, SortParam<String> order) {
        throw DaoHelper.UNSUPPORTED;
    }

    public static OmLanguage getLanguage(Long id) {
        return languages.getOrDefault(id == null ? 1L : id, LNG_ENGLISH);
    }

    public static Locale getLocale(Long id) {
        return LabelDao.getLanguage(id).getLocale();
    }

    public static OmLanguage getOmLanguage(Locale loc, Long def) {
        Optional<OmLanguage> lang = languages.entrySet().stream().map(Map.Entry::getValue).filter(l -> l.getLocale().equals(loc) || Locale.forLanguageTag(l.getLocale().getCountry()).equals(loc)).findFirst();
        return lang.orElse(LabelDao.getLanguage(def));
    }

    public static Long getLanguage(Locale loc, Long def) {
        return LabelDao.getOmLanguage(loc, def).getId();
    }

    public static Set<Map.Entry<Long, Locale>> getLanguages() {
        return languages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((OmLanguage)e.getValue()).getLocale())).entrySet();
    }

    public static List<StringLabel> get(Locale l, String search, long start, long count, SortParam<String> sort) {
        List<StringLabel> result = LabelDao.getLabels(l, search);
        if (sort != null) {
            Collections.sort(result, new LabelComparator(sort));
        }
        return result.subList((int)start, (int)(start + count > (long)result.size() ? (long)result.size() : start + count));
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }

    public static long count(Locale l, String search) {
        return LabelDao.getLabels(l, search).size();
    }

    @Override
    public StringLabel update(StringLabel entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    public static StringLabel update(Locale l, StringLabel entity) throws Exception {
        List<StringLabel> labels = labelCache.get(l);
        if (!labels.contains(entity)) {
            labels.add(entity);
            keys.add((String)entity.getKey());
        }
        LabelDao.storeLabels(l);
        return entity;
    }

    @Override
    public void delete(StringLabel entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    public static void delete(Locale l, StringLabel entity) throws Exception {
        List<StringLabel> labels = labelCache.get(l);
        if (labels.contains(entity)) {
            labels.remove(entity);
            keys.remove(entity.getKey());
            LabelDao.storeLabels(l);
        }
    }

    public static void delete(Locale l) {
        for (Map.Entry<Long, OmLanguage> e : languages.entrySet()) {
            if (!e.getValue().getLocale().equals(l)) continue;
            languages.remove(e.getKey());
            break;
        }
        labelCache.remove(l);
        try {
            File f;
            URL u = appClass.getResource(LabelDao.getLabelFileName(l));
            if (u != null && (f = new File(u.toURI())).exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            log.error("Unexpected error while deleting language", (Throwable)e);
        }
    }

    private static class LabelComparator
    implements Comparator<StringLabel>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final SortParam<String> sort;

        LabelComparator() {
            this.sort = new SortParam((Object)LabelDao.KEY_ATTR, true);
        }

        LabelComparator(SortParam<String> sort) {
            this.sort = sort;
        }

        @Override
        public int compare(StringLabel o1, StringLabel o2) {
            int val;
            if (LabelDao.KEY_ATTR.equals(this.sort.getProperty())) {
                try {
                    int i1 = Integer.parseInt((String)o1.getKey());
                    int i2 = Integer.parseInt((String)o2.getKey());
                    val = i1 - i2;
                }
                catch (Exception e) {
                    val = ((String)o1.getKey()).compareTo((String)o2.getKey());
                }
            } else {
                val = ((String)o1.getValue()).compareTo((String)o2.getValue());
            }
            return (this.sort.isAscending() ? 1 : -1) * val;
        }
    }
}

