/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class InvitationDao
implements IDataProviderDao<Invitation> {
    private static final List<String> searchFields = List.of("invitee.firstname", "invitee.lastname", "invitee.login");
    private static final Logger log = LoggerFactory.getLogger(InvitationDao.class);
    @PersistenceContext
    private EntityManager em;

    @Override
    public Invitation get(Long invId) {
        List list = this.em.createNamedQuery("getInvitationbyId", Invitation.class).setParameter("id", (Object)invId).getResultList();
        return list.size() == 1 ? (Invitation)list.get(0) : null;
    }

    @Override
    public List<Invitation> get(long start, long count) {
        return this.get(null, start, count, null);
    }

    @Override
    public List<Invitation> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, Invitation.class, false, search, searchFields, true, null, sort, start, count);
    }

    @Override
    public long count() {
        return this.count(null);
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, Invitation.class, search, searchFields, true, null);
    }

    private Predicate getGroupFilter(Long userId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Subquery subquery = query.subquery(Long.class);
        Root root = subquery.from(GroupUser.class);
        subquery.select((Expression)root.get("user").get("id"));
        subquery.where((Expression)builder.in((Expression)root.get("group").get("id")).value(DaoHelper.groupAdminQuery(userId, builder, subquery)));
        Root<Invitation> mainRoot = DaoHelper.getRoot(query, Invitation.class);
        return builder.in((Expression)mainRoot.get("invitedBy").get("id")).value((Expression)subquery);
    }

    public List<Invitation> getGroup(String search, long start, long count, Long userId, SortParam<String> sort) {
        return DaoHelper.get(this.em, Invitation.class, false, search, searchFields, true, (builder, query) -> this.getGroupFilter(userId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query), sort, start, count);
    }

    public long countGroup(String search, Long userId) {
        return DaoHelper.count(this.em, Invitation.class, search, searchFields, true, (builder, query) -> this.getGroupFilter(userId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query));
    }

    private Predicate getUserFilter(Long userId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<Invitation> root = DaoHelper.getRoot(query, Invitation.class);
        return builder.equal((Expression)root.get("invitedBy").get("id"), (Object)userId);
    }

    public List<Invitation> getUser(String search, long start, long count, Long userId, SortParam<String> sort) {
        return DaoHelper.get(this.em, Invitation.class, false, search, searchFields, true, (builder, query) -> this.getUserFilter(userId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query), sort, start, count);
    }

    public long countUser(String search, Long userId) {
        return DaoHelper.count(this.em, Invitation.class, search, searchFields, true, (builder, query) -> this.getUserFilter(userId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query));
    }

    public Invitation update(Invitation invitation) {
        invitation.setInvitedBy((User)this.em.find(User.class, (Object)invitation.getInvitedBy().getId()));
        if (invitation.getRoom() != null) {
            invitation.setRoom((Room)this.em.find(Room.class, (Object)invitation.getRoom().getId()));
        }
        if (invitation.getRecording() != null) {
            invitation.setRecording((Recording)this.em.find(Recording.class, (Object)invitation.getRecording().getId()));
        }
        if (invitation.getId() == null) {
            this.em.persist((Object)invitation);
        } else {
            invitation = (Invitation)this.em.merge((Object)invitation);
        }
        return invitation;
    }

    @Override
    public Invitation update(Invitation entity, Long userId) {
        return this.update(entity);
    }

    @Override
    public void delete(Invitation entity, Long userId) {
        entity.setDeleted(true);
        this.update(entity, userId);
    }

    public void markUsed(Invitation i) {
        if (Invitation.Valid.ONE_TIME == i.getValid()) {
            i.setUsed(true);
            this.update(i);
            this.em.flush();
        }
    }

    public Invitation getByHash(String hash, boolean hidePass) {
        Invitation i;
        List list = this.em.createNamedQuery("getInvitationByHashCode", Invitation.class).setParameter("hashCode", (Object)hash).getResultList();
        Invitation invitation = i = list != null && list.size() == 1 ? (Invitation)list.get(0) : null;
        if (i != null) {
            switch (i.getValid()) {
                case ONE_TIME: {
                    i.setAllowEntry(!i.isUsed());
                    break;
                }
                case PERIOD: {
                    String tzId = i.getInvitee().getTimeZoneId();
                    if (Strings.isEmpty((String)tzId) && i.getAppointment() != null) {
                        log.warn("User with NO timezone found: {}", (Object)i.getInvitee().getId());
                        tzId = i.getAppointment().getOwner().getTimeZoneId();
                    }
                    if (Strings.isEmpty((String)tzId)) {
                        log.warn("Unable to obtain valid timezone, setting SYSTEM TZ");
                        tzId = TimeZone.getDefault().getID();
                    }
                    LocalDateTime now = ZonedDateTime.now(CalendarHelper.getZoneId((String)tzId)).toLocalDateTime();
                    LocalDateTime from = CalendarHelper.getDateTime((Date)i.getValidFrom(), (String)tzId);
                    LocalDateTime to = CalendarHelper.getDateTime((Date)i.getValidTo(), (String)tzId);
                    i.setAllowEntry(now.isAfter(from) && now.isBefore(to));
                    break;
                }
                default: {
                    i.setAllowEntry(true);
                }
            }
            this.em.detach((Object)i);
            if (hidePass) {
                i.setPassword(null);
            }
        }
        return i;
    }
}

