/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class LdapConfigDao
implements IDataProviderDao<LdapConfig> {
    private static final Logger log = LoggerFactory.getLogger(LdapConfigDao.class);
    private static final List<String> searchFields = List.of("name", "configFileName", "domain", "comment");
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    @Override
    public LdapConfig get(Long id) {
        List list = this.em.createNamedQuery("getLdapConfigById", LdapConfig.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (LdapConfig)list.get(0) : null;
    }

    public List<LdapConfig> getActive() {
        log.debug("getActiveLdapConfigs");
        TypedQuery query = this.em.createNamedQuery("getActiveLdapConfigs", LdapConfig.class);
        query.setParameter("isActive", (Object)true);
        return query.getResultList();
    }

    public List<LdapConfig> get() {
        LdapConfig ldapConfig = new LdapConfig();
        ldapConfig.setName("local DB [internal]");
        ldapConfig.setId(-1L);
        ArrayList<LdapConfig> result = new ArrayList<LdapConfig>();
        result.add(ldapConfig);
        result.addAll(this.getActive());
        return result;
    }

    @Override
    public List<LdapConfig> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedLdapConfigs", LdapConfig.class), start, count).getResultList();
    }

    @Override
    public List<LdapConfig> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, LdapConfig.class, false, search, searchFields, true, null, sort, start, count);
    }

    @Override
    public long count() {
        try {
            TypedQuery query = this.em.createNamedQuery("countNondeletedLdapConfigs", Long.class);
            List ll = query.getResultList();
            log.debug("selectMaxFromLdapConfig {}", ll.get(0));
            return (Long)ll.get(0);
        }
        catch (Exception ex2) {
            log.error("[selectMaxFromLdapConfig] ", (Throwable)ex2);
            return 0L;
        }
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, LdapConfig.class, search, searchFields, true, null);
    }

    @Override
    public LdapConfig update(LdapConfig entity, Long userId) {
        try {
            entity.setDeleted(false);
            if (entity.getId() == null) {
                if (userId != null) {
                    entity.setInsertedby(this.userDao.get(userId));
                }
                this.em.persist((Object)entity);
            } else {
                if (userId != null) {
                    entity.setUpdatedby(this.userDao.get(userId));
                }
                entity = (LdapConfig)this.em.merge((Object)entity);
            }
        }
        catch (PersistenceException ex) {
            log.error("[update LdapConfig]", (Throwable)ex);
        }
        return entity;
    }

    @Override
    public void delete(LdapConfig entity, Long userId) {
        if (entity.getId() != null) {
            if (userId != null) {
                entity.setUpdatedby(this.userDao.get(userId));
            }
            entity.setDeleted(true);
            this.em.merge((Object)entity);
        }
    }
}

