/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.AsteriskSipUser;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.crypt.ICrypt;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UserDao
implements IGroupAdminDataProviderDao<User> {
    private static final Logger log = LoggerFactory.getLogger(UserDao.class);
    private static final String PARAM_EMAIL = "email";
    private static final List<String> searchFields = List.of("lastname", "firstname", "login", "address.email", "address.town");
    private static final List<String> guSearchFields = searchFields.stream().map(f -> "user." + f).toList();
    private static final String FIELD_GROUP = "group";
    public static final String FETCH_GROUP_GROUP = "Group_Users";
    public static final String FETCH_GROUP_BACKUP = "Backup_Export";
    @PersistenceContext
    private EntityManager em;

    public static Set<User.Right> getDefaultRights() {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        rights.add(User.Right.LOGIN);
        rights.add(User.Right.DASHBOARD);
        rights.add(User.Right.ROOM);
        return rights;
    }

    public static User getNewUserInstance(User currentUser) {
        User user = new User();
        user.setRights(UserDao.getDefaultRights());
        user.setLanguageId(OpenmeetingsVariables.getDefaultLang());
        user.setTimeZoneId(TimezoneUtil.getTimeZone(currentUser).getID());
        user.setLastlogin(new Date());
        Address address = new Address();
        address.setCountry(Locale.getDefault().getCountry());
        user.setAddress(address);
        user.setShowContactData(false);
        user.setShowContactDataToContacts(false);
        return user;
    }

    @Override
    public List<User> get(long first, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedUsers", User.class), first, count).getResultList();
    }

    private Predicate getContactsFilter(CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<User> root = DaoHelper.getRoot(query, User.class);
        return builder.notEqual((Expression)root.get("type"), (Object)User.Type.CONTACT);
    }

    private Predicate getOwnerContactsFilter(Long ownerId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<User> root = DaoHelper.getRoot(query, User.class);
        root.join("groupUsers", JoinType.LEFT);
        Subquery subquery = query.subquery(Long.class);
        Root subRoot = subquery.from(GroupUser.class);
        subquery.select((Expression)subRoot.get(FIELD_GROUP).get("id"));
        subquery.where((Expression)builder.equal((Expression)subRoot.get("user").get("id"), (Object)ownerId));
        return builder.or((Expression)builder.and((Expression)builder.notEqual((Expression)root.get("type"), (Object)User.Type.CONTACT), (Expression)root.get("groupUsers").get(FIELD_GROUP).get("id").in(new Expression[]{subquery})), (Expression)builder.and((Expression)builder.equal((Expression)root.get("type"), (Object)User.Type.CONTACT), (Expression)builder.equal((Expression)root.get("ownerId"), (Object)ownerId)));
    }

    private List<User> get(String search, Long start, Long count, SortParam<String> sort, boolean filterContacts, Long currentUserId, boolean filterDeleted) {
        if (filterContacts) {
            return DaoHelper.get(this.em, User.class, true, search, searchFields, true, (b, q) -> this.getOwnerContactsFilter(currentUserId, (CriteriaBuilder)b, (CriteriaQuery<?>)q), sort, start, count);
        }
        return DaoHelper.get(this.em, User.class, false, search, searchFields, filterDeleted, null, sort, start, count);
    }

    public List<User> get(String search, boolean excludeContacts, long start, long count) {
        return DaoHelper.get(this.em, User.class, false, search, searchFields, true, excludeContacts ? this::getContactsFilter : null, null, start, count);
    }

    public List<User> get(String search, long start, long count, SortParam<String> sort, boolean filterContacts, Long currentUserId) {
        return this.get(search, start, count, sort, filterContacts, currentUserId, true);
    }

    @Override
    public List<User> adminGet(String search, long start, long count, SortParam<String> sort) {
        return this.get(search, start, count, sort, false, null, false);
    }

    private Predicate getAdminFilter(Long adminId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<GroupUser> root = DaoHelper.getRoot(query, GroupUser.class);
        return builder.in((Expression)root.get(FIELD_GROUP).get("id")).value(DaoHelper.groupAdminQuery(adminId, builder, query));
    }

    @Override
    public List<User> adminGet(String search, Long adminId, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, GroupUser.class, User.class, (builder, root) -> root.get("user"), true, search, guSearchFields, false, (b, q) -> this.getAdminFilter(adminId, (CriteriaBuilder)b, (CriteriaQuery<?>)q), sort, start, count);
    }

    private Predicate getProfileFilter(Long userId, String userOffers, String userSearches, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<User> root = DaoHelper.getRoot(query, User.class);
        Predicate result = this.getOwnerContactsFilter(userId, builder, query);
        if (!Strings.isEmpty((String)userOffers)) {
            result = builder.and((Expression)result, (Expression)DaoHelper.like("userOffers", DaoHelper.getStringParam(userOffers), builder, root));
        }
        if (!Strings.isEmpty((String)userSearches)) {
            result = builder.and((Expression)result, (Expression)DaoHelper.like("userSearches", DaoHelper.getStringParam(userSearches), builder, root));
        }
        return result;
    }

    public List<User> searchUserProfile(Long userId, String search, String userOffers, String userSearches, SortParam<String> sort, long start, long count) {
        return DaoHelper.get(this.em, User.class, true, search, searchFields, true, (b, q) -> this.getProfileFilter(userId, userOffers, userSearches, (CriteriaBuilder)b, (CriteriaQuery<?>)q), sort, start, count);
    }

    private long count(String search, boolean filterContacts, Long currentUserId, boolean filterDeleted) {
        if (filterContacts) {
            return DaoHelper.count(this.em, User.class, CriteriaBuilder::countDistinct, search, searchFields, filterDeleted, (b, q) -> this.getOwnerContactsFilter(currentUserId, (CriteriaBuilder)b, (CriteriaQuery<?>)q));
        }
        return DaoHelper.count(this.em, User.class, search, searchFields, filterDeleted, null);
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countNondeletedUsers", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return this.count(search, false, -1L);
    }

    public long countUsers(String search, Long currentUserId) {
        return this.count(search, false, currentUserId);
    }

    public long count(String search, boolean filterContacts, Long currentUserId) {
        return this.count(search, filterContacts, currentUserId, true);
    }

    @Override
    public long adminCount(String search) {
        return this.count(search, false, -1L, false);
    }

    @Override
    public long adminCount(String search, Long adminId) {
        return DaoHelper.count(this.em, GroupUser.class, (builder, root) -> builder.countDistinct((Expression)root.get("user")), search, guSearchFields, false, (b, q) -> this.getAdminFilter(adminId, (CriteriaBuilder)b, (CriteriaQuery<?>)q));
    }

    public Long searchCountUserProfile(Long userId, String search, String userOffers, String userSearches) {
        return DaoHelper.count(this.em, User.class, CriteriaBuilder::countDistinct, search, searchFields, true, (b, q) -> this.getProfileFilter(userId, userOffers, userSearches, (CriteriaBuilder)b, (CriteriaQuery<?>)q));
    }

    @Override
    public User update(User u, Long userId) {
        if (u.getId() == null) {
            if (u.getRegdate() == null) {
                u.setRegdate(new Date());
            }
            this.em.persist((Object)u);
        } else {
            u = (User)this.em.merge((Object)u);
        }
        return u;
    }

    public User resetPassword(User u, String password) throws NoSuchAlgorithmException {
        if (u != null) {
            u.setResethash(null);
            u = this.update(u, password, u.getId());
        }
        return u;
    }

    private User updatePassword(Long id, String pwd, Long updatedBy) throws NoSuchAlgorithmException {
        User u = this.get(id, true);
        u.updatePassword(pwd);
        return this.update(u, updatedBy);
    }

    public User update(User user, String password, Long updatedBy) throws NoSuchAlgorithmException {
        User u = this.update(user, updatedBy);
        if (u != null && !Strings.isEmpty((String)password)) {
            u = this.updatePassword(u.getId(), password, updatedBy);
        }
        return u;
    }

    @Override
    public User get(Long id) {
        return this.get(id, false);
    }

    private User get(Long id, boolean force) {
        User u = null;
        if (id != null && id > 0L) {
            ArrayList<String> groups = new ArrayList<String>(2);
            groups.add(FETCH_GROUP_GROUP);
            if (force) {
                groups.add(FETCH_GROUP_BACKUP);
            }
            u = (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getUserById", User.class).setParameter("id", (Object)id), groups.toArray(new String[groups.size()])));
        } else {
            log.info("[get]: No user id given");
        }
        return u;
    }

    @Override
    public void delete(User u, Long userId) {
        if (u != null && u.getId() != null) {
            u.setGroupUsers(new ArrayList<GroupUser>());
            u.setDeleted(true);
            u.setSipUser(null);
            Address adr = u.getAddress();
            if (adr != null) {
                adr.setDeleted(true);
            }
            this.update(u, userId);
        }
    }

    public void purge(User u, Long userId) {
        if (u != null && u.getId() != null) {
            this.em.createNamedQuery("purgeChatUserName").setParameter("purged", (Object)"Purged User").setParameter("userId", (Object)u.getId()).executeUpdate();
            this.em.createNamedQuery("clearLogUserIpByUser").setParameter("userId", (Object)u.getId()).executeUpdate();
            if (!Strings.isEmpty((String)u.getAddress().getEmail())) {
                this.em.createNamedQuery("purgeMailMessages").setParameter(PARAM_EMAIL, (Object)String.format("%%%s%%", u.getAddress().getEmail())).executeUpdate();
            }
            u.setActivatehash(null);
            u.setResethash(null);
            u.setDeleted(true);
            u.setSipUser(new AsteriskSipUser());
            u.setAddress(new Address());
            u.setAge(LocalDate.now());
            u.setExternalId(null);
            String purged = String.format("Purged %s", UUID.randomUUID());
            u.setFirstname(purged);
            u.setLastname(purged);
            u.setLogin(purged);
            u.setGroupUsers(new ArrayList<GroupUser>());
            u.setRights(new HashSet<User.Right>());
            u.setTimeZoneId(OpenmeetingsVariables.getDefaultTimezone());
            File pic = OmFileHelper.getUserProfilePicture((Long)u.getId(), (String)u.getPictureUri(), null);
            u.setPictureUri(null);
            ICrypt crypt = CryptProvider.get();
            try {
                u.updatePassword(crypt.randomPassword(25));
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unexpected exception while updating password");
            }
            this.update(u, userId);
            if (pic != null) {
                pic.delete();
            }
        }
    }

    public List<User> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getUsersByIds", User.class).setParameter("ids", ids).getResultList();
    }

    public List<User> getAllUsers() {
        return DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getNondeletedUsers", User.class), FETCH_GROUP_GROUP);
    }

    public List<User> getAllBackupUsers() {
        return DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getAllUsers", User.class), FETCH_GROUP_BACKUP, FETCH_GROUP_GROUP);
    }

    public boolean checkLogin(String login, User.Type type, Long domainId, Long id) {
        User u = this.getByLogin(login, type, domainId);
        return u == null || u.getId().equals(id);
    }

    public boolean checkEmail(String email, User.Type type, Long domainId, Long id) {
        log.debug("checkEmail: email = {}, id = {}", (Object)email, (Object)id);
        User u = this.getByEmail(email, type, domainId);
        return u == null || u.getId().equals(id);
    }

    public boolean validLogin(String login) {
        return !Strings.isEmpty((String)login) && login.length() >= OpenmeetingsVariables.getMinLoginLength();
    }

    public User getByLogin(String login, User.Type type, Long domainId) {
        return (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getUserByLogin", User.class).setParameter("login", (Object)login).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)), FETCH_GROUP_GROUP));
    }

    public User getByEmail(String email) {
        return this.getByEmail(email, User.Type.USER, null);
    }

    public User getByEmail(String email, User.Type type, Long domainId) {
        return (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getUserByEmail", User.class).setParameter(PARAM_EMAIL, (Object)email).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)), FETCH_GROUP_GROUP));
    }

    public User getUserByHash(String hash) {
        if (Strings.isEmpty((String)hash)) {
            return null;
        }
        return (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getUserByHash", User.class).setParameter("resethash", (Object)hash).setParameter("type", (Object)User.Type.USER), FETCH_GROUP_GROUP));
    }

    public Long selectMaxFromUsersWithSearch(String search) {
        try {
            TypedQuery query = this.em.createNamedQuery("selectMaxFromUsersWithSearch", Long.class);
            query.setParameter("search", (Object)StringUtils.lowerCase((String)search, (Locale)Locale.ROOT));
            List ll = query.getResultList();
            log.info("selectMaxFromUsers {}", ll.get(0));
            return (Long)ll.get(0);
        }
        catch (Exception ex2) {
            log.error("[selectMaxFromUsers] ", (Throwable)ex2);
            return null;
        }
    }

    public boolean verifyPassword(Long userId, String password) {
        List l = this.em.createNamedQuery("getPassword", String.class).setParameter("userId", (Object)userId).getResultList();
        if (l == null || l.size() != 1) {
            return false;
        }
        String hash = (String)l.get(0);
        ICrypt crypt = CryptProvider.get();
        if (crypt.verify(password, hash)) {
            return true;
        }
        if (crypt.fallback(password, hash)) {
            log.warn("Password for user with ID {} crypted with outdated Crypt, updating ...", (Object)userId);
            try {
                User u = this.updatePassword(userId, password, userId);
                log.warn("Password for user {} updated successfully", (Object)u);
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unexpected exception while updating password");
            }
        }
        return false;
    }

    public User getContact(String email, Long ownerId) {
        return this.getContact(email, "", "", ownerId);
    }

    public User getContact(String email, User owner) {
        return this.getContact(email, "", "", null, null, owner);
    }

    public User getContact(String email, String firstName, String lastName, Long ownerId) {
        return this.getContact(email, firstName, lastName, null, null, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, Long ownerId) {
        return this.getContact(email, firstName, lastName, langId, tzId, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, User owner) {
        List list = this.em.createNamedQuery("getContactByEmailAndUser", User.class).setParameter(PARAM_EMAIL, (Object)email).setParameter("type", (Object)User.Type.CONTACT).setParameter("ownerId", (Object)owner.getId()).getResultList();
        if (list.isEmpty()) {
            User to = new User();
            to.setType(User.Type.CONTACT);
            String login = owner.getId() + "_" + email;
            to.setLogin((String)(login.length() < OpenmeetingsVariables.getMinLoginLength() ? UUID.randomUUID().toString() : login));
            to.setFirstname(firstName);
            to.setLastname(lastName);
            to.setLanguageId(null == langId || null == LabelDao.getLocale(langId) ? owner.getLanguageId() : langId.longValue());
            to.setOwnerId(owner.getId());
            to.setAddress(new Address());
            to.getAddress().setEmail(email);
            to.setTimeZoneId(Strings.isEmpty((String)tzId) ? owner.getTimeZoneId() : tzId);
            return to;
        }
        return (User)list.get(0);
    }

    public User getByActivationHash(String hash) {
        return (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createQuery("SELECT u FROM User as u WHERE u.activatehash = :activatehash AND u.deleted = false", User.class).setParameter("activatehash", (Object)hash), FETCH_GROUP_GROUP));
    }

    public User getExternalUser(String extId, String extType) {
        return (User)DaoHelper.single(DaoHelper.fillLazy(this.em, oem -> oem.createNamedQuery("getExternalUser", User.class).setParameter("externalId", (Object)extId).setParameter("externalType", (Object)extType).setParameter("type", (Object)User.Type.EXTERNAL), FETCH_GROUP_GROUP));
    }

    @Override
    public List<User> get(String search, long start, long count, SortParam<String> sort) {
        return this.get(search, start, count, sort, false, -1L);
    }

    public Set<User.Right> getRights(Long id) {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        if (id == null) {
            return rights;
        }
        if (id < 0L) {
            rights.add(User.Right.ROOM);
            return rights;
        }
        User u = this.get(id);
        if (u != null) {
            return u.getRights();
        }
        return rights;
    }

    public User login(String userOrEmail, String userpass) throws OmException {
        List users = this.em.createNamedQuery("getUserByLoginOrEmail", User.class).setParameter("userOrEmail", (Object)userOrEmail).setParameter("type", (Object)User.Type.USER).getResultList();
        log.debug("login:: {} users were found", (Object)users.size());
        if (users.isEmpty()) {
            log.debug("No users was found: {}", (Object)userOrEmail);
            return null;
        }
        User u = (User)users.get(0);
        if (!this.verifyPassword(u.getId(), userpass)) {
            log.debug("Password does not match: {}", (Object)u);
            return null;
        }
        if (!AuthLevelUtil.hasLoginLevel(u.getRights())) {
            log.debug("Not activated: {}", (Object)u);
            throw new OmException("error.notactivated");
        }
        log.debug("login user groups {}", u.getGroupUsers());
        if (u.getGroupUsers().isEmpty()) {
            log.debug("No Group assigned: {}", (Object)u);
            throw new OmException("error.nogroup");
        }
        u.setLastlogin(new Date());
        return this.update(u, u.getId());
    }

    public List<User> getByExpiredHash(long ttl) {
        return this.em.createNamedQuery("getUserByExpiredHash", User.class).setParameter("date", (Object)new Date(System.currentTimeMillis() - ttl)).getResultList();
    }
}

