/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.Context;
import opennlp.model.Event;
import opennlp.model.MutableContext;
import opennlp.model.OnePassDataIndexer;
import opennlp.model.Sequence;
import opennlp.model.SequenceStream;
import opennlp.model.SequenceStreamEventStream;
import opennlp.perceptron.PerceptronModel;

public class SimplePerceptronSequenceTrainer {
    private boolean printMessages = true;
    private int iterations;
    private SequenceStream sequenceStream;
    private int numEvents;
    private int numPreds;
    private int numOutcomes;
    private int[] outcomeList;
    private String[] outcomeLabels;
    double[] modelDistribution;
    private MutableContext[] averageParams;
    private Map<String, Integer> pmap;
    private Map<String, Integer> omap;
    private MutableContext[] params;
    private boolean useAverage;
    private int[][][] updates;
    private int VALUE = 0;
    private int ITER = 1;
    private int EVENT = 2;
    private int[] allOutcomesPattern;
    private String[] predLabels;
    int numSequences;

    public AbstractModel trainModel(int iterations, SequenceStream sequenceStream, int cutoff, boolean useAverage) throws IOException {
        this.iterations = iterations;
        this.sequenceStream = sequenceStream;
        OnePassDataIndexer di = new OnePassDataIndexer(new SequenceStreamEventStream(sequenceStream), cutoff, false);
        this.numSequences = 0;
        for (Sequence s : sequenceStream) {
            ++this.numSequences;
        }
        this.outcomeList = di.getOutcomeList();
        this.predLabels = di.getPredLabels();
        this.pmap = new HashMap<String, Integer>();
        for (int pli = 0; pli < this.predLabels.length; ++pli) {
            this.pmap.put(this.predLabels[pli], pli);
        }
        this.display("Incorporating indexed data for training...  \n");
        this.useAverage = useAverage;
        this.numEvents = di.getNumEvents();
        this.iterations = iterations;
        this.outcomeLabels = di.getOutcomeLabels();
        this.omap = new HashMap<String, Integer>();
        for (int oli = 0; oli < this.outcomeLabels.length; ++oli) {
            this.omap.put(this.outcomeLabels[oli], oli);
        }
        this.outcomeList = di.getOutcomeList();
        this.numPreds = this.predLabels.length;
        this.numOutcomes = this.outcomeLabels.length;
        if (useAverage) {
            this.updates = new int[this.numPreds][this.numOutcomes][3];
        }
        this.display("done.\n");
        this.display("\tNumber of Event Tokens: " + this.numEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        this.params = new MutableContext[this.numPreds];
        if (useAverage) {
            this.averageParams = new MutableContext[this.numPreds];
        }
        this.allOutcomesPattern = new int[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            this.allOutcomesPattern[oi] = oi;
        }
        for (int pi = 0; pi < this.numPreds; ++pi) {
            this.params[pi] = new MutableContext(this.allOutcomesPattern, new double[this.numOutcomes]);
            if (useAverage) {
                this.averageParams[pi] = new MutableContext(this.allOutcomesPattern, new double[this.numOutcomes]);
            }
            for (int aoi = 0; aoi < this.numOutcomes; ++aoi) {
                this.params[pi].setParameter(aoi, 0.0);
                if (!useAverage) continue;
                this.averageParams[pi].setParameter(aoi, 0.0);
            }
        }
        this.modelDistribution = new double[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        this.display("...done.\n");
        String[] updatedPredLabels = this.predLabels;
        if (useAverage) {
            return new PerceptronModel(this.averageParams, updatedPredLabels, this.outcomeLabels);
        }
        return new PerceptronModel(this.params, updatedPredLabels, this.outcomeLabels);
    }

    private void findParameters(int iterations) {
        this.display("Performing " + iterations + " iterations.\n");
        for (int i = 1; i <= iterations; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            this.nextIteration(i);
        }
        if (this.useAverage) {
            this.trainingStats(this.averageParams);
        } else {
            this.trainingStats(this.params);
        }
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }

    public void nextIteration(int iteration) {
        --iteration;
        int numCorrect = 0;
        int oei = 0;
        int si = 0;
        Map[] featureCounts = new Map[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            featureCounts[oi] = new HashMap();
        }
        PerceptronModel model = new PerceptronModel((Context[])this.params, this.predLabels, this.pmap, this.outcomeLabels);
        for (Sequence sequence : this.sequenceStream) {
            Event[] taggerEvents = this.sequenceStream.updateContext(sequence, model);
            Event[] events = sequence.getEvents();
            boolean update = false;
            int ei = 0;
            while (ei < events.length) {
                if (!taggerEvents[ei].getOutcome().equals(events[ei].getOutcome())) {
                    update = true;
                } else {
                    ++numCorrect;
                }
                ++ei;
                ++oei;
            }
            if (update) {
                Float c;
                float value;
                int ci;
                int oi;
                float[] values;
                String[] contextStrings;
                int oi2;
                for (oi2 = 0; oi2 < this.numOutcomes; ++oi2) {
                    featureCounts[oi2].clear();
                }
                ei = 0;
                while (ei < events.length) {
                    contextStrings = events[ei].getContext();
                    values = events[ei].getValues();
                    oi = this.omap.get(events[ei].getOutcome());
                    for (ci = 0; ci < contextStrings.length; ++ci) {
                        value = 1.0f;
                        if (values != null) {
                            value = values[ci];
                        }
                        c = (c = (Float)featureCounts[oi].get(contextStrings[ci])) == null ? Float.valueOf(value) : Float.valueOf(c.floatValue() + value);
                        featureCounts[oi].put(contextStrings[ci], c);
                    }
                    ++ei;
                    ++oei;
                }
                for (ei = 0; ei < taggerEvents.length; ++ei) {
                    contextStrings = taggerEvents[ei].getContext();
                    values = taggerEvents[ei].getValues();
                    oi = this.omap.get(taggerEvents[ei].getOutcome());
                    for (ci = 0; ci < contextStrings.length; ++ci) {
                        value = 1.0f;
                        if (values != null) {
                            value = values[ci];
                        }
                        if ((c = (c = (Float)featureCounts[oi].get(contextStrings[ci])) == null ? Float.valueOf(-1.0f * value) : Float.valueOf(c.floatValue() - value)).floatValue() == 0.0f) {
                            featureCounts[oi].remove(contextStrings[ci]);
                            continue;
                        }
                        featureCounts[oi].put(contextStrings[ci], c);
                    }
                }
                for (oi2 = 0; oi2 < this.numOutcomes; ++oi2) {
                    for (String feature : featureCounts[oi2].keySet()) {
                        Integer pi = this.pmap.get(feature);
                        if (pi == null) continue;
                        this.params[pi].updateParameter(oi2, ((Float)featureCounts[oi2].get(feature)).floatValue());
                        if (!this.useAverage) continue;
                        if (this.updates[pi][oi2][this.VALUE] != 0) {
                            this.averageParams[pi].updateParameter(oi2, this.updates[pi][oi2][this.VALUE] * (this.numSequences * (iteration - this.updates[pi][oi2][this.ITER]) + (si - this.updates[pi][oi2][this.EVENT])));
                        }
                        this.updates[pi.intValue()][oi2][this.VALUE] = (int)this.params[pi].getParameters()[oi2];
                        this.updates[pi.intValue()][oi2][this.ITER] = iteration;
                        this.updates[pi.intValue()][oi2][this.EVENT] = si;
                    }
                }
                model = new PerceptronModel((Context[])this.params, this.predLabels, this.pmap, this.outcomeLabels);
            }
            ++si;
        }
        double totIterations = (double)this.iterations * (double)si;
        if (this.useAverage && iteration == this.iterations - 1) {
            for (int pi = 0; pi < this.numPreds; ++pi) {
                double[] predParams = this.averageParams[pi].getParameters();
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    if (this.updates[pi][oi][this.VALUE] != 0) {
                        int n = oi;
                        predParams[n] = predParams[n] + (double)(this.updates[pi][oi][this.VALUE] * (this.numSequences * (this.iterations - this.updates[pi][oi][this.ITER]) - this.updates[pi][oi][this.EVENT]));
                    }
                    if (predParams[oi] == 0.0) continue;
                    int n = oi;
                    predParams[n] = predParams[n] / totIterations;
                    this.averageParams[pi].setParameter(oi, predParams[oi]);
                }
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }

    private void trainingStats(MutableContext[] params) {
        int numCorrect = 0;
        int oei = 0;
        for (Sequence sequence : this.sequenceStream) {
            Event[] taggerEvents = this.sequenceStream.updateContext(sequence, new PerceptronModel(params, this.predLabels, this.outcomeLabels));
            int ei = 0;
            while (ei < taggerEvents.length) {
                int max = this.omap.get(taggerEvents[ei].getOutcome());
                if (max == this.outcomeList[oei]) {
                    ++numCorrect;
                }
                ++ei;
                ++oei;
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }
}

