/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.IOException;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverterTool<T>
implements CmdLineTool {
    private String createHelpString(String format, String usage) {
        return "Usage: opennlp " + this.getName() + " " + format + " " + usage;
    }

    @Override
    public String getHelp() {
        return this.createHelpString("format", "...");
    }

    protected abstract ObjectStreamFactory<T> createStreamFactory(String var1);

    @Override
    public void run(String[] args) {
        String format = null;
        if (args.length <= 0) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        format = args[0];
        ObjectStreamFactory<T> streamFactory = this.createStreamFactory(format);
        if (streamFactory == null) {
            System.err.println("Format is unkown: " + format);
            throw new TerminateToolException(-1);
        }
        String[] formatArgs = new String[args.length - 1];
        System.arraycopy(args, 1, formatArgs, 0, formatArgs.length);
        if (!streamFactory.validateArguments(formatArgs)) {
            System.err.println(this.createHelpString(format, streamFactory.getUsage()));
            throw new TerminateToolException(-1);
        }
        ObjectStream<T> sampleStream = streamFactory.create(formatArgs);
        try {
            T sample;
            while ((sample = sampleStream.read()) != null) {
                System.out.println(sample.toString());
            }
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            if (sampleStream != null) {
                try {
                    sampleStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

